/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.init;

import com.google.common.collect.Lists;
import dev.architectury.core.item.ArchitecturyMobBucketItem;
import dev.architectury.core.item.ArchitecturyRecordItem;
import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.fuel.FuelRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.crafting.SuspiciousStewListing;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMTab;
import party.lemons.biomemakeover.item.DisabledSpawnEggItem;
import party.lemons.biomemakeover.item.EctoplasmItem;
import party.lemons.biomemakeover.item.EnchantedTotemItem;
import party.lemons.biomemakeover.item.GlowfishBucketItem;
import party.lemons.biomemakeover.item.HatItem;
import party.lemons.biomemakeover.item.LightningBottleItem;
import party.lemons.biomemakeover.item.StuntPowderItem;
import party.lemons.biomemakeover.util.loot.BetterLootTableReference;
import party.lemons.taniwha.data.trade.listing.TradeTypes;
import party.lemons.taniwha.hooks.PotteryPatternHooks;
import party.lemons.taniwha.item.ArmorBuilder;
import party.lemons.taniwha.item.ItemHelper;
import party.lemons.taniwha.item.types.FakeItem;
import party.lemons.taniwha.item.types.TItem;
import party.lemons.taniwha.item.types.TItemNameBlockItem;

public class BMItems {
    public static final List<Supplier<Item>> ROOTLING_BUDS = Lists.newArrayList();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_256913_);
    public static final DeferredRegister<LootPoolEntryType> LOOT_POOL_ENTRIES = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_257032_);
    public static final DeferredRegister<TradeTypes.TradeType<?>> TRADE_TYPES = DeferredRegister.create((String)"biomemakeover", (ResourceKey)TradeTypes.KEY);
    public static final DeferredRegister<String> DECORATED_POT_PATTERNS = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_271200_);
    public static final TagKey<Item> CURSE_FUEL = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomeMakeover.ID("curse_fuel"));
    public static final TagKey<Item> ADDITIONAL_CAMEL_FOOD = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomeMakeover.ID("additional_camel_food"));
    public static final TagKey<Item> BARREL_CACTUS_IMMUNE = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomeMakeover.ID("barrel_cactus_immune"));
    public static final TagKey<Item> HELMIT_CRAB_EXCEPTION = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomeMakeover.ID("helmit_crab_exception"));
    public static final TagKey<Item> WITCH_HATS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomeMakeover.ID("witch_hats"));
    public static final TagKey<Item> SCUTTLER_FOOD = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomeMakeover.ID("scuttler_food"));
    public static final TagKey<Item> HEALS_STONE_GOLEM = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomeMakeover.ID("heals_stone_golem"));
    public static final FoodProperties GLOWSHROOM_SOUP_FOOD = new FoodProperties.Builder().m_38765_().m_38758_(0.6f).m_38760_(5).m_38762_(new MobEffectInstance(MobEffects.f_19611_, 1200, 0), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19619_, 1200, 0), 1.0f).m_38767_();
    public static final FoodProperties GLOWFISH_FOOD = new FoodProperties.Builder().m_38765_().m_38758_(0.1f).m_38760_(1).m_38762_(new MobEffectInstance(MobEffects.f_19611_, 200, 0), 0.5f).m_38762_(new MobEffectInstance(MobEffects.f_19619_, 200, 0), 0.5f).m_38767_();
    public static final FoodProperties COOKED_GLOWFISH_FOOD = new FoodProperties.Builder().m_38765_().m_38758_(0.6f).m_38760_(5).m_38762_(new MobEffectInstance(MobEffects.f_19611_, 200, 0), 0.5f).m_38762_(new MobEffectInstance(MobEffects.f_19619_, 200, 0), 0.5f).m_38767_();
    public static final FoodProperties COOKED_TOAD_FOOD = new FoodProperties.Builder().m_38760_(6).m_38758_(0.6f).m_38757_().m_38767_();
    public static final FoodProperties RAW_TOAD_FOOD = new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38757_().m_38767_();
    public static final FoodProperties RAW_BULBUS_ROOT_FOOD = new FoodProperties.Builder().m_38760_(2).m_38758_(0.6f).m_38767_();
    public static final FoodProperties BULBUS_ROOT_FOOD = new FoodProperties.Builder().m_38760_(5).m_38758_(0.8f).m_38767_();
    public static final FoodProperties RAW_CRAB_FOOD = new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38767_();
    public static final FoodProperties COOKED_CRAB_FOOD = new FoodProperties.Builder().m_38760_(5).m_38758_(0.6f).m_38767_();
    public static final FoodProperties CRAB_CHOWDER_FOOD = new FoodProperties.Builder().m_38760_(11).m_38758_(0.9f).m_38767_();
    public static final ArmorMaterial CLADDED_MATERIAL = new CladdedArmorMaterial();
    public static final RegistrySupplier<Item> GLOWSHROOM_STEW = BMItems.registerItem("glowshroom_stew", () -> new SuspiciousStewItem(BMItems.properties().m_41487_(1).m_41495_(Items.f_42399_).m_41489_(GLOWSHROOM_SOUP_FOOD)));
    public static final RegistrySupplier<Item> GLOWFISH = BMItems.registerItem("glowfish", () -> new Item(BMItems.properties().m_41489_(GLOWFISH_FOOD)));
    public static final RegistrySupplier<Item> COOKED_GLOWFISH = BMItems.registerItem("cooked_glowfish", () -> new Item(BMItems.properties().m_41489_(COOKED_GLOWFISH_FOOD)));
    public static final RegistrySupplier<Item> RAW_TOAD = BMItems.registerHiddenItem("raw_toad", () -> new Item(BMItems.properties().m_41489_(RAW_TOAD_FOOD)));
    public static final RegistrySupplier<Item> COOKED_TOAD = BMItems.registerHiddenItem("cooked_toad", () -> new Item(BMItems.properties().m_41489_(COOKED_TOAD_FOOD)));
    public static final RegistrySupplier<Item> BULBUS_ROOT = BMItems.registerItem("bulbus_root", () -> new TItem(BMItems.properties().m_41489_(RAW_BULBUS_ROOT_FOOD)));
    public static final RegistrySupplier<Item> ROASTED_BULBUS_ROOT = BMItems.registerItem("roasted_bulbus_root", () -> new Item(BMItems.properties().m_41489_(BULBUS_ROOT_FOOD)));
    public static final RegistrySupplier<Item> RAW_CRAB = BMItems.registerItem("raw_crab", () -> new TItem(BMItems.properties().m_41489_(RAW_CRAB_FOOD)));
    public static final RegistrySupplier<Item> COOKED_CRAB = BMItems.registerItem("cooked_crab", () -> new TItem(BMItems.properties().m_41489_(COOKED_CRAB_FOOD)));
    public static final RegistrySupplier<Item> CRAB_CHOWDER = BMItems.registerItem("crab_chowder", () -> new BowlFoodItem(BMItems.properties().m_41489_(CRAB_CHOWDER_FOOD).m_41487_(1)));
    public static final RegistrySupplier<Item> COWBOY_HAT = BMItems.registerItem("cowboy_hat", () -> new HatItem(BiomeMakeover.ID("textures/misc/cowboy_hat.png"), BMItems.properties()));
    public static final RegistrySupplier<Item> WITCH_HAT = BMItems.registerItem("witch_hat", () -> new HatItem(BiomeMakeover.ID("textures/misc/witch_hat.png"), BMItems.properties()));
    public static final RegistrySupplier<Item> MAGENTA_BUD = BMItems.registerItem("magenta_bud", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> PINK_BUD = BMItems.registerItem("pink_bud", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> BLUE_BUD = BMItems.registerRootlingBud("blue_bud", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> BROWN_BUD = BMItems.registerRootlingBud("brown_bud", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> CYAN_BUD = BMItems.registerRootlingBud("cyan_bud", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> GRAY_BUD = BMItems.registerRootlingBud("gray_bud", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> LIGHT_BLUE_BUD = BMItems.registerRootlingBud("light_blue_bud", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> PURPLE_BUD = BMItems.registerRootlingBud("purple_bud", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> SCUTTLER_TAIL = BMItems.registerItem("scuttler_tail", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> ECTOPLASM = BMItems.registerItem("ectoplasm", () -> new EctoplasmItem(BMItems.properties()));
    public static final RegistrySupplier<Item> LIGHTNING_BOTTLE = BMItems.registerItem("lightning_bottle", () -> new LightningBottleItem(BMItems.properties()));
    public static final RegistrySupplier<Item> DRAGONFLY_WINGS = BMItems.registerHiddenItem("dragonfly_wings", () -> new Item(BMItems.properties()));
    public static final RegistrySupplier<Item> BAT_WING = BMItems.registerHiddenItem("bat_wing", () -> new Item(BMItems.properties()));
    public static final RegistrySupplier<Item> BLIGHTBAT_WING = BMItems.registerHiddenItem("blightbat_wing", () -> new Item(BMItems.properties()));
    public static final RegistrySupplier<Item> WART = BMItems.registerHiddenItem("wart", () -> new Item(BMItems.properties()));
    public static final RegistrySupplier<Item> SOUL_EMBERS = BMItems.registerItem("soul_embers", () -> new Item(BMItems.properties()));
    public static final RegistrySupplier<Item> ILLUNITE_SHARD = BMItems.registerItem("illunite_shard", () -> new Item(BMItems.properties()));
    public static final RegistrySupplier<Item> ROOTLING_SEEDS = BMItems.registerItem("rootling_seeds", () -> new TItemNameBlockItem((Block)BMBlocks.ROOTLING_CROP.get(), BMItems.properties()));
    public static final RegistrySupplier<Item> MOTH_SCALES = BMItems.registerItem("moth_scales", () -> new Item(BMItems.properties()));
    public static final RegistrySupplier<Item> STUNT_POWDER = BMItems.registerItem("stunt_powder", () -> new StuntPowderItem(BMItems.properties()));
    public static final RegistrySupplier<Item> CRUDE_CLADDING = BMItems.registerItem("crude_cladding", () -> new Item(BMItems.properties()));
    public static final RegistrySupplier<Item> CRUDE_FRAGMENT = BMItems.registerItem("crude_fragment", () -> new Item(BMItems.properties()));
    public static final RegistrySupplier<Item> CLADDING_UPGRADE_SMITHING_TEMPLATE = BMItems.registerItem("cladding_upgrade_smithing_template", BMItems::createCladdingTemplate);
    public static final RegistrySupplier<Item> CRACKED_BRICK = BMItems.registerItem("cracked_brick", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> REFINED_POTTERY_SHERD = BMItems.registerItem("refined_pottery_sherd", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> WORKER_POTTERY_SHERD = BMItems.registerItem("worker_pottery_sherd", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> WHINNY_POTTERY_SHERD = BMItems.registerItem("whinny_pottery_sherd", () -> new TItem(BMItems.properties()));
    public static final RegistrySupplier<Item> ENCHANTED_TOTEM = BMItems.registerItem("enchanted_totem", () -> new EnchantedTotemItem(BMItems.properties().m_41497_(Rarity.EPIC).m_41487_(1)));
    public static final RegistrySupplier<Item> BUTTON_MUSHROOMS_MUSIC_DISK = BMItems.registerItem("button_mushrooms_music_disk", () -> new ArchitecturyRecordItem(14, BMEffects.BUTTON_MUSHROOMS, BMItems.properties().m_41487_(1).m_41497_(Rarity.RARE), 115));
    public static final RegistrySupplier<Item> GHOST_TOWN_MUSIC_DISK = BMItems.registerItem("ghost_town_music_disk", () -> new ArchitecturyRecordItem(15, BMEffects.GHOST_TOWN, BMItems.properties().m_41487_(1).m_41497_(Rarity.RARE), 270));
    public static final RegistrySupplier<Item> SWAMP_JIVES_MUSIC_DISK = BMItems.registerItem("swamp_jives_music_disk", () -> new ArchitecturyRecordItem(1, BMEffects.SWAMP_JIVES, BMItems.properties().m_41487_(1).m_41497_(Rarity.RARE), 277));
    public static final RegistrySupplier<Item> RED_ROSE_MUSIC_DISK = BMItems.registerItem("red_rose_music_disk", () -> new ArchitecturyRecordItem(2, BMEffects.RED_ROSE, BMItems.properties().m_41487_(1).m_41497_(Rarity.RARE), 135));
    public static final RegistrySupplier<Item> GLOWFISH_BUCKET = BMItems.registerItem("glowfish_bucket", () -> new GlowfishBucketItem((Supplier<? extends EntityType<?>>)BMEntities.GLOWFISH, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, BMItems.properties().m_41487_(1)));
    public static final RegistrySupplier<Item> TADPOLE_BUCKET = BMItems.registerHiddenItem("tadpole_bucket", () -> new ArchitecturyMobBucketItem(BMEntities.TADPOLE, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, BMItems.properties().m_41487_(1)));
    public static final RegistrySupplier<Item> GLOWFISH_SPAWN_EGG = BMItems.registerItem("glowfish_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.GLOWFISH, 14590570, 14590570, BMItems.properties()));
    public static final RegistrySupplier<Item> MUSHROOM_TRADER_SPAWN_EGG = BMItems.registerItem("mushroom_trader_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.MUSHROOM_TRADER, 11773067, 11773067, BMItems.properties()));
    public static final RegistrySupplier<Item> BLIGHTBAT_SPAWN_EGG = BMItems.registerHiddenItem("blightbat_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.BLIGHTBAT, 11403519, 14655484, BMItems.properties()));
    public static final RegistrySupplier<Item> GHOST_SPAWN_EGG = BMItems.registerItem("ghost_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.GHOST, 0x566B6B, 11927550, BMItems.properties()));
    public static final RegistrySupplier<Item> SCUTTLER_SPAWN_EGG = BMItems.registerItem("scuttler_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.SCUTTLER, 4666407, 8414547, BMItems.properties()));
    public static final RegistrySupplier<Item> COWBOY_SPAWN_EGG = BMItems.registerItem("cowboy_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.COWBOY, 10207938, 7028537, BMItems.properties()));
    public static final RegistrySupplier<Item> TOAD_SPAWN_EGG = BMItems.registerHiddenItem("toad_spawn_egg", () -> new DisabledSpawnEggItem(BMEntities.TOAD, 4948562, 6376755, BMItems.properties()));
    public static final RegistrySupplier<Item> TADPOLE_SPAWN_EGG = BMItems.registerHiddenItem("tadpole_spawn_egg", () -> new DisabledSpawnEggItem(BMEntities.TADPOLE, 6783563, 6376755, BMItems.properties()));
    public static final RegistrySupplier<Item> DRAGONFLY_SPAWN_EGG = BMItems.registerItem("dragonfly_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.DRAGONFLY, 13088308, 15920054, BMItems.properties()));
    public static final RegistrySupplier<Item> LIGHTNING_BUG_SPAWN_EGG = BMItems.registerItem("lightning_bug_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.LIGHTNING_BUG_ALTERNATE, 6474081, 9890785, BMItems.properties()));
    public static final RegistrySupplier<Item> DECAYED_SPAWN_EGG = BMItems.registerItem("decayed_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.DECAYED, 3043432, 4866100, BMItems.properties()));
    public static final RegistrySupplier<Item> OWL_SPAWN_EGG = BMItems.registerItem("owl_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.OWL, 3157543, 6511689, BMItems.properties()));
    public static final RegistrySupplier<Item> ROOTLING_SPAWN_EGG = BMItems.registerItem("rootling_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.ROOTLING, 2828580, 10582815, BMItems.properties()));
    public static final RegistrySupplier<Item> MOTH_SPAWN_EGG = BMItems.registerItem("moth_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.MOTH, 8214169, 9866908, BMItems.properties()));
    public static final RegistrySupplier<Item> HELMIT_CRAB_SPAWN_EGG = BMItems.registerItem("helmit_crab_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.HELMIT_CRAB, 12395808, 15432549, BMItems.properties()));
    public static final RegistrySupplier<Item> STONE_GOLEM_SPAWN_EGG = BMItems.registerItem("stone_golem_spawn_egg", () -> new ArchitecturySpawnEggItem(BMEntities.STONE_GOLEM, 0xB0B0B0, 8034710, BMItems.properties()));
    public static final RegistrySupplier<Item> ICON_ITEM = BMItems.registerItem("icon_item", FakeItem::new, false);
    public static final RegistrySupplier<TradeTypes.TradeType<?>> SUSPICIOUS_STEW_TRADE = TRADE_TYPES.register(BiomeMakeover.ID("sussy_stew"), () -> new TradeTypes.TradeType(SuspiciousStewListing.CODEC));
    public static final RegistrySupplier<String> CRACKED_PATTERN = DECORATED_POT_PATTERNS.register(BiomeMakeover.ID("cracked_pottery_pattern"), () -> "cracked_pottery_pattern");
    public static final RegistrySupplier<String> REFINED_PATTERN = DECORATED_POT_PATTERNS.register(BiomeMakeover.ID("refined_pottery_pattern"), () -> "refined_pottery_pattern");
    public static final RegistrySupplier<String> WORKER_PATTERN = DECORATED_POT_PATTERNS.register(BiomeMakeover.ID("worker_pottery_pattern"), () -> "worker_pottery_pattern");
    public static final RegistrySupplier<String> WHINNY_PATTERN = DECORATED_POT_PATTERNS.register(BiomeMakeover.ID("whinny_pottery_pattern"), () -> "whinny_pottery_pattern");
    public static final RegistrySupplier<LootPoolEntryType> BETTER_LOOTTABLE_REFERENCE = LOOT_POOL_ENTRIES.register(BiomeMakeover.ID("loot_table"), () -> new LootPoolEntryType((Serializer)new BetterLootTableReference.Serializer()));

    public static void init() {
        BMEntities.ATT_PROJECTILE_RESISTANCE.listen(a -> {
            ArmorBuilder CLADDED_ARMOR_BUILDER = ArmorBuilder.create((ArmorMaterial)CLADDED_MATERIAL).attribute("Armor Proj Res", (Attribute)BMEntities.ATT_PROJECTILE_RESISTANCE.get(), 1.5, AttributeModifier.Operation.ADDITION);
            RegistrySupplier<Item> CLADDED_HELMET = BMItems.registerItem("cladded_helmet", CLADDED_ARMOR_BUILDER.build(ArmorItem.Type.HELMET, BMItems.properties()));
            RegistrySupplier<Item> CLADDED_CHESTPLATE = BMItems.registerItem("cladded_chestplate", CLADDED_ARMOR_BUILDER.build(ArmorItem.Type.CHESTPLATE, BMItems.properties()));
            RegistrySupplier<Item> CLADDED_LEGGINGS = BMItems.registerItem("cladded_leggings", CLADDED_ARMOR_BUILDER.build(ArmorItem.Type.LEGGINGS, BMItems.properties()));
            RegistrySupplier<Item> CLADDED_BOOTS = BMItems.registerItem("cladded_boots", CLADDED_ARMOR_BUILDER.build(ArmorItem.Type.BOOTS, BMItems.properties()));
        });
        ICON_ITEM.listen(i -> {
            FuelRegistry.register((int)10000, (ItemLike[])new ItemLike[]{((Block)BMBlocks.DRIED_PEAT.get()).m_5456_()});
            FuelRegistry.register((int)220, (ItemLike[])new ItemLike[]{((Block)BMBlocks.REED_THATCH.get()).m_5456_()});
            PotteryPatternHooks.addPotteryPatternItem((Item)((Item)REFINED_POTTERY_SHERD.get()), (ResourceLocation)BiomeMakeover.ID("refined_pottery_pattern"));
            PotteryPatternHooks.addPotteryPatternItem((Item)((Item)WORKER_POTTERY_SHERD.get()), (ResourceLocation)BiomeMakeover.ID("worker_pottery_pattern"));
            PotteryPatternHooks.addPotteryPatternItem((Item)((Item)WHINNY_POTTERY_SHERD.get()), (ResourceLocation)BiomeMakeover.ID("whinny_pottery_pattern"));
            PotteryPatternHooks.addPotteryPatternItem((Item)((Item)CRACKED_BRICK.get()), (ResourceLocation)BiomeMakeover.ID("cracked_pottery_pattern"));
        });
        ITEMS.register();
        TRADE_TYPES.register();
        DECORATED_POT_PATTERNS.register();
        LOOT_POOL_ENTRIES.register();
    }

    private static RegistrySupplier<Item> registerItem(String id, Supplier<Item> item) {
        return BMItems.registerItem(id, item, true);
    }

    private static RegistrySupplier<Item> registerItem(String id, Supplier<Item> item, boolean tab) {
        RegistrySupplier registrySupplier = ItemHelper.registerItem(ITEMS, (ResourceLocation)BiomeMakeover.ID(id), item);
        if (tab) {
            CreativeTabRegistry.append(BMTab.TAB, (Supplier[])new RegistrySupplier[]{registrySupplier});
        }
        return registrySupplier;
    }

    private static RegistrySupplier<Item> registerRootlingBud(String id, Supplier<Item> item) {
        RegistrySupplier<Item> registered = BMItems.registerItem(id, item);
        ROOTLING_BUDS.add((Supplier<Item>)registered);
        return registered;
    }

    private static RegistrySupplier<Item> registerHiddenItem(String id, Supplier<Item> item) {
        return BMItems.registerItem(id, item, false);
    }

    public static Item.Properties properties() {
        return new Item.Properties();
    }

    private static Item createCladdingTemplate() {
        ChatFormatting DESCRIPTION_FORMAT = ChatFormatting.BLUE;
        ChatFormatting TITLE_FORMAT = ChatFormatting.GRAY;
        return new SmithingTemplateItem((Component)Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)BiomeMakeover.ID("smithing_template.cladding_upgrade.applies_to"))).m_130940_(DESCRIPTION_FORMAT), (Component)Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)BiomeMakeover.ID("smithing_template.cladding_upgrade.ingredients"))).m_130940_(DESCRIPTION_FORMAT), (Component)Component.m_237115_((String)Util.m_137492_((String)"upgrade", (ResourceLocation)BiomeMakeover.ID("cladding_upgrade"))).m_130940_(TITLE_FORMAT), (Component)Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)BiomeMakeover.ID("smithing_template.cladding_upgrade.base_slot_description"))), (Component)Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)BiomeMakeover.ID("smithing_template.cladding_upgrade.additions_slot_description"))), List.of(new ResourceLocation("item/empty_armor_slot_helmet"), new ResourceLocation("item/empty_armor_slot_chestplate"), new ResourceLocation("item/empty_armor_slot_leggings"), new ResourceLocation("item/empty_armor_slot_boots")), List.of(BiomeMakeover.ID("item/empty_slot_crude_cladding")));
    }

    private static class CladdedArmorMaterial
    implements ArmorMaterial {
        private CladdedArmorMaterial() {
        }

        public int m_266425_(ArmorItem.Type type) {
            return ArmorMaterials.IRON.m_266425_(type);
        }

        public int m_7366_(ArmorItem.Type type) {
            return ArmorMaterials.IRON.m_7366_(type);
        }

        public int m_6646_() {
            return 15;
        }

        public SoundEvent m_7344_() {
            return ArmorMaterials.LEATHER.m_7344_();
        }

        public Ingredient m_6230_() {
            return ArmorMaterials.LEATHER.m_6230_();
        }

        public String m_6082_() {
            return "biomemakeover:cladded";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.07f;
        }
    }
}

