/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.StoneGolemEntity;
import party.lemons.biomemakeover.entity.render.StoneGolemModel;

public class StoneGolemRender
extends MobRenderer<StoneGolemEntity, StoneGolemModel> {
    public static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/stone_golem/stone_golem.png");

    public StoneGolemRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new StoneGolemModel(context.m_174023_(StoneGolemModel.LAYER_LOCATION)), 1.0f);
        this.m_115326_(new StoneGolemItemLayer(this, context.m_234598_()));
        this.m_115326_(new StoneGolemCrackLayer(this));
    }

    public void render(StoneGolemEntity entity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        boolean visible;
        poseStack.m_85836_();
        if (StoneGolemRender.m_194453_((LivingEntity)entity)) {
            poseStack.m_252880_(0.0f, entity.m_20206_() + 0.1f, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
        boolean isInvis = !(visible = this.m_5933_((LivingEntity)entity)) && !entity.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        boolean outline = Minecraft.m_91087_().m_91314_((Entity)entity);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.0, (double)-1.501f, 0.0);
        RenderType renderLayer = this.m_7225_((LivingEntity)entity, visible, isInvis, outline);
        if (renderLayer != null) {
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(renderLayer);
            int overlay = StoneGolemRender.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, g));
            ((StoneGolemModel)this.m_7200_()).renderBaseToBuffer(poseStack, vertexConsumer, i, overlay, 1.0f, 1.0f, 1.0f, isInvis ? 0.15f : 1.0f);
        }
        poseStack.m_85849_();
        super.m_7392_((Mob)entity, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(StoneGolemEntity entity) {
        return TEXTURE;
    }

    private class StoneGolemItemLayer
    extends RenderLayer<StoneGolemEntity, StoneGolemModel> {
        private final ItemInHandRenderer itemInHandRenderer;

        public StoneGolemItemLayer(StoneGolemRender stoneGolemRender2, ItemInHandRenderer itemInHandRenderer) {
            super((RenderLayerParent)stoneGolemRender2);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, StoneGolemEntity entity, float f, float g, float h, float j, float k, float l) {
            ItemStack rightHand;
            boolean rightHanded = entity.m_5737_() == HumanoidArm.RIGHT;
            ItemStack leftHand = rightHanded ? entity.m_21206_() : entity.m_21205_();
            ItemStack itemStack = rightHand = rightHanded ? entity.m_21205_() : entity.m_21206_();
            if (!leftHand.m_41619_() || !rightHand.m_41619_()) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.5f, 0.0f);
                this.renderItem(entity, rightHand, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, multiBufferSource, i);
                this.renderItem(entity, leftHand, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, multiBufferSource, i);
                poseStack.m_85849_();
            }
        }

        private void renderItem(StoneGolemEntity entity, ItemStack stack, ItemDisplayContext transformationMode, HumanoidArm arm, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
            if (!stack.m_41619_()) {
                poseStack.m_85836_();
                ((ArmedModel)this.m_117386_()).m_6002_(arm, poseStack);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                boolean isLeft = arm == HumanoidArm.LEFT;
                poseStack.m_85837_((double)((isLeft ? -0.7f : 0.7f) / 16.0f), 0.125, -1.75);
                this.itemInHandRenderer.m_269530_((LivingEntity)entity, stack, transformationMode, isLeft, poseStack, multiBufferSource, light);
                poseStack.m_85849_();
            }
        }
    }

    private static class StoneGolemCrackLayer
    extends RenderLayer<StoneGolemEntity, StoneGolemModel> {
        private static final Map<IronGolem.Crackiness, ResourceLocation> DAMAGE_TO_TEXTURE = ImmutableMap.of((Object)IronGolem.Crackiness.LOW, (Object)BiomeMakeover.ID("textures/entity/stone_golem/stone_golem_damaged_light.png"), (Object)IronGolem.Crackiness.MEDIUM, (Object)BiomeMakeover.ID("textures/entity/stone_golem/stone_golem_damaged_medium.png"), (Object)IronGolem.Crackiness.HIGH, (Object)BiomeMakeover.ID("textures/entity/stone_golem/stone_golem_damaged_high.png"));

        public StoneGolemCrackLayer(StoneGolemRender stoneGolemRender) {
            super((RenderLayerParent)stoneGolemRender);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, StoneGolemEntity entity, float f, float g, float h, float j, float k, float l) {
            IronGolem.Crackiness crack;
            if (!entity.m_20145_() && (crack = entity.getCrack()) != IronGolem.Crackiness.NONE) {
                ResourceLocation identifier = DAMAGE_TO_TEXTURE.get(crack);
                StoneGolemCrackLayer.m_117376_((EntityModel)this.m_117386_(), (ResourceLocation)identifier, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

