/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.ScuttlerEntity;

public class ScuttlerModel
extends AgeableListModel<ScuttlerEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BiomeMakeover.ID("scuttler"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart left_front_leg;
    private final ModelPart right_front_leg;
    private final ModelPart right_back_leg;
    private final ModelPart left_back_leg;
    private final ModelPart tail;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart rattler;

    public ScuttlerModel(ModelPart root) {
        super(true, 8.0f, 2.0f);
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.jaw = root.m_171324_("head").m_171324_("jaw");
        this.left_front_leg = root.m_171324_("body").m_171324_("left_front_leg");
        this.right_front_leg = root.m_171324_("body").m_171324_("right_front_leg");
        this.right_back_leg = root.m_171324_("body").m_171324_("right_back_leg");
        this.left_back_leg = root.m_171324_("body").m_171324_("left_back_leg");
        this.tail = root.m_171324_("body").m_171324_("tail");
        this.tail2 = root.m_171324_("body").m_171324_("tail").m_171324_("tail2");
        this.tail3 = root.m_171324_("body").m_171324_("tail").m_171324_("tail2").m_171324_("tail3");
        this.rattler = root.m_171324_("body").m_171324_("tail").m_171324_("tail2").m_171324_("tail3").m_171324_("rattler");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -1.5f, 0.0f, 6.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 9).m_171488_(-0.5f, -2.5f, 1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 9).m_171488_(-0.5f, -2.5f, 5.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 9).m_171488_(-0.5f, -2.5f, 9.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)22.0f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_front_leg = body.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(24, 5).m_171488_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)2.0f, (float)-0.0873f, (float)1.1345f, (float)0.0436f));
        PartDefinition right_front_leg = body.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(24, 5).m_171488_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)1.0f, (float)2.0f, (float)-0.0873f, (float)2.0071f, (float)-0.0436f));
        PartDefinition right_back_leg = body.m_171599_("right_back_leg", CubeListBuilder.m_171558_().m_171514_(26, 15).m_171488_(-1.0f, -0.7978f, -1.2235f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)1.1566f, (float)9.1895f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_back_leg = body.m_171599_("left_back_leg", CubeListBuilder.m_171558_().m_171514_(26, 15).m_171488_(-1.0f, -0.7978f, -1.2235f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.1566f, (float)9.1895f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-2.0f, -1.0f, -0.5f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)12.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5448f, (float)3.5642f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(13, 25).m_171488_(-1.0f, -1.4605f, -0.3184f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0783f, (float)1.2687f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rattler = tail3.m_171599_("rattler", CubeListBuilder.m_171558_().m_171514_(15, 17).m_171488_(-1.5f, -1.4463f, -0.0312f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.6005f, (float)1.5858f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-2.5f, -2.0f, -4.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 9).m_171488_(-0.5f, -3.0f, -3.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)22.0f, (float)-4.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(ScuttlerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadyRot, float headxRot) {
        this.setRotationAngle(this.body, 0.2618f, 0.0f, 0.0f);
        this.setRotationAngle(this.head, -0.2618f, 0.0f, 0.0f);
        this.setRotationAngle(this.jaw, 0.1309f, 0.0f, 0.0f);
        this.setRotationAngle(this.left_front_leg, -0.0873f, 1.1345f, 0.0436f);
        this.setRotationAngle(this.right_front_leg, -0.0873f, 2.0071f, -0.0436f);
        this.setRotationAngle(this.right_back_leg, -0.2618f, 0.0f, 0.0f);
        this.setRotationAngle(this.left_back_leg, -0.2618f, 0.0f, 0.0f);
        this.setRotationAngle(this.tail, 0.6981f, 0.0f, 0.0f);
        this.setRotationAngle(this.tail2, 0.4363f, 0.0f, 0.0f);
        this.setRotationAngle(this.tail3, 0.7854f, 0.0f, 0.0f);
        this.setRotationAngle(this.rattler, 0.1309f, 0.0f, 0.0f);
        float pi = (float)Math.PI;
        this.head.f_104203_ = -0.2618f + headxRot * 0.0175f;
        this.head.f_104204_ = netHeadyRot * 0.0175f;
        this.right_back_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.66f)) * 1.4f * limbSwingAmount;
        this.left_back_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.66f + pi)) * 1.4f * limbSwingAmount;
        this.right_front_leg.f_104204_ = pi + -(1.1345f + Mth.m_14089_((float)(limbSwing * 0.66f)) * 1.0f * limbSwingAmount);
        this.left_front_leg.f_104204_ = 1.1345f + Mth.m_14089_((float)(limbSwing * 0.66f)) * 1.0f * limbSwingAmount;
        this.tail.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.66f + pi)) * 0.7f * limbSwingAmount;
        this.tail3.f_104205_ = -Mth.m_14089_((float)(limbSwing * 0.66f + pi)) * 0.5f * limbSwingAmount;
        this.rattler.f_104205_ = -Mth.m_14089_((float)(limbSwing * 0.66f + pi)) * 0.7f * limbSwingAmount;
        this.rattler.f_104203_ = -Mth.m_14089_((float)(limbSwing * 0.66f + pi)) * 1.0f * (limbSwingAmount / 2.0f);
        this.tail.f_104205_ += Mth.m_14031_((float)entity.rattleTime);
        this.tail3.f_104205_ += -Mth.m_14031_((float)entity.rattleTime);
        this.rattler.f_104205_ += -Mth.m_14031_((float)entity.rattleTime);
        if (((Boolean)entity.m_20088_().m_135370_(ScuttlerEntity.EATING)).booleanValue()) {
            this.head.f_104203_ = -Mth.m_14089_((float)((float)entity.eatTime * 0.6f + pi)) * 0.3f;
        }
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }
}

