/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import party.lemons.biomemakeover.util.RandomUtil;

public class BetterFollowOwnerGoal
extends Goal {
    protected final TamableAnimal tameable;
    protected LivingEntity owner;
    protected final Level level;
    protected final double speed;
    protected final PathNavigation navigation;
    protected int updateCountdownTicks;
    protected final float maxDistance;
    protected final float minDistance;
    protected float oldWaterPathfindingPenalty;
    protected final boolean leavesAllowed;

    public BetterFollowOwnerGoal(TamableAnimal tameable, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
        this.tameable = tameable;
        this.level = tameable.m_9236_();
        this.speed = speed;
        this.navigation = tameable.m_21573_();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.leavesAllowed = leavesAllowed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(tameable.m_21573_() instanceof GroundPathNavigation) && !(tameable.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.tameable.m_269323_();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.m_5833_()) {
            return false;
        }
        if (this.tameable.m_21827_()) {
            return false;
        }
        if (this.tameable.m_20280_((Entity)livingEntity) < (double)(this.minDistance * this.minDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.tameable.m_21827_()) {
            return false;
        }
        return this.tameable.m_20280_((Entity)this.owner) > (double)(this.maxDistance * this.maxDistance);
    }

    public void m_8056_() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.tameable.m_21439_(BlockPathTypes.WATER);
        this.tameable.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.tameable.m_21441_(BlockPathTypes.WATER, this.oldWaterPathfindingPenalty);
    }

    public void m_8037_() {
        this.tameable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tameable.m_8132_());
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = 10;
            if (!this.tameable.m_21523_() && !this.tameable.m_20159_()) {
                if (this.tameable.m_20280_((Entity)this.owner) >= 144.0) {
                    this.tryTeleport();
                } else {
                    this.startFollowing();
                }
            }
        }
    }

    protected void startFollowing() {
        this.navigation.m_5624_((Entity)this.owner, this.speed);
    }

    protected void tryTeleport() {
        BlockPos blockPos = this.owner.m_20097_();
        for (int i = 0; i < 10; ++i) {
            int j = RandomUtil.randomRange(-3, 3);
            int k = RandomUtil.randomRange(-1, 1);
            int l = RandomUtil.randomRange(-3, 3);
            boolean didTeleport = this.tryTeleportTo(blockPos.m_123341_() + j, blockPos.m_123342_() + k, blockPos.m_123343_() + l);
            if (!didTeleport) continue;
            return;
        }
    }

    protected boolean tryTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.tameable.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.tameable.f_19860_, this.tameable.f_19859_);
        this.navigation.m_26573_();
        return true;
    }

    protected boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes pathNodeType = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathNodeType != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockState = this.level.m_8055_(pos.m_7495_());
        if (!this.leavesAllowed && blockState.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos = pos.m_121996_((Vec3i)this.tameable.m_20097_());
        return this.level.m_45756_((Entity)this.tameable, this.tameable.m_20191_().m_82338_(blockPos));
    }
}

