/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator;

import com.google.common.collect.Lists;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;

public class AdjudicatorRoomListener {
    private static List<AdjudicatorEntity> activeAdjudicators = Lists.newArrayList();

    public static void init() {
        BlockEvent.BREAK.register((level, pos, state, player, val) -> {
            AdjudicatorRoomListener.checkAndActivate(level, pos);
            return EventResult.pass();
        });
        BlockEvent.PLACE.register((level, pos, state, entity) -> {
            AdjudicatorRoomListener.checkAndActivate(level, pos);
            return EventResult.pass();
        });
    }

    public static void checkAndActivate(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        activeAdjudicators.removeIf(e -> !e.m_6084_() || e.m_213877_());
        for (AdjudicatorEntity adj : activeAdjudicators) {
            if (adj.getArenaBounds() == null || !adj.getArenaBounds().m_82390_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) continue;
            adj.setActive();
        }
    }

    public static void enableAdjudicator(AdjudicatorEntity entity) {
        activeAdjudicators.add(entity);
    }

    public static void disableAdjudicator(AdjudicatorEntity entity) {
        activeAdjudicators.remove(entity);
    }
}

