/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.OwlEntity;
import party.lemons.biomemakeover.entity.ai.FlyWanderGoal;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;

public class MothEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> TARGETING = SynchedEntityData.m_135353_(MothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean hasPlayedLoop = false;
    private float currentPitch;
    private float lastPitch;
    private int findAttractionCooldown = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)60);
    private BlockPos savedAttractionPos;
    private HugAttractionGoal hugAttractionGoal;

    public MothEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.hugAttractionGoal = new HugAttractionGoal();
        this.f_21345_.m_25352_(1, (Goal)this.hugAttractionGoal);
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, OwlEntity.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new FlyWanderGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TARGETING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MothEntity.m_33035_().m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        if (levelReader.m_8055_(blockPos).m_60795_()) {
            return 10.0f + (float)levelReader.m_7146_(blockPos);
        }
        return super.m_5610_(blockPos, levelReader);
    }

    public float m_20998_(float delta) {
        return Mth.m_14179_((float)delta, (float)this.lastPitch, (float)this.currentPitch);
    }

    private void updateBodyPitch() {
        this.lastPitch = this.currentPitch;
        this.currentPitch = Math.max((float)Math.sin((float)this.f_19797_ / 10.0f) / 10.0f, this.currentPitch - 0.24f);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.findAttractionCooldown > 0) {
            --this.findAttractionCooldown;
        }
    }

    public static boolean checkSpawnRules(EntityType<? extends MothEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)random) && (mobSpawnType == MobSpawnType.SPAWNER || levelAccessor.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13035_));
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos blockPos) {
                return !this.f_26495_.m_8055_(blockPos.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                if (!MothEntity.this.hugAttractionGoal.isHugging()) {
                    super.m_7638_();
                }
            }
        };
        birdNavigation.m_26443_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26440_(false);
        return birdNavigation;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.hugAttractionGoal.stopHugging();
        }
        return super.m_6469_(damageSource, f);
    }

    private boolean isAttractive(BlockState state) {
        return state.m_60791_() > 10 || state.m_204336_(BMBlocks.MOTH_ATTRACTIVE);
    }

    protected float m_6041_() {
        BlockState state = this.m_20075_();
        Block block = state.m_60734_();
        float mult = state.m_204336_(BMBlocks.ITCHING_IVY_TAG) ? 1.0f : block.m_49961_();
        if (block != Blocks.f_49990_ && block != Blocks.f_50628_) {
            if (mult == 1.0f) {
                BlockState velBlock = this.m_9236_().m_8055_(this.m_20099_());
                if (!velBlock.m_204336_(BMBlocks.ITCHING_IVY_TAG)) {
                    return velBlock.m_60734_().m_49961_();
                }
                return mult;
            }
            return mult;
        }
        return mult;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected SoundEvent m_7515_() {
        return BMEffects.MOTH_IDLE.get();
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    protected boolean m_142039_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateBodyPitch();
    }

    public boolean isTargeting() {
        return (Boolean)this.m_20088_().m_135370_(TARGETING);
    }

    protected SoundEvent m_5592_() {
        return BMEffects.MOTH_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return BMEffects.MOTH_HURT.get();
    }

    public boolean m_7327_(Entity entity) {
        boolean attacked = super.m_7327_((Entity)this.m_5448_());
        if (attacked) {
            this.m_5496_(BMEffects.MOTH_BITE.get(), 1.0f, 1.0f);
        }
        return attacked;
    }

    public boolean hasSavedAttractionPos() {
        return this.savedAttractionPos != null;
    }

    public boolean isValidAttraction(BlockPos pos) {
        return this.m_9236_().m_46749_(pos) && this.isAttractive(this.m_9236_().m_8055_(pos));
    }

    private class HugAttractionGoal
    extends BaseAttractionGoal {
        private int successfulPollinatingTicks;
        private boolean hugging;
        @Nullable
        private Vec3 hoverPos;
        private int huggingTicks;

        private HugAttractionGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canMothUse() {
            if (MothEntity.this.findAttractionCooldown > 0) {
                return false;
            }
            Optional<BlockPos> nearbyAttraction = this.findNearbyAttraction();
            if (nearbyAttraction.isPresent()) {
                MothEntity.this.savedAttractionPos = nearbyAttraction.get();
                Vec3 targetPosition = MothEntity.this.savedAttractionPos.m_252807_();
                MothEntity.this.f_21344_.m_26519_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_, (double)1.2f);
                return true;
            }
            MothEntity.this.findAttractionCooldown = Mth.m_216271_((RandomSource)MothEntity.this.f_19796_, (int)20, (int)60);
            return false;
        }

        @Override
        public boolean canMothContinueToUse() {
            if (!this.hugging) {
                return false;
            }
            if (!MothEntity.this.hasSavedAttractionPos()) {
                return false;
            }
            if (this.hasHuggedLongEnough()) {
                return MothEntity.this.f_19796_.m_188501_() < 0.2f;
            }
            if (MothEntity.this.f_19797_ % 20 == 0 && !MothEntity.this.isValidAttraction(MothEntity.this.savedAttractionPos)) {
                MothEntity.this.savedAttractionPos = null;
                return false;
            }
            return true;
        }

        private boolean hasHuggedLongEnough() {
            return this.successfulPollinatingTicks > 400;
        }

        boolean isHugging() {
            return this.hugging;
        }

        void stopHugging() {
            this.hugging = false;
        }

        public void m_8056_() {
            this.successfulPollinatingTicks = 0;
            this.huggingTicks = 0;
            this.hugging = true;
        }

        public void m_8041_() {
            this.hugging = false;
            MothEntity.this.f_21344_.m_26573_();
            MothEntity.this.findAttractionCooldown = 200;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            ++this.huggingTicks;
            if (this.huggingTicks > 600) {
                MothEntity.this.savedAttractionPos = null;
            } else {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)MothEntity.this.savedAttractionPos).m_82520_(0.0, (double)0.6f, 0.0);
                if (vec3.m_82554_(MothEntity.this.m_20182_()) > 1.0) {
                    this.hoverPos = vec3;
                    this.setWantedPos();
                } else {
                    if (this.hoverPos == null) {
                        this.hoverPos = vec3;
                    }
                    boolean bl = MothEntity.this.m_20182_().m_82554_(this.hoverPos) <= 0.1;
                    boolean bl2 = true;
                    if (!bl && this.huggingTicks > 600) {
                        MothEntity.this.savedAttractionPos = null;
                    } else {
                        if (bl) {
                            boolean bl3;
                            boolean bl4 = bl3 = MothEntity.this.f_19796_.m_188503_(25) == 0;
                            if (bl3) {
                                this.hoverPos = new Vec3(vec3.m_7096_() + (double)this.getOffset(), vec3.m_7098_(), vec3.m_7094_() + (double)this.getOffset());
                                MothEntity.this.f_21344_.m_26573_();
                            } else {
                                bl2 = false;
                            }
                            MothEntity.this.m_21563_().m_24946_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
                        }
                        if (bl2) {
                            this.setWantedPos();
                        }
                        ++this.successfulPollinatingTicks;
                    }
                }
            }
        }

        private void setWantedPos() {
            MothEntity.this.m_21566_().m_6849_(this.hoverPos.m_7096_(), this.hoverPos.m_7098_(), this.hoverPos.m_7094_(), (double)0.35f);
        }

        private float getOffset() {
            return (MothEntity.this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.33f;
        }

        private Optional<BlockPos> findNearbyAttraction() {
            return this.findNearestBlock(MothEntity.this::isAttractive, 5.0);
        }

        private Optional<BlockPos> findNearestBlock(Predicate<BlockState> predicate, double d) {
            BlockPos mothPos = MothEntity.this.m_20183_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int y = 0;
            while ((double)y <= d) {
                int j = 0;
                while ((double)j < d) {
                    int x = 0;
                    while (x <= j) {
                        int z;
                        int n = z = x < j && x > -j ? j : 0;
                        while (z <= j) {
                            pos.m_122154_((Vec3i)mothPos, x, y - 1, z);
                            if (mothPos.m_123314_((Vec3i)pos, d) && predicate.test(MothEntity.this.m_9236_().m_8055_((BlockPos)pos))) {
                                return Optional.of(pos);
                            }
                            z = z > 0 ? -z : 1 - z;
                        }
                        x = x > 0 ? -x : 1 - x;
                    }
                    ++j;
                }
                y = y > 0 ? -y : 1 - y;
            }
            return Optional.empty();
        }
    }

    abstract class BaseAttractionGoal
    extends Goal {
        BaseAttractionGoal() {
        }

        public abstract boolean canMothUse();

        public abstract boolean canMothContinueToUse();

        public boolean m_8036_() {
            return this.canMothUse() && MothEntity.this.m_271686_() != null;
        }

        public boolean m_8045_() {
            return this.canMothContinueToUse() && MothEntity.this.m_271686_() != null;
        }
    }
}

