/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.init.BMPotions;
import party.lemons.biomemakeover.util.NetworkUtil;

public class LightningBottleEntity
extends ThrowableItemProjectile {
    public LightningBottleEntity(EntityType<? extends LightningBottleEntity> entityType, Level world) {
        super(entityType, world);
    }

    public LightningBottleEntity(Level world, LivingEntity owner) {
        super((EntityType)BMEntities.LIGHTNING_BOTTLE.get(), owner, world);
    }

    public LightningBottleEntity(Level world, double x, double y, double z) {
        super((EntityType)BMEntities.LIGHTNING_BOTTLE.get(), x, y, z, world);
    }

    protected Item m_7881_() {
        return (Item)BMItems.LIGHTNING_BOTTLE.get();
    }

    protected float m_7139_() {
        return 0.07f;
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        NetworkUtil.doLightningSplash(this.m_9236_(), true, this.m_20097_());
        if (!this.m_9236_().m_5776_()) {
            double distance;
            this.m_9236_().m_5594_(null, this.m_20097_(), BMEffects.BOTTLE_THUNDER.get(), SoundSource.NEUTRAL, 50.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f);
            AABB box = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
            List entities = this.m_9236_().m_6443_(LivingEntity.class, box, EntitySelector.f_20403_);
            if (!entities.isEmpty()) {
                for (LivingEntity e : entities) {
                    distance = this.m_20280_((Entity)e);
                    if (!(distance < 16.0)) continue;
                    int fireTicks = e.m_20094_();
                    boolean isInvul = e.m_20147_();
                    LightningBolt dummyLightning = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                    dummyLightning.m_6034_(e.m_20185_(), e.m_20186_(), e.m_20189_());
                    e.m_20331_(true);
                    e.m_8038_((ServerLevel)this.m_9236_(), dummyLightning);
                    e.m_7311_(fireTicks);
                    e.m_20331_(isInvul);
                    dummyLightning.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            if (!(entities = this.m_9236_().m_6443_(LivingEntity.class, box, EntitySelector.f_20403_)).isEmpty()) {
                for (LivingEntity e : entities) {
                    distance = this.m_20280_((Entity)e);
                    if (!(distance < 16.0)) continue;
                    NetworkUtil.doLightningEntity(this.m_9236_(), e, 100);
                    if (!e.m_21023_(BMPotions.SHOCKED.get())) {
                        e.m_7292_(new MobEffectInstance(BMPotions.SHOCKED.get(), 1000, 0));
                    } else {
                        e.m_7292_(new MobEffectInstance(BMPotions.SHOCKED.get(), 1000, Math.min(3, e.m_21124_(BMPotions.SHOCKED.get()).m_19564_() + 1)));
                    }
                    e.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)this, this.m_19749_()), 0.0f);
                    if (this.m_19749_() instanceof LivingEntity) {
                        e.m_6703_((LivingEntity)this.m_19749_());
                    }
                    if (!(e.m_21223_() > e.m_21233_())) continue;
                    e.m_21153_(e.m_21233_());
                }
            }
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                BlockPos hitPos = this.m_20183_().m_121945_(blockHitResult.m_82434_().m_122424_());
                BlockState blockState = this.m_9236_().m_8055_(hitPos);
                if (blockState.m_60713_(Blocks.f_152587_)) {
                    ((LightningRodBlock)blockState.m_60734_()).m_153760_(blockState, this.m_9236_(), hitPos);
                }
                LightningBolt.m_147150_((Level)this.m_9236_(), (BlockPos)hitPos);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }
}

