/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.entity.ai.PredicateTemptGoal;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.biomemakeover.item.HatItem;

public class HelmitCrabEntity
extends Animal {
    public static final EntityDataAccessor<ItemStack> SHELL_ITEM = SynchedEntityData.m_135353_(HelmitCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Boolean> HIDING = SynchedEntityData.m_135353_(HelmitCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean targetingUnderwater;
    private int shellChangeCooldown = 0;
    private int hideTime = 0;

    public HelmitCrabEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_21573_().m_7008_(true);
        this.f_21348_[0] = 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HideGoal());
        this.f_21345_.m_25352_(1, (Goal)new EscapeIntoShellGoal(1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new PredicateTemptGoal((PathfinderMob)this, 1.2, i -> i.m_204117_(ItemTags.f_13156_), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new LeaveWaterGoal(1.0));
        this.f_21345_.m_25352_(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new SeekShellGoal());
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected BodyRotationControl m_7560_() {
        return new CrabBodyControl((Mob)this);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(SHELL_ITEM, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(HIDING, (Object)false);
        super.m_8097_();
    }

    public static boolean checkSpawnRules(EntityType<HelmitCrabEntity> type, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BMBlocks.CRAB_SPAWNABLE_ON) && Animal.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (this.m_6162_()) {
            return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        }
        if (this.f_19796_.m_188501_() < 0.6f) {
            ItemStack itemStack;
            int tier = 0;
            for (int i = 0; i < 4; ++i) {
                if (!(this.f_19796_.m_188501_() < 0.05f)) continue;
                ++tier;
            }
            switch (tier) {
                case 1: {
                    ItemStack itemStack2 = new ItemStack((ItemLike)Items.f_42407_);
                    break;
                }
                case 2: {
                    ItemStack itemStack2 = new ItemStack((ItemLike)Items.f_42476_);
                    break;
                }
                case 3: {
                    ItemStack itemStack2 = new ItemStack((ItemLike)Items.f_42468_);
                    break;
                }
                case 4: {
                    ItemStack itemStack2 = new ItemStack((ItemLike)Items.f_42472_);
                    break;
                }
                default: {
                    ItemStack itemStack2 = itemStack = new ItemStack((ItemLike)Items.f_42715_);
                }
            }
            if (this.f_19796_.m_188501_() < 0.05f) {
                EnchantmentHelper.m_220292_((RandomSource)this.f_19796_, (ItemStack)itemStack, (int)((int)(5.0f + (float)this.f_19796_.m_188503_(10))), (boolean)false);
            }
            if (itemStack.m_41763_()) {
                itemStack.m_41721_(itemStack.m_41776_() - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(itemStack.m_41776_() - 3, 1))));
            }
            this.m_20088_().m_135381_(SHELL_ITEM, (Object)itemStack);
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_5844_() {
        if (!this.m_9236_().m_5776_()) {
            this.m_20282_(this.m_21515_() && this.m_20069_() && this.isTargetingUnderwater());
        }
    }

    public boolean m_7327_(Entity entity) {
        this.m_5496_(BMEffects.CRAB_SNIP.get(), 0.5f, 1.0f);
        return super.m_7327_(entity);
    }

    public Iterable<ItemStack> m_6168_() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getShellItemStack()});
    }

    public Iterable<ItemStack> m_6167_() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getShellItemStack()});
    }

    private boolean isTargetingUnderwater() {
        if (this.targetingUnderwater) {
            return true;
        }
        LivingEntity livingEntity = this.m_5448_();
        return livingEntity != null && livingEntity.m_20069_();
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.shellChangeCooldown > 0) {
            --this.shellChangeCooldown;
        }
        if (this.isHiding()) {
            ++this.hideTime;
            if (this.hideTime > 250 && this.f_19796_.m_188503_(100) == 0) {
                this.setHiding(false);
            }
        }
    }

    protected void m_7472_(DamageSource damageSource, int i, boolean bl) {
        super.m_7472_(damageSource, i, bl);
        if (!EnchantmentHelper.m_44924_((ItemStack)this.getShellItemStack())) {
            this.m_19983_(this.getShellItemStack());
        }
        this.setShellItem(ItemStack.f_41583_);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_13156_);
    }

    public boolean prefersShell(ItemStack itemStack) {
        if (itemStack.m_41619_() || !this.isValidShellItem(itemStack)) {
            return false;
        }
        ItemStack currentShell = this.getShellItemStack();
        if (EnchantmentHelper.m_44920_((ItemStack)currentShell)) {
            return false;
        }
        if (currentShell.m_41619_()) {
            return true;
        }
        if (currentShell.m_41720_() != Items.f_42715_ && itemStack.m_41720_() == Items.f_42715_) {
            return true;
        }
        if (currentShell.m_41720_() != itemStack.m_41720_() && itemStack.m_41720_() instanceof BlockItem && ((BlockItem)itemStack.m_41720_()).m_40614_() instanceof AbstractSkullBlock) {
            return true;
        }
        if (!(currentShell.m_41720_() instanceof ArmorItem) && itemStack.m_41720_() == Blocks.f_50143_.m_5456_()) {
            return true;
        }
        if (currentShell.m_41720_() != Items.f_42748_ && itemStack.m_41720_() == Items.f_42748_) {
            return true;
        }
        if (itemStack.m_41720_() instanceof ArmorItem && ((ArmorItem)itemStack.m_41720_()).m_266204_() == ArmorItem.Type.HELMET) {
            if (currentShell.m_41720_() instanceof HatItem) {
                if (itemStack.m_41720_() instanceof HatItem) {
                    return currentShell.m_41720_() != itemStack.m_41720_();
                }
                return true;
            }
            if (itemStack.m_41720_() instanceof HatItem) {
                return true;
            }
            Item item = currentShell.m_41720_();
            if (!(item instanceof ArmorItem)) {
                return true;
            }
            ArmorItem current = (ArmorItem)item;
            ArmorItem newShell = (ArmorItem)itemStack.m_41720_();
            if (newShell.m_40404_() != current.m_40404_()) {
                return newShell.m_40404_() > current.m_40404_();
            }
            if (newShell.m_40405_() != current.m_40405_()) {
                return newShell.m_40405_() > current.m_40405_();
            }
            return this.prefersNewDamageableItem(itemStack, currentShell);
        }
        return false;
    }

    public boolean prefersNewDamageableItem(ItemStack newStack, ItemStack oldStack) {
        if (newStack.m_41773_() >= oldStack.m_41773_() && (!newStack.m_41782_() || oldStack.m_41782_())) {
            if (newStack.m_41782_() && oldStack.m_41782_()) {
                return newStack.m_41783_().m_128431_().stream().anyMatch(string -> !string.equals("Damage")) && !oldStack.m_41783_().m_128431_().stream().anyMatch(string -> !string.equals("Damage"));
            }
            return false;
        }
        return true;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Shell")) {
            this.m_20088_().m_135381_(SHELL_ITEM, (Object)ItemStack.m_41712_((CompoundTag)tag.m_128469_("Shell")));
        }
        this.hideTime = tag.m_128451_("HideTime");
        this.shellChangeCooldown = tag.m_128451_("ShellCooldown");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Shell", (Tag)((ItemStack)this.m_20088_().m_135370_(SHELL_ITEM)).m_41739_(new CompoundTag()));
        tag.m_128405_("HideTime", this.hideTime);
        tag.m_128405_("ShellCooldown", this.shellChangeCooldown);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        BlockState block = level.m_8055_(pos.m_7495_());
        if (block.m_60713_(Blocks.f_49992_)) {
            return 10.0f;
        }
        if (block.m_60713_(Blocks.f_49990_)) {
            return 7.0f;
        }
        return (float)level.m_7146_(pos) - 0.5f;
    }

    public boolean isValidShellItem(ItemStack itemstack) {
        if (this.m_6162_() || itemstack.m_204117_(BMItems.HELMIT_CRAB_EXCEPTION)) {
            return false;
        }
        Item item = itemstack.m_41720_();
        if (item instanceof ArmorItem && ((ArmorItem)item).m_266204_() == ArmorItem.Type.HELMET) {
            return true;
        }
        return item == Items.f_42715_ || item == Items.f_42748_ || item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof AbstractSkullBlock || item == Blocks.f_50143_.m_5456_();
    }

    public void setShellItem(ItemStack stack) {
        ItemStack old = this.getShellItemStack();
        this.m_20088_().m_135381_(SHELL_ITEM, (Object)stack);
        this.m_238392_(EquipmentSlot.HEAD, old, stack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.HEAD) {
            return (ItemStack)this.m_20088_().m_135370_(SHELL_ITEM);
        }
        return super.m_6844_(slot);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)BMEntities.HELMIT_CRAB.get()).m_20615_((Level)serverLevel);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean canHide() {
        return !this.getShellItemStack().m_41619_();
    }

    public ItemStack getShellItemStack() {
        return (ItemStack)this.m_20088_().m_135370_(SHELL_ITEM);
    }

    public boolean isHiding() {
        return (Boolean)this.m_20088_().m_135370_(HIDING);
    }

    private void setHiding(boolean hiding) {
        this.m_20088_().m_135381_(HIDING, (Object)hiding);
        if (hiding) {
            this.m_216990_(BMEffects.CRAB_ENTER_SHELL.get());
            this.m_21573_().m_26573_();
            this.hideTime = 0;
            this.m_6710_(null);
        } else {
            this.m_216990_(BMEffects.CRAB_LEAVE_SHELL.get());
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return BMEffects.CRAB_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return BMEffects.CRAB_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(BMEffects.CRAB_SCUTTLE.get(), 0.1f, 1.0f - this.f_19796_.m_188501_() / 5.0f);
        super.m_7355_(blockPos, blockState);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_21515_() || this.m_6109_()) {
            boolean bl;
            double d = 0.08;
            boolean bl2 = bl = this.m_20184_().f_82480_ <= 0.0;
            if (bl && this.m_21023_(MobEffects.f_19591_)) {
                d = 0.01;
                this.m_183634_();
            }
            FluidState fluidState = this.m_9236_().m_6425_(this.m_20183_());
            if (this.m_20069_() && this.m_6129_() && !this.m_203441_(fluidState)) {
                if (this.m_21573_().m_26567_() != null && (double)this.m_21573_().m_26567_().m_123342_() > this.m_20186_()) {
                    this.m_21569_().m_24901_();
                }
                if (!this.m_20096_() && !this.f_20899_ && this.m_20184_().m_7098_() > (double)-0.1f) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.025f, 0.0));
                }
                double e = this.m_20186_();
                float f = this.m_20142_() ? 0.9f : this.m_6108_();
                float g = 0.02f;
                float h = EnchantmentHelper.m_44922_((LivingEntity)this);
                if (h > 3.0f) {
                    h = 3.0f;
                }
                if (!this.m_20096_()) {
                    h *= 0.5f;
                }
                if (h > 0.0f) {
                    f += (0.54600006f - f) * h / 3.0f;
                    g += (this.m_6113_() - g) * h / 3.0f;
                }
                if (this.m_21023_(MobEffects.f_19593_)) {
                    f = 0.96f;
                }
                this.m_19920_(g, vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 vec32 = this.m_20184_();
                if (this.f_19862_ && this.m_6147_()) {
                    vec32 = new Vec3(vec32.f_82479_, 0.2, vec32.f_82481_);
                }
                this.m_20256_(vec32.m_82542_((double)f, (double)0.8f, (double)f));
                Vec3 vec33 = this.m_20994_(d, bl, this.m_20184_());
                this.m_20256_(vec33);
                if (this.f_19862_ && this.m_20229_(vec33.f_82479_, vec33.f_82480_ + (double)0.6f - this.m_20186_() + e, vec33.f_82481_)) {
                    this.m_20334_(vec33.f_82479_, 0.3f, vec33.f_82481_);
                }
            } else if (this.m_20077_() && this.m_6129_() && !this.m_203441_(fluidState)) {
                Vec3 vec34;
                double e = this.m_20186_();
                this.m_19920_(0.02f, vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.m_204036_(FluidTags.f_13132_) <= this.m_20204_()) {
                    this.m_20256_(this.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
                    vec34 = this.m_20994_(d, bl, this.m_20184_());
                    this.m_20256_(vec34);
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                }
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -d / 4.0, 0.0));
                }
                vec34 = this.m_20184_();
                if (this.f_19862_ && this.m_20229_(vec34.f_82479_, vec34.f_82480_ + (double)0.6f - this.m_20186_() + e, vec34.f_82481_)) {
                    this.m_20334_(vec34.f_82479_, 0.3f, vec34.f_82481_);
                }
            } else if (this.m_21255_()) {
                double m;
                Vec3 vec35 = this.m_20184_();
                if (vec35.f_82480_ > -0.5) {
                    this.f_19789_ = 1.0f;
                }
                Vec3 vec36 = this.m_20154_();
                float f = this.m_146909_() * ((float)Math.PI / 180);
                double i = Math.sqrt(vec36.f_82479_ * vec36.f_82479_ + vec36.f_82481_ * vec36.f_82481_);
                double j = vec35.m_165924_();
                double k = vec36.m_82553_();
                double l = Math.cos(f);
                l = l * l * Math.min(1.0, k / 0.4);
                vec35 = this.m_20184_().m_82520_(0.0, d * (-1.0 + l * 0.75), 0.0);
                if (vec35.f_82480_ < 0.0 && i > 0.0) {
                    m = vec35.f_82480_ * -0.1 * l;
                    vec35 = vec35.m_82520_(vec36.f_82479_ * m / i, m, vec36.f_82481_ * m / i);
                }
                if (f < 0.0f && i > 0.0) {
                    m = j * (double)(-Mth.m_14031_((float)f)) * 0.04;
                    vec35 = vec35.m_82520_(-vec36.f_82479_ * m / i, m * 3.2, -vec36.f_82481_ * m / i);
                }
                if (i > 0.0) {
                    vec35 = vec35.m_82520_((vec36.f_82479_ / i * j - vec35.f_82479_) * 0.1, 0.0, (vec36.f_82481_ / i * j - vec35.f_82481_) * 0.1);
                }
                this.m_20256_(vec35.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.f_19862_ && !this.m_9236_().f_46443_) {
                    float f2;
                    m = this.m_20184_().m_165924_();
                    double n = j - m;
                    float o = (float)(n * 10.0 - 3.0);
                    if (f2 > 0.0f) {
                        this.m_5496_(o > 4.0f ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_(), 1.0f, 1.0f);
                        this.m_6469_(this.m_9236_().m_269111_().m_269515_(), o);
                    }
                }
                if (this.m_20096_() && !this.m_9236_().f_46443_) {
                    this.m_20115_(7, false);
                }
            } else {
                BlockPos blockPos = this.m_20099_();
                float p = this.m_9236_().m_8055_(blockPos).m_60734_().m_49958_();
                float f = this.m_20096_() ? p * 0.91f : 0.91f;
                Vec3 vec37 = this.m_21074_(vec3, p);
                double q = vec37.f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    q += (0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - vec37.f_82480_) * 0.2;
                    this.m_183634_();
                } else if (!this.m_9236_().f_46443_ || this.m_9236_().m_46805_(blockPos)) {
                    if (!this.m_20068_()) {
                        q -= d;
                    }
                } else {
                    double d2 = q = this.m_20186_() > (double)this.m_9236_().m_141937_() ? -0.1 : 0.0;
                }
                if (this.m_147223_()) {
                    this.m_20334_(vec37.f_82479_, q, vec37.f_82481_);
                } else {
                    this.m_20334_(vec37.f_82479_ * (double)f, q * (double)0.98f, vec37.f_82481_ * (double)f);
                }
            }
        }
        this.m_267651_(this instanceof FlyingAnimal);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void setTargetingUnderwater(boolean targetingUnderwater) {
        this.targetingUnderwater = targetingUnderwater;
    }

    private class HideGoal
    extends Goal {
        public HideGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
        }

        public void m_8037_() {
            HelmitCrabEntity.this.m_21573_().m_26573_();
            HelmitCrabEntity.this.m_21566_().m_6849_(HelmitCrabEntity.this.m_20185_(), HelmitCrabEntity.this.m_20186_(), HelmitCrabEntity.this.m_20189_(), 100.0);
            super.m_8037_();
        }

        public boolean m_8036_() {
            return HelmitCrabEntity.this.isHiding();
        }

        public boolean m_8045_() {
            return HelmitCrabEntity.this.isHiding();
        }

        public boolean m_6767_() {
            return !HelmitCrabEntity.this.isHiding();
        }
    }

    private class EscapeIntoShellGoal
    extends PanicGoal {
        private boolean isFire;
        boolean hasAttacked;
        boolean attacking;
        BlockPos attackTargetPos;

        public EscapeIntoShellGoal(double speed) {
            super((PathfinderMob)HelmitCrabEntity.this, speed);
            this.isFire = false;
            this.hasAttacked = false;
            this.attacking = false;
            this.attackTargetPos = null;
        }

        public boolean m_8036_() {
            BlockPos blockPos;
            if (HelmitCrabEntity.this.isHiding()) {
                return false;
            }
            if (this.f_25684_.m_21188_() == null && !this.f_25684_.m_6060_()) {
                return false;
            }
            if (this.f_25684_.m_6060_() && (blockPos = this.m_198172_((BlockGetter)this.f_25684_.m_9236_(), (Entity)this.f_25684_, 5)) != null) {
                this.f_25686_ = blockPos.m_123341_();
                this.f_25687_ = blockPos.m_123342_();
                this.f_25688_ = blockPos.m_123343_();
                this.isFire = true;
                this.hasAttacked = true;
                return true;
            }
            this.isFire = false;
            this.hasAttacked = false;
            return this.m_25702_();
        }

        public void m_8056_() {
            if (!this.isFire && this.f_25684_.m_21188_() != null && HelmitCrabEntity.this.m_20270_((Entity)this.f_25684_.m_21188_()) < 4.0f) {
                BlockPos attackerPos = this.f_25684_.m_21188_().m_20183_();
                this.f_25684_.m_21573_().m_26519_((double)attackerPos.m_123341_(), (double)attackerPos.m_123342_(), (double)attackerPos.m_123343_(), this.f_25685_);
                this.f_25689_ = true;
                this.attacking = true;
                this.attackTargetPos = attackerPos;
            } else {
                this.attacking = false;
                super.m_8056_();
            }
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.isFire || !this.f_25689_) {
                return;
            }
            if (this.attacking && this.f_25684_.m_21188_() != null && this.f_25684_.m_21188_().m_6084_()) {
                boolean inValidTargetRange;
                boolean bl = inValidTargetRange = HelmitCrabEntity.this.m_20270_((Entity)this.f_25684_.m_21188_()) < 2.0f;
                if (this.f_25684_.m_20275_((double)((float)this.attackTargetPos.m_123341_() + 0.5f), (double)((float)this.attackTargetPos.m_123342_() + 0.5f), (double)((float)this.attackTargetPos.m_123343_() + 0.5f)) < 1.0 || inValidTargetRange) {
                    if (inValidTargetRange) {
                        HelmitCrabEntity.this.m_7327_((Entity)this.f_25684_.m_21188_());
                    }
                    this.attacking = false;
                    this.f_25684_.m_21573_().m_26519_(this.f_25686_, this.f_25687_, this.f_25688_, this.f_25685_);
                }
            }
            if (HelmitCrabEntity.this.canHide() && this.f_25689_ && HelmitCrabEntity.this.f_19796_.m_188503_(40) == 0) {
                HelmitCrabEntity.this.setHiding(true);
                this.m_8041_();
            }
        }
    }

    class LeaveWaterGoal
    extends MoveToBlockGoal {
        public LeaveWaterGoal(double speed) {
            super((PathfinderMob)HelmitCrabEntity.this, speed, 8, 2);
        }

        public boolean m_8036_() {
            return super.m_8036_() && HelmitCrabEntity.this.m_20069_();
        }

        public void m_8056_() {
            HelmitCrabEntity.this.setTargetingUnderwater(false);
            super.m_8056_();
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockPos blockPos = pos.m_7494_();
            return level.m_46859_(blockPos) && level.m_46859_(blockPos.m_7494_()) && level.m_8055_(pos).m_60634_((BlockGetter)level, pos, (Entity)HelmitCrabEntity.this);
        }
    }

    private class SeekShellGoal
    extends Goal {
        private ItemEntity itemEntity = null;

        public SeekShellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.itemEntity.m_6084_()) {
                HelmitCrabEntity.this.m_21566_().m_6849_(this.itemEntity.m_20185_(), this.itemEntity.m_20186_(), this.itemEntity.m_20189_(), (double)1.2f);
                if (HelmitCrabEntity.this.m_20270_((Entity)this.itemEntity) < 0.5f) {
                    this.itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    if (!HelmitCrabEntity.this.getShellItemStack().m_41619_()) {
                        HelmitCrabEntity.this.m_19983_(HelmitCrabEntity.this.getShellItemStack());
                    }
                    HelmitCrabEntity.this.setShellItem(this.itemEntity.m_32055_());
                    HelmitCrabEntity.this.shellChangeCooldown = 500 + HelmitCrabEntity.this.f_19796_.m_188503_(300);
                }
            }
        }

        public boolean m_8036_() {
            if (HelmitCrabEntity.this.m_6162_() || HelmitCrabEntity.this.shellChangeCooldown > 0) {
                return false;
            }
            this.seekShell();
            return this.itemEntity != null && !this.itemEntity.m_213877_();
        }

        private void seekShell() {
            List entities = HelmitCrabEntity.this.m_9236_().m_6443_(ItemEntity.class, HelmitCrabEntity.this.m_20191_().m_82400_(5.0), i -> HelmitCrabEntity.this.prefersShell(i.m_32055_()));
            if (!entities.isEmpty()) {
                this.itemEntity = (ItemEntity)entities.get(HelmitCrabEntity.this.f_19796_.m_188503_(entities.size()));
            }
        }

        public boolean m_8045_() {
            return this.itemEntity != null && !this.itemEntity.m_213877_();
        }
    }

    private static class CrabBodyControl
    extends BodyRotationControl {
        private final Mob mob;
        private static final int HEAD_STABLE_ANGLE = 15;
        private static final int DELAY_UNTIL_STARTING_TO_FACE_FORWARD = 10;
        private static final int HOW_LONG_IT_TAKES_TO_FACE_FORWARD = 10;
        private int headStableTime;
        private float lastStableYHeadRot;

        public CrabBodyControl(Mob mob) {
            super(mob);
            this.mob = mob;
        }

        public void m_8121_() {
            if (this.isMoving()) {
                this.mob.f_20883_ = this.mob.m_146908_() + 90.0f;
                this.rotateHeadIfNecessary();
                this.lastStableYHeadRot = this.mob.f_20885_;
                this.headStableTime = 0;
                return;
            }
            if (this.notCarryingMobPassengers()) {
                if (Math.abs(this.mob.f_20885_ - this.lastStableYHeadRot) > 15.0f) {
                    this.headStableTime = 0;
                    this.lastStableYHeadRot = this.mob.f_20885_;
                    this.rotateBodyIfNecessary();
                } else {
                    ++this.headStableTime;
                    if (this.headStableTime > 10) {
                        this.rotateHeadTowardsFront();
                    }
                }
            }
        }

        private void rotateBodyIfNecessary() {
            this.mob.f_20883_ = Mth.m_14094_((float)this.mob.f_20883_, (float)this.mob.f_20885_, (float)this.mob.m_8085_());
        }

        private void rotateHeadIfNecessary() {
            this.mob.f_20885_ = Mth.m_14094_((float)this.mob.f_20885_, (float)this.mob.f_20883_, (float)this.mob.m_8085_());
        }

        private void rotateHeadTowardsFront() {
            int i = this.headStableTime - 10;
            float f = Mth.m_14036_((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
            float g = (float)this.mob.m_8085_() * (1.0f - f);
            this.mob.f_20883_ = Mth.m_14094_((float)this.mob.f_20883_, (float)this.mob.f_20885_, (float)g);
        }

        private boolean notCarryingMobPassengers() {
            return !(this.mob.m_146895_() instanceof Mob);
        }

        private boolean isMoving() {
            double e;
            double d;
            double d2 = this.mob.m_20185_() - this.mob.f_19854_;
            return d2 * d2 + d * (e = this.mob.m_20189_() - this.mob.f_19856_) > 2.500000277905201E-7;
        }
    }
}

