/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch.data.reward;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.util.RandomSource;
import party.lemons.biomemakeover.crafting.witch.QuestRarity;
import party.lemons.biomemakeover.crafting.witch.data.reward.RewardTable;
import party.lemons.taniwha.util.collections.WeightedList;

public class RewardTables {
    public static final EnumMap<QuestRarity, WeightedList<RewardTable>> tables = Maps.newEnumMap(QuestRarity.class);

    public static RewardTable getTable(QuestRarity rarity, RandomSource randomSource) {
        return (RewardTable)tables.get((Object)rarity).sample(randomSource);
    }

    public static void addTable(RewardTable table) {
        WeightedList<RewardTable> common = tables.getOrDefault((Object)QuestRarity.COMMON, (WeightedList<RewardTable>)new WeightedList());
        WeightedList<RewardTable> uncommon = tables.getOrDefault((Object)QuestRarity.UNCOMMON, (WeightedList<RewardTable>)new WeightedList());
        WeightedList<RewardTable> rare = tables.getOrDefault((Object)QuestRarity.RARE, (WeightedList<RewardTable>)new WeightedList());
        WeightedList<RewardTable> epic = tables.getOrDefault((Object)QuestRarity.EPIC, (WeightedList<RewardTable>)new WeightedList());
        common.add((Object)table, table.weights().common());
        uncommon.add((Object)table, table.weights().uncommon());
        rare.add((Object)table, table.weights().rare());
        epic.add((Object)table, table.weights().epic());
        tables.put(QuestRarity.COMMON, common);
        tables.put(QuestRarity.UNCOMMON, uncommon);
        tables.put(QuestRarity.RARE, rare);
        tables.put(QuestRarity.EPIC, epic);
    }

    public static void clear() {
        tables.clear();
    }
}

