/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import party.lemons.biomemakeover.crafting.witch.QuestCategory;
import party.lemons.biomemakeover.crafting.witch.QuestItem;
import party.lemons.biomemakeover.crafting.witch.QuestRarity;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;
import party.lemons.biomemakeover.crafting.witch.WitchQuestList;
import party.lemons.biomemakeover.crafting.witch.data.QuestCategories;
import party.lemons.biomemakeover.crafting.witch.data.reward.RewardTables;
import party.lemons.biomemakeover.network.S2C_HandleWitchQuests;
import party.lemons.taniwha.util.collections.WeightedList;

public class WitchQuestHandler {
    private static final WeightedList<Integer> ITEM_COUNT_SELECTOR = new WeightedList();

    public static ItemStack getRewardFor(WitchQuest quest, RandomSource random) {
        QuestRarity rarity = QuestRarity.getRarityFromQuest(quest);
        return RewardTables.getTable(rarity, random).getReward(random).getReward(random);
    }

    public static WitchQuest createQuest(RandomSource random) {
        int count = (Integer)ITEM_COUNT_SELECTOR.sample(random);
        ArrayList questItems = Lists.newArrayList();
        for (int safetyCount = count * 2; questItems.size() < count && safetyCount > 0; --safetyCount) {
            QuestCategory category = QuestCategories.choose(random);
            List<QuestItem> itemPool = category.getRequestedItemPool();
            QuestItem item = itemPool.get(random.m_188503_(itemPool.size()));
            if (questItems.contains(item)) continue;
            questItems.add(item);
        }
        return new WitchQuest(random, questItems);
    }

    public static void sendQuests(Player player, int index, WitchQuestList quests) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        new S2C_HandleWitchQuests(index, quests).sendTo((ServerPlayer)player);
    }

    static {
        ITEM_COUNT_SELECTOR.add((Object)1, 5);
        ITEM_COUNT_SELECTOR.add((Object)2, 8);
        ITEM_COUNT_SELECTOR.add((Object)3, 4);
        ITEM_COUNT_SELECTOR.add((Object)4, 3);
        ITEM_COUNT_SELECTOR.add((Object)5, 1);
    }
}

