/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.crafting.witch;

import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Rarity;
import party.lemons.biomemakeover.crafting.witch.WitchQuest;

public enum QuestRarity {
    COMMON(Rarity.COMMON, 0),
    UNCOMMON(Rarity.UNCOMMON, 8),
    RARE(Rarity.RARE, 15),
    EPIC(Rarity.EPIC, 30);

    private final int requiredPoints;
    private final Rarity vanillaRarity;

    private QuestRarity(Rarity rarity, int requiredPoints) {
        this.requiredPoints = requiredPoints;
        this.vanillaRarity = rarity;
    }

    public Component getTooltipText() {
        return Component.m_237115_((String)("tooltip." + this.name().toLowerCase(Locale.ROOT))).m_130940_(this.vanillaRarity.f_43022_);
    }

    public static QuestRarity getRarityFromPoints(float points) {
        for (int i = QuestRarity.values().length - 1; i >= 0; --i) {
            if (!(points >= (float)QuestRarity.values()[i].requiredPoints)) continue;
            return QuestRarity.values()[i];
        }
        return COMMON;
    }

    public static QuestRarity getRarityFromQuest(WitchQuest quest) {
        return QuestRarity.getRarityFromPoints(quest.getPoints());
    }
}

