/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import party.lemons.taniwha.block.types.TBlock;

public class WillowingBranchesBlock
extends TBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final int MAX_GROWTH_STAGES = 2;
    public static final int MAX_STAGES = 3;
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private VoxelShape[] SHAPES = new VoxelShape[]{Shapes.m_83144_(), Shapes.m_83048_((double)0.1, (double)0.0, (double)0.1, (double)0.9, (double)1.0, (double)0.9), Shapes.m_83048_((double)0.15, (double)0.4, (double)0.15, (double)0.85, (double)1.0, (double)0.85), Shapes.m_83048_((double)0.15, (double)0.4, (double)0.15, (double)0.85, (double)1.0, (double)0.85)};

    public WillowingBranchesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState newState, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos posFrom) {
        if (direction == Direction.DOWN) {
            int currentStage = (Integer)blockState.m_61143_((Property)STAGE);
            if (newState.m_60713_((Block)this)) {
                int targetStage = (Integer)newState.m_61143_((Property)STAGE) == 3 ? 1 : Mth.m_14045_((int)((Integer)newState.m_61143_((Property)STAGE) - 1), (int)0, (int)2);
                if (currentStage != targetStage) {
                    blockState = (BlockState)blockState.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(targetStage));
                }
            } else if (currentStage != 2) {
                blockState = (BlockState)blockState.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2));
            }
        }
        if (!this.m_7898_(blockState, (LevelReader)levelAccessor, blockPos)) {
            levelAccessor.m_186460_(blockPos, (Block)this, 1);
        }
        return super.m_7417_(blockState, direction, newState, levelAccessor, blockPos, posFrom);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(7) == 0) {
            this.grow(state, level, pos, random, false);
        }
        super.m_213898_(state, level, pos, random);
    }

    public void grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, boolean forced) {
        boolean isWaterloggedBranchAbove;
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        boolean bl = isWaterloggedBranchAbove = aboveState.m_60713_((Block)this) && (Boolean)aboveState.m_61143_((Property)WATERLOGGED) != false;
        if (((Integer)state.m_61143_((Property)STAGE) == 2 || forced) && !isWaterloggedBranchAbove) {
            BlockState placeState = (BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(random.m_188503_(4) == 0 ? 3 : 2));
            BlockPos below = pos.m_7495_();
            if ((level.m_46859_(below) || level.m_8055_(below).m_60713_(Blocks.f_49990_)) && this.m_7898_(placeState, (LevelReader)level, below)) {
                FluidState st = level.m_6425_(below);
                level.m_7731_(below, (BlockState)placeState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(st.m_76152_() == Fluids.f_76193_)), 3);
            }
        }
    }

    public boolean canGrow(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        return (level.m_46859_(below) || level.m_8055_(below).m_60713_(Blocks.f_49990_)) && this.m_7898_(state, level, below);
    }

    public Optional<BlockPos> findHead(BlockState state, BlockPos pos, BlockGetter level) {
        if ((Integer)state.m_61143_((Property)STAGE) >= 2) {
            return Optional.of(pos);
        }
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        do {
            checkPos.m_122173_(Direction.DOWN);
        } while (level.m_8055_((BlockPos)checkPos).m_60713_((Block)this));
        return Optional.of(checkPos.m_7494_());
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.m_7494_();
        BlockState upState = level.m_8055_(blockPos);
        return upState.m_60713_((Block)this) || upState.m_204336_(BlockTags.f_13035_);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return pathComputationType == PathComputationType.AIR && !this.f_60443_ || super.m_7357_(blockState, blockGetter, blockPos, pathComputationType);
    }

    public boolean m_8133_(BlockState blockState, Level level, BlockPos blockPos, int i, int j) {
        for (int m = 0; m < 15; ++m) {
            int dirX = level.m_213780_().m_188503_(2) * 2 - 1;
            int dirY = level.m_213780_().m_188503_(2) * 2 - 1;
            int dirZ = level.m_213780_().m_188503_(2) * 2 - 1;
            Vec3 pos = blockPos.m_252807_();
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), pos.f_82479_ + (double)((float)dirX * 0.3f), pos.f_82480_ + 0.5 + (double)((float)dirY * 0.3f), pos.f_82481_ + (double)((float)dirZ * 0.3f), 0.0, 0.0, 0.0);
        }
        return true;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (stack.m_150930_(Items.f_42574_) && (Integer)blockState.m_61143_((Property)STAGE) == 2) {
            level.m_5594_(player, blockPos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockPos, stack);
                BlockState newState = (BlockState)blockState.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(3));
                level.m_46597_(blockPos, newState);
                level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newState));
                stack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(interactionHand));
                level.m_7696_(blockPos, (Block)this, 0, 0);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        FluidState fluidState = ctx.m_43725_().m_6425_(pos);
        boolean waterlog = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlog));
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Vec3 offset = blockState.m_60824_(blockGetter, blockPos);
        return this.SHAPES[(Integer)blockState.m_61143_((Property)STAGE)].m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public float m_142740_() {
        return 0.1f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAGE, WATERLOGGED});
        super.m_7926_(builder);
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        Optional<BlockPos> headPos = this.findHead(blockState, blockPos, (BlockGetter)levelReader);
        if (headPos.isEmpty()) {
            return false;
        }
        return this.canGrow(levelReader.m_8055_(headPos.get()), levelReader, headPos.get());
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        Optional<BlockPos> headPos = this.findHead(blockState, blockPos, (BlockGetter)serverLevel);
        if (headPos.isEmpty()) {
            return;
        }
        this.grow(serverLevel.m_8055_(headPos.get()), serverLevel, headPos.get(), randomSource, true);
    }
}

