/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.util.RandomUtil;
import party.lemons.taniwha.block.types.TBlock;

public class SaguaroCactusBlock
extends TBlock
implements BonemealableBlock {
    public static final BooleanProperty HORIZONTAL = BooleanProperty.m_61465_((String)"horizontal");
    public static final DirectionProperty HORIZONTAL_DIRECTION = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private final HashMap<BlockState, VoxelShape> shapes = (HashMap)Util.m_137469_((Object)Maps.newHashMap(), m -> this.m_49965_().m_61056_().forEach(st -> m.put(st, this.getShapeForState((BlockState)st))));
    public static final Map<Direction, BooleanProperty> FACING_PROPERTIES = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, NORTH);
        enumMap.put(Direction.EAST, EAST);
        enumMap.put(Direction.SOUTH, SOUTH);
        enumMap.put(Direction.WEST, WEST);
    });
    private static final Direction[] NORTH_SOUTH = new Direction[]{Direction.NORTH, Direction.SOUTH};
    private static final Direction[] EAST_WEST = new Direction[]{Direction.EAST, Direction.WEST};

    public SaguaroCactusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HORIZONTAL_DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState st = this.m_49966_();
        if (ctx.m_43719_().m_122416_() >= 0) {
            st = (BlockState)((BlockState)((BlockState)st.m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HORIZONTAL_DIRECTION, (Comparable)ctx.m_43719_().m_122424_())).m_61124_((Property)FACING_PROPERTIES.get(ctx.m_43719_().m_122424_()), (Comparable)Boolean.valueOf(true));
        }
        return st;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos posFrom) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
            return super.m_7417_(state, direction, newState, level, pos, posFrom);
        }
        if (direction.m_122434_().m_122478_()) {
            return super.m_7417_(state, direction, newState, level, pos, posFrom);
        }
        if (newState.m_60734_() == this) {
            if (((Boolean)newState.m_61143_((Property)HORIZONTAL)).booleanValue() && ((Boolean)newState.m_61143_((Property)FACING_PROPERTIES.get(direction.m_122424_()))).booleanValue()) {
                return (BlockState)state.m_61124_((Property)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(true));
            }
        } else {
            return (BlockState)state.m_61124_((Property)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(false));
        }
        return super.m_7417_(state, direction, newState, level, pos, posFrom);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos blockPos) {
        if (((Boolean)state.m_61143_((Property)HORIZONTAL)).booleanValue()) {
            Direction offset = (Direction)state.m_61143_((Property)HORIZONTAL_DIRECTION);
            if (!levelReader.m_8055_(blockPos.m_121945_(offset)).m_60713_((Block)this)) {
                return false;
            }
        } else {
            BlockState checkState = levelReader.m_8055_(blockPos.m_7495_());
            return checkState.m_204336_(BMBlocks.SAGUARO_CACTUS_PLANTABLE) && !levelReader.m_8055_(blockPos.m_7494_()).m_278721_();
        }
        return super.m_7898_(state, levelReader, blockPos);
    }

    public boolean isGrowBlock(BlockState state) {
        return state.m_60713_(Blocks.f_49992_) || state.m_60713_(Blocks.f_49993_);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShape(blockState);
    }

    public VoxelShape getShape(BlockState state) {
        return this.shapes.get(state);
    }

    private VoxelShape getShapeForState(BlockState state) {
        double size = 4.0;
        VoxelShape base = (Boolean)state.m_61143_((Property)HORIZONTAL) != false ? Block.m_49796_((double)size, (double)(size * 2.0), (double)size, (double)(16.0 - size), (double)15.98, (double)(16.0 - size)) : Block.m_49796_((double)size, (double)0.0, (double)size, (double)(16.0 - size), (double)15.98, (double)(16.0 - size));
        ArrayList connections = Lists.newArrayList();
        for (Direction dir : Direction.values()) {
            double x;
            if (dir == Direction.DOWN || dir == Direction.UP || !((Boolean)state.m_61143_((Property)FACING_PROPERTIES.get(dir))).booleanValue()) continue;
            double d = dir == Direction.WEST ? 0.0 : (x = dir == Direction.EAST ? 16.0 : size);
            double z = dir == Direction.NORTH ? 0.0 : (dir == Direction.SOUTH ? 16.0 : size);
            double upper = 16.0 - size;
            double minX = Math.min(x, upper) / 16.0;
            double maxX = Math.max(x, upper) / 16.0;
            double minZ = Math.min(z, upper) / 16.0;
            double maxZ = Math.max(z, upper) / 16.0;
            VoxelShape sh = Shapes.m_83048_((double)minX, (double)0.5, (double)minZ, (double)maxX, (double)0.99875, (double)maxZ);
            connections.add(sh);
        }
        return Shapes.m_83124_((VoxelShape)base, (VoxelShape[])connections.toArray(new VoxelShape[0]));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EAST, WEST, NORTH, SOUTH, HORIZONTAL, HORIZONTAL_DIRECTION});
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (this.m_7370_((LevelReader)serverLevel, blockPos, blockState, serverLevel.f_46443_) && random.m_188503_(10) == 0) {
            this.m_214148_(serverLevel, random, blockPos, blockState);
        }
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        entity.m_6469_(level.m_269111_().m_269325_(), 1.0f);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public boolean m_7370_(LevelReader blockGetter, BlockPos blockPos, BlockState blockState, boolean isClient) {
        return blockState.equals(this.m_49966_()) && this.isGrowBlock(blockGetter.m_8055_(blockPos.m_7495_())) && blockGetter.m_8055_(blockPos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return (double)level.f_46441_.m_188501_() < 0.45;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource random, BlockPos blockPos, BlockState blockState) {
        SaguaroCactusBlock.generateCactus((Block)this, (WorldGenLevel)serverLevel, random.m_188499_(), blockPos, random, false);
    }

    public BlockPathTypes getNodePathType() {
        return BlockPathTypes.DAMAGE_OTHER;
    }

    public static boolean generateCactus(Block block, WorldGenLevel world, boolean northSouth, BlockPos pos, RandomSource random, boolean isBig) {
        BlockPos nextPos;
        Direction[] directions;
        if (!block.m_49966_().m_60710_((LevelReader)world, pos)) {
            return false;
        }
        boolean hasArms = random.m_188503_(10) > 1;
        boolean has2Arms = random.m_188503_(5) != 0;
        int centerHeight = RandomUtil.randomRange(4, 8);
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        for (int yy = 0; yy < centerHeight && (yy <= 0 || world.m_8055_((BlockPos)p).m_60795_()); ++yy) {
            world.m_7731_((BlockPos)p, block.m_49966_(), 2);
            p.m_122173_(Direction.UP);
        }
        if (!hasArms) {
            return true;
        }
        int centerEndY = p.m_123342_();
        int armStart = RandomUtil.randomRange(1, centerHeight - 2);
        Direction[] directionArray = directions = northSouth ? NORTH_SOUTH : EAST_WEST;
        if (has2Arms) {
            for (Direction d : directions) {
                SaguaroCactusBlock.generateArm(block, world, d, p.m_123341_(), pos.m_123342_() + armStart, p.m_123343_(), centerEndY);
                armStart = RandomUtil.randomRange(1, centerHeight - 2);
            }
        } else {
            SaguaroCactusBlock.generateArm(block, world, directions[random.m_188503_(directions.length)], p.m_123341_(), pos.m_123342_() + armStart, p.m_123343_(), centerEndY);
        }
        if ((!isBig && random.m_188503_(10) == 0 || isBig && random.m_188503_(50) == 0) && world.m_8055_(nextPos = new BlockPos(pos.m_123341_(), centerEndY, pos.m_123343_())).m_60795_()) {
            SaguaroCactusBlock.generateCactus(block, world, random.m_188499_(), nextPos, random, true);
        }
        return true;
    }

    private static void generateArm(Block block, WorldGenLevel world, Direction direction, int centerX, int armY, int centerZ, int centerHeight) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(centerX + direction.m_122429_(), armY, centerZ + direction.m_122431_());
        if (!world.m_8055_((BlockPos)p).m_60795_()) {
            return;
        }
        BlockPos centerPos = p.m_121945_(direction.m_122424_());
        BlockState centerState = world.m_8055_(centerPos);
        if (!centerState.m_60713_(block)) {
            return;
        }
        world.m_7731_(centerPos, (BlockState)centerState.m_61124_((Property)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(true)), 2);
        world.m_7731_((BlockPos)p, (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)HORIZONTAL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HORIZONTAL_DIRECTION, (Comparable)direction.m_122424_())).m_61124_((Property)FACING_PROPERTIES.get(direction.m_122424_()), (Comparable)Boolean.valueOf(true)), 2);
        p.m_122173_(Direction.UP);
        int amt = Math.max(1, centerHeight - p.m_123342_() + RandomUtil.randomRange(-3, -1));
        for (int i = 0; i < amt; ++i) {
            if (!world.m_8055_((BlockPos)p).m_60795_()) {
                return;
            }
            world.m_7731_((BlockPos)p, block.m_49966_(), 2);
            p.m_122173_(Direction.UP);
        }
    }
}

