/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.block.IvyBlock;
import party.lemons.biomemakeover.block.IvyShapedBlock;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.util.RandomUtil;
import party.lemons.taniwha.util.MathUtils;

public class MothBlossomBlock
extends IvyShapedBlock {
    public static final DirectionProperty BLOSSOM_DIRECTION = DirectionProperty.m_61549_((String)"blossom", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});
    private final int[] yOffset = new int[]{0, 1, -1};

    public MothBlossomBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BLOSSOM_DIRECTION, (Comparable)Direction.DOWN));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BLOSSOM_DIRECTION});
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos posFrom) {
        if (!MothBlossomBlock.isValidPlaceFace((LevelReader)level, direction.m_122424_(), posFrom, newState)) {
            if (direction == state.m_61143_((Property)BLOSSOM_DIRECTION)) {
                level.m_46961_(pos, false);
                return state;
            }
            if (this.hasDirection(state, direction)) {
                return this.getStateWithoutDirection(state, MothBlossomBlock.getPropertyForDirection(direction));
            }
        } else {
            return (BlockState)state.m_61124_((Property)MothBlossomBlock.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(true));
        }
        return super.m_7417_(state, direction, newState, level, pos, posFrom);
    }

    @Override
    public boolean hasDirection(BlockState blockState, Direction direction) {
        if (blockState.m_61143_((Property)BLOSSOM_DIRECTION) == direction) {
            return true;
        }
        return super.hasDirection(blockState, direction);
    }

    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 3; ++i) {
            if (!this.attemptSpread((Level)level, pos.m_7918_(0, this.yOffset[i], 0), random)) continue;
            return;
        }
    }

    private boolean attemptSpread(Level level, BlockPos pos, RandomSource random) {
        for (Direction direction : MathUtils.randomOrderedHorizontals()) {
            BlockPos offsetPos = pos.m_121945_(direction);
            BlockState placePosState = level.m_8055_(offsetPos);
            if (!placePosState.m_60795_() && (!placePosState.m_247087_() || placePosState.m_60713_((Block)BMBlocks.ITCHING_IVY.get())) || !IvyBlock.isValidPlaceFace((LevelReader)level, Direction.DOWN, pos.m_121945_(direction), level.m_8055_(pos.m_121945_(direction).m_7495_()))) continue;
            level.m_7731_(offsetPos, (BlockState)((Block)BMBlocks.ITCHING_IVY.get()).m_49966_().m_61124_((Property)IvyBlock.getPropertyForDirection(Direction.DOWN), (Comparable)Boolean.valueOf(true)), 3);
            level.m_186460_(offsetPos, (Block)BMBlocks.ITCHING_IVY.get(), 4);
            if (!random.m_188499_()) continue;
            return true;
        }
        return false;
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        this.m_213897_(blockState, serverLevel, blockPos, random);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(3) == 0) {
            double xx = 0.0;
            double yy = 0.0;
            double zz = 0.0;
            double vx = 0.0;
            double vy = 0.0;
            double vz = 0.0;
            switch ((Direction)state.m_61143_((Property)BLOSSOM_DIRECTION)) {
                case DOWN: {
                    xx = (float)pos.m_123341_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    zz = (float)pos.m_123343_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    yy = (float)pos.m_123342_() + 0.1f;
                    vx = RandomUtil.randomDirection(random.m_188501_() / 20.0f);
                    vz = RandomUtil.randomDirection(random.m_188501_() / 20.0f);
                    vy = random.m_188501_() / 10.0f;
                    break;
                }
                case UP: {
                    xx = (float)pos.m_123341_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    zz = (float)pos.m_123343_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    yy = (float)pos.m_123342_() + 0.9f;
                    vx = RandomUtil.randomDirection(random.m_188501_() / 20.0f);
                    vz = RandomUtil.randomDirection(random.m_188501_() / 20.0f);
                    vy = random.m_188501_() / 10.0f * -1.0f;
                    break;
                }
                case NORTH: {
                    xx = (float)pos.m_123341_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    zz = (float)pos.m_123343_() + 0.1f;
                    yy = (float)pos.m_123342_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    vx = RandomUtil.randomDirection(random.m_188501_() / 20.0f);
                    vz = random.m_188501_() / 10.0f;
                    vy = random.m_188501_() / 20.0f;
                    break;
                }
                case SOUTH: {
                    xx = (float)pos.m_123341_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    zz = (float)pos.m_123343_() + 0.9f;
                    yy = (float)pos.m_123342_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    vx = RandomUtil.randomDirection(random.m_188501_() / 20.0f);
                    vz = random.m_188501_() / 10.0f * -1.0f;
                    vy = random.m_188501_() / 20.0f;
                    break;
                }
                case WEST: {
                    xx = (double)pos.m_123341_() + 0.1;
                    zz = (float)pos.m_123343_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    yy = (float)pos.m_123342_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    vx = random.m_188501_() / 10.0f;
                    vz = RandomUtil.randomDirection(random.m_188501_() / 20.0f);
                    vy = random.m_188501_() / 20.0f;
                    break;
                }
                case EAST: {
                    xx = (double)pos.m_123341_() + 0.9;
                    zz = (float)pos.m_123343_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    yy = (float)pos.m_123342_() + 0.5f + RandomUtil.randomDirection(random.m_188501_() / 4.0f);
                    vx = random.m_188501_() / 10.0f * -1.0f;
                    vz = RandomUtil.randomDirection(random.m_188501_() / 20.0f);
                    vy = random.m_188501_() / 20.0f;
                }
            }
            level.m_7106_((ParticleOptions)BMEffects.BLOSSOM.get(), xx, yy, zz, vx, vy, vz);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos placeOffset = ctx.m_8083_().m_121945_(ctx.m_43719_().m_122424_());
        BlockState offsetState = ctx.m_43725_().m_8055_(placeOffset);
        if (MothBlossomBlock.isValidPlaceFace((LevelReader)ctx.m_43725_(), ctx.m_43719_().m_122424_(), placeOffset, offsetState)) {
            BlockState state = (BlockState)this.m_49966_().m_61124_((Property)BLOSSOM_DIRECTION, (Comparable)ctx.m_43719_().m_122424_());
            for (Direction dir : Direction.values()) {
                if (dir == ctx.m_43719_().m_122424_()) continue;
                placeOffset = ctx.m_8083_().m_121945_(dir);
                offsetState = ctx.m_43725_().m_8055_(placeOffset);
                boolean validFace = MothBlossomBlock.isValidPlaceFace((LevelReader)ctx.m_43725_(), dir, placeOffset, offsetState);
                state = (BlockState)state.m_61124_((Property)MothBlossomBlock.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(validFace));
            }
            return state;
        }
        return null;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)BLOSSOM_DIRECTION);
        BlockPos offsetPos = pos.m_121945_(dir);
        BlockState offsetState = level.m_8055_(offsetPos);
        return MothBlossomBlock.isValidPlaceFace(level, dir.m_122424_(), offsetPos, offsetState) || super.m_7898_(state, level, pos);
    }

    public BlockState getGrowState(LevelReader world, BlockPos pos) {
        BlockState placeState = this.m_49966_();
        ArrayList validDirections = Lists.newArrayList();
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.m_121945_(dir);
            BlockState offsetState = world.m_8055_(offsetPos);
            boolean validFace = MothBlossomBlock.isValidPlaceFace(world, dir, offsetPos, offsetState);
            placeState = (BlockState)placeState.m_61124_((Property)MothBlossomBlock.getPropertyForDirection(dir), (Comparable)Boolean.valueOf(validFace));
            if (!validFace) continue;
            validDirections.add(dir);
        }
        if (validDirections.isEmpty()) {
            return Blocks.f_50016_.m_49966_();
        }
        Direction blossomDir = (Direction)RandomUtil.choose(validDirections);
        placeState = (BlockState)placeState.m_61124_((Property)BLOSSOM_DIRECTION, (Comparable)blossomDir);
        return placeState;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        BlockState st = (BlockState)state.m_61124_((Property)MothBlossomBlock.getPropertyForDirection((Direction)state.m_61143_((Property)BLOSSOM_DIRECTION)), (Comparable)Boolean.valueOf(true));
        return (VoxelShape)this.shapes.get((Object)st);
    }
}

