/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudServer;
import club.iananderson.seasonhud.impl.seasons.mods.IModHelper;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasonsextras.FabricSeasonsExtras;
import java.time.LocalDateTime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class FabricSeasonsHelper
implements IModHelper {
    @Override
    public Item CALENDAR() {
        if (Common.fabricSeasonsLoaded() && Common.hasCalendarLoaded()) {
            return FabricSeasonsExtras.SEASON_CALENDAR_ITEM;
        }
        return null;
    }

    @Override
    public boolean isTropicalSeason(Player player) {
        return false;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        if (Common.fabricSeasonsLoaded()) {
            return FabricSeasons.CONFIG.isSeasonTiedWithSystemTime();
        }
        return false;
    }

    @Override
    public String getCurrentSubSeason(Player player) {
        Season currentSeasonState = FabricSeasons.getCurrentSeason((Level)player.m_9236_());
        if (currentSeasonState.toString().equalsIgnoreCase("fall")) {
            return "Autumn";
        }
        return currentSeasonState.toString();
    }

    @Override
    public String getCurrentSeason(Player player) {
        Season currentSeasonState = FabricSeasons.getCurrentSeason((Level)player.m_9236_());
        if (currentSeasonState.toString().equalsIgnoreCase("fall")) {
            return "Autumn";
        }
        return currentSeasonState.toString();
    }

    @Override
    public long getDate(Player player) {
        long dayLength = SeasonHudServer.getDayLength();
        long seasonLength = FabricSeasons.CONFIG.getSpringLength();
        long timeToNextSeason = FabricSeasons.getTimeToNextSeason((Level)player.m_9236_());
        if (this.isSeasonTiedWithSystemTime()) {
            return LocalDateTime.now().getDayOfMonth();
        }
        return (seasonLength - timeToNextSeason) / dayLength + 1L;
    }

    @Override
    public int seasonDuration(Player player) {
        int dayLength = SeasonHudServer.getDayLength();
        return FabricSeasons.CONFIG.getSpringLength() / dayLength;
    }
}

