/*
 * Decompiled with CFR 0.152.
 */
package coda.oddorganisms;

import coda.oddorganisms.common.entities.Apthoroblattina;
import coda.oddorganisms.common.entities.Borealopelta;
import coda.oddorganisms.common.entities.DawnHorse;
import coda.oddorganisms.common.entities.Doedicurus;
import coda.oddorganisms.common.entities.Eolactoria;
import coda.oddorganisms.common.entities.Falcatus;
import coda.oddorganisms.common.entities.Leptictidium;
import coda.oddorganisms.common.entities.Slovenicus;
import coda.oddorganisms.registry.OOBlocks;
import coda.oddorganisms.registry.OOEntities;
import coda.oddorganisms.registry.OOItems;
import coda.oddorganisms.registry.OOSounds;
import coda.oddorganisms.registry.OOTabs;
import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="oddorganisms")
public class OddOrganisms {
    public static final String MOD_ID = "oddorganisms";

    public OddOrganisms() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        OOEntities.ENTITIES.register(bus);
        OOItems.ITEMS.register(bus);
        OOBlocks.BLOCKS.register(bus);
        OOSounds.SOUNDS.register(bus);
        OOTabs.TABS.register(bus);
        forgeBus.addListener(this::addEntityGoals);
        forgeBus.addListener(this::livingDamage);
        forgeBus.addListener(this::playerAttack);
        bus.addListener(this::registerAttributes);
        bus.addListener(this::registerSpawnPlacements);
    }

    private void registerAttributes(EntityAttributeCreationEvent e) {
        e.put((EntityType)OOEntities.DAWN_HORSE.get(), DawnHorse.createAttributes().m_22265_());
        e.put((EntityType)OOEntities.DOEDICURUS.get(), Doedicurus.createAttributes().m_22265_());
        e.put((EntityType)OOEntities.EOLACTORIA.get(), Eolactoria.m_27495_().m_22265_());
        e.put((EntityType)OOEntities.APTHOROBLATTINA.get(), Apthoroblattina.createAttributes().m_22265_());
        e.put((EntityType)OOEntities.LEPTICTIDIUM.get(), Leptictidium.createAttributes().m_22265_());
        e.put((EntityType)OOEntities.BOREALOPELTA.get(), Borealopelta.createAttributes().m_22265_());
        e.put((EntityType)OOEntities.FALCATUS.get(), Falcatus.m_27495_().m_22265_());
        e.put((EntityType)OOEntities.SLOVENICUS.get(), Slovenicus.m_27495_().m_22265_());
    }

    private void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)OOEntities.DAWN_HORSE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this::canLandAnimalSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)OOEntities.DOEDICURUS.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this::canLandAnimalSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)OOEntities.EOLACTORIA.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this::canFishAnimalSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)OOEntities.APTHOROBLATTINA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this::canLandAnimalSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)OOEntities.LEPTICTIDIUM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this::canLandAnimalSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)OOEntities.BOREALOPELTA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this::canLandAnimalSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)OOEntities.FALCATUS.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this::canFishAnimalSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)OOEntities.SLOVENICUS.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this::canFishAnimalSpawn, SpawnPlacementRegisterEvent.Operation.OR);
    }

    private boolean canLandAnimalSpawn(EntityType<? extends Animal> p_186238_, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource p_186242_) {
        return level.m_8055_(pos.m_7495_()).m_204336_(UPTags.DINO_NATURAL_SPAWNABLE) && (Boolean)UnusualPrehistoryConfig.DINO_NATURAL_SPAWNING.get() != false;
    }

    private boolean canFishAnimalSpawn(EntityType<? extends AbstractFish> p_186238_, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource p_186242_) {
        return level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_) && (Boolean)UnusualPrehistoryConfig.DINO_NATURAL_SPAWNING.get() != false;
    }

    private void livingDamage(LivingDamageEvent e) {
        Player player;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_6844_(EquipmentSlot.CHEST).m_150930_((Item)OOItems.DOEDICURUS_CHESTPLATE.get()) && player.m_6144_() && this.isValidSource(e.getSource())) {
            chestplate = player.m_6844_(EquipmentSlot.CHEST);
            chestplate.m_41622_((int)e.getAmount(), (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.CHEST));
            e.setCanceled(true);
        } else {
            chestplate = e.getSource().m_7639_();
            if (chestplate instanceof Doedicurus) {
                Player player2;
                Doedicurus doedicurus = (Doedicurus)chestplate;
                chestplate = e.getEntity();
                if (chestplate instanceof Player && (player2 = (Player)chestplate).m_21254_()) {
                    if (player2.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)OOItems.DOEDICURUS_CHESTPLATE.get()) && player2.m_6144_()) {
                        return;
                    }
                    ItemEntity item = (ItemEntity)EntityType.f_20461_.m_20615_(doedicurus.m_9236_());
                    item.m_20219_(doedicurus.m_20182_());
                    item.m_32045_(new ItemStack((ItemLike)OOItems.DOEDICURUS_SCUTE.get(), doedicurus.m_217043_().m_188503_(2)));
                    doedicurus.m_9236_().m_7967_((Entity)item);
                }
            }
        }
    }

    private boolean isValidSource(DamageSource source) {
        return !source.m_269533_(DamageTypeTags.f_268745_) && !source.m_276093_(DamageTypes.f_268515_) && !source.m_269533_(DamageTypeTags.f_268549_);
    }

    private void playerAttack(AttackEntityEvent e) {
        Player player = e.getEntity();
        if (player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)OOItems.DOEDICURUS_CHESTPLATE.get()) && player.m_6144_()) {
            player.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
            e.setCanceled(true);
        }
    }

    private void addEntityGoals(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)wolf, DawnHorse.class, true));
        }
    }
}

