/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.variables;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.variables.Variable;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableHandler {
    protected static final File VARIABLES_FILE = new File(FancyMenu.MOD_DIR.getPath() + "/user_variables.db");
    protected static final Map<String, Variable> VARIABLES = new HashMap<String, Variable>();

    public static void init() {
        VariableHandler.readFromFile();
        for (Variable v : VariableHandler.getVariables()) {
            if (!v.resetOnLaunch) continue;
            v.value = "";
        }
        VariableHandler.writeToFile();
    }

    public static void setVariable(@NotNull String name, @Nullable String value) {
        Variable v = VariableHandler.getVariable(name);
        if (v == null) {
            v = new Variable(name);
            VARIABLES.put(name, v);
        }
        v.setValue(value);
        VariableHandler.writeToFile();
    }

    public static void removeVariable(String name) {
        VARIABLES.remove(name);
        VariableHandler.writeToFile();
    }

    @Nullable
    public static Variable getVariable(String name) {
        return VARIABLES.get(name);
    }

    @NotNull
    public static List<Variable> getVariables() {
        return new ArrayList<Variable>(VARIABLES.values());
    }

    @NotNull
    public static List<String> getVariableNames() {
        return new ArrayList<String>(VARIABLES.keySet());
    }

    public static void clearVariables() {
        VARIABLES.clear();
        VariableHandler.writeToFile();
    }

    public static boolean variableExists(@NotNull String name) {
        return VariableHandler.getVariable(name) != null;
    }

    protected static void writeToFile() {
        try {
            if (!VARIABLES_FILE.exists()) {
                VARIABLES_FILE.createNewFile();
            }
            PropertyContainerSet set = new PropertyContainerSet("user_variables");
            for (Variable v : VARIABLES.values()) {
                set.putContainer(v.serialize());
            }
            PropertiesParser.serializeSetToFile(set, VARIABLES_FILE.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void readFromFile() {
        try {
            if (!VARIABLES_FILE.exists()) {
                VariableHandler.writeToFile();
            }
            VARIABLES.clear();
            PropertyContainerSet set = PropertiesParser.deserializeSetFromFile(VARIABLES_FILE.getPath());
            if (set != null) {
                if (set.getType().equals("cached_variables")) {
                    VariableHandler.readFromLegacyFile();
                } else {
                    List<PropertyContainer> secs = set.getContainersOfType("variable");
                    for (PropertyContainer c : secs) {
                        Variable v = Variable.deserialize(c);
                        if (v == null) continue;
                        VARIABLES.put(v.name, v);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void readFromLegacyFile() {
        try {
            List<PropertyContainer> secs;
            if (!VARIABLES_FILE.exists()) {
                VariableHandler.writeToFile();
            }
            VARIABLES.clear();
            PropertyContainerSet set = PropertiesParser.deserializeSetFromFile(VARIABLES_FILE.getPath());
            if (set != null && !(secs = set.getContainersOfType("variables")).isEmpty()) {
                PropertyContainer sec = secs.get(0);
                for (Map.Entry<String, String> m : sec.getProperties().entrySet()) {
                    Variable v = new Variable(m.getKey());
                    v.value = m.getValue();
                    VARIABLES.put(m.getKey(), v);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

