/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.Buddy;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.items.Poop;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BuddySerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String SAVE_FILENAME = "buddy_save.json";
    private static final File BUDDY_DIR = new File(FancyMenu.INSTANCE_DATA_DIR, "buddy");

    public static void saveBuddy(Buddy buddy) {
        try {
            File saveFile = new File(BUDDY_DIR, SAVE_FILENAME);
            JsonObject json = new JsonObject();
            json.addProperty("hunger", (Number)Float.valueOf(buddy.getHunger()));
            json.addProperty("happiness", (Number)Float.valueOf(buddy.getHappiness()));
            json.addProperty("energy", (Number)Float.valueOf(buddy.getEnergy()));
            json.addProperty("funLevel", (Number)Float.valueOf(buddy.getFunLevel()));
            json.addProperty("isPeeking", Boolean.valueOf(buddy.isPeeking));
            json.addProperty("hasBeenAwakened", Boolean.valueOf(buddy.hasBeenAwakened));
            json.addProperty("isActivelyPeeking", Boolean.valueOf(buddy.isActivelyPeeking));
            json.addProperty("peekTimer", (Number)buddy.peekTimer);
            json.addProperty("peekDuration", (Number)buddy.peekDuration);
            json.addProperty("screenWidth", (Number)buddy.getScreenWidth());
            json.addProperty("screenHeight", (Number)buddy.getScreenHeight());
            JsonArray poopsArray = new JsonArray();
            for (Poop poop : buddy.getPoops()) {
                JsonObject poopObj = new JsonObject();
                poopObj.addProperty("x", (Number)poop.getX());
                poopObj.addProperty("y", (Number)poop.getY());
                poopsArray.add((JsonElement)poopObj);
            }
            json.add("poops", (JsonElement)poopsArray);
            try (FileWriter writer = new FileWriter(saveFile);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
            LOGGER.debug("Saved buddy data to {}", (Object)saveFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save buddy data", (Throwable)e);
        }
    }

    public static boolean loadBuddy(Buddy buddy) {
        boolean bl;
        File saveFile = new File(BUDDY_DIR, SAVE_FILENAME);
        if (!saveFile.exists()) {
            LOGGER.debug("No buddy save file found at {}", (Object)saveFile.getAbsolutePath());
            return false;
        }
        FileReader reader = new FileReader(saveFile);
        try {
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (json.has("hunger")) {
                buddy.setHunger(json.get("hunger").getAsFloat());
            }
            if (json.has("happiness")) {
                buddy.setHappiness(json.get("happiness").getAsFloat());
            }
            if (json.has("energy")) {
                buddy.setEnergy(json.get("energy").getAsFloat());
            }
            if (json.has("funLevel")) {
                buddy.setFunLevel(json.get("funLevel").getAsFloat());
            }
            if (json.has("isPeeking")) {
                buddy.isPeeking = json.get("isPeeking").getAsBoolean();
            }
            if (json.has("hasBeenAwakened")) {
                buddy.hasBeenAwakened = json.get("hasBeenAwakened").getAsBoolean();
            }
            if (json.has("isActivelyPeeking")) {
                buddy.isActivelyPeeking = json.get("isActivelyPeeking").getAsBoolean();
            }
            if (json.has("peekTimer")) {
                buddy.peekTimer = json.get("peekTimer").getAsInt();
            }
            if (json.has("peekDuration")) {
                buddy.peekDuration = json.get("peekDuration").getAsInt();
            }
            if (json.has("poops")) {
                int savedHeight;
                JsonArray poopsArray = json.getAsJsonArray("poops");
                ArrayList<Poop> poops = new ArrayList<Poop>();
                int currentWidth = buddy.getScreenWidth();
                int currentHeight = buddy.getScreenHeight();
                int savedWidth = json.has("screenWidth") ? json.get("screenWidth").getAsInt() : currentWidth;
                int n = savedHeight = json.has("screenHeight") ? json.get("screenHeight").getAsInt() : currentHeight;
                if (savedWidth != currentWidth || savedHeight != currentHeight) {
                    LOGGER.debug("Screen size changed since last save: {}x{} -> {}x{}", (Object)savedWidth, (Object)savedHeight, (Object)currentWidth, (Object)currentHeight);
                }
                for (int i = 0; i < poopsArray.size(); ++i) {
                    boolean isInvalid;
                    JsonObject poopObj = poopsArray.get(i).getAsJsonObject();
                    int savedX = poopObj.get("x").getAsInt();
                    int savedY = poopObj.get("y").getAsInt();
                    boolean bl2 = isInvalid = savedX < 0 || savedY < 0 || savedX == Integer.MAX_VALUE || savedY == Integer.MAX_VALUE || savedX > 10000 || savedY > 10000;
                    if (isInvalid) {
                        LOGGER.debug("Skipped loading invalid poop at ({}, {})", (Object)savedX, (Object)savedY);
                        continue;
                    }
                    int x = savedX;
                    int y = savedY;
                    if (savedWidth > 0 && savedHeight > 0 && (savedWidth != currentWidth || savedHeight != currentHeight)) {
                        float xRatio = (float)savedX / (float)savedWidth;
                        float yRatio = (float)savedY / (float)savedHeight;
                        x = (int)(xRatio * (float)currentWidth);
                        y = (int)(yRatio * (float)currentHeight);
                        LOGGER.debug("Scaled poop from ({}, {}) to ({}, {})", (Object)savedX, (Object)savedY, (Object)x, (Object)y);
                    }
                    Poop poop = new Poop(x, y, buddy);
                    poops.add(poop);
                    LOGGER.debug("Loaded valid poop at ({}, {})", (Object)x, (Object)y);
                }
                LOGGER.debug("Loaded {} valid poops out of {} saved poops", (Object)poops.size(), (Object)poopsArray.size());
                buddy.setPoops(poops);
            }
            LOGGER.debug("Loaded buddy data from {}", (Object)saveFile.getAbsolutePath());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("Failed to load buddy data", e);
                return false;
            }
        }
        reader.close();
        return bl;
    }

    static {
        if (!BUDDY_DIR.exists()) {
            BUDDY_DIR.mkdirs();
            LOGGER.debug("Created buddy save directory at {}", (Object)BUDDY_DIR.getAbsolutePath());
        }
    }
}

