/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.network;

import java.util.function.Supplier;
import net.mcreator.luminousworld.LuminousworldMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LuminousworldModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LuminousworldMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        LuminousworldMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Monarch = message.data.Monarch;
                    variables.Blackswallowtail = message.data.Blackswallowtail;
                    variables.Springazure = message.data.Springazure;
                    variables.YellowSwallowtail = message.data.YellowSwallowtail;
                    variables.Buckeye = message.data.Buckeye;
                    variables.Hairstreak = message.data.Hairstreak;
                    variables.Whitehairstreak = message.data.Whitehairstreak;
                    variables.Bluemonarch = message.data.Bluemonarch;
                    variables.EmeraldSwallowtail = message.data.EmeraldSwallowtail;
                    variables.Rustypage = message.data.Rustypage;
                    variables.Littlewood = message.data.Littlewood;
                    variables.Zebralongwing = message.data.Zebralongwing;
                    variables.Orangetip = message.data.Orangetip;
                    variables.Mourningcloak = message.data.Mourningcloak;
                    variables.Charaxes = message.data.Charaxes;
                    variables.Ringlet = message.data.Ringlet;
                    variables.Cherryrose = message.data.Cherryrose;
                    variables.Birdwing = message.data.Birdwing;
                    variables.SoulMonarch = message.data.SoulMonarch;
                    variables.CrimsonMonarch = message.data.CrimsonMonarch;
                    variables.GlowstoneMorpho = message.data.GlowstoneMorpho;
                    variables.Enderfly = message.data.Enderfly;
                    variables.ChorusMorpho = message.data.ChorusMorpho;
                    variables.HasKilledTreeEnt = message.data.HasKilledTreeEnt;
                    variables.HasKilledKingHermit = message.data.HasKilledKingHermit;
                    variables.HasKilledMummy = message.data.HasKilledMummy;
                    variables.HasKilledSeaViper = message.data.HasKilledSeaViper;
                    variables.HasKilledYeti = message.data.HasKilledYeti;
                    variables.HasKilledPhoenix = message.data.HasKilledPhoenix;
                    variables.HasKilledBoneStalker = message.data.HasKilledBoneStalker;
                    variables.HasKilledVileGator = message.data.HasKilledVileGator;
                    variables.HasKilledWitchdoctor = message.data.HasKilledWitchdoctor;
                    variables.Firefly = message.data.Firefly;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean Monarch = false;
        public boolean Blackswallowtail = false;
        public boolean Springazure = false;
        public boolean YellowSwallowtail = false;
        public boolean Buckeye = false;
        public boolean Hairstreak = false;
        public boolean Whitehairstreak = false;
        public boolean Bluemonarch = false;
        public boolean EmeraldSwallowtail = false;
        public boolean Rustypage = false;
        public boolean Littlewood = false;
        public boolean Zebralongwing = false;
        public boolean Orangetip = false;
        public boolean Mourningcloak = false;
        public boolean Charaxes = false;
        public boolean Ringlet = false;
        public boolean Cherryrose = false;
        public boolean Birdwing = false;
        public boolean SoulMonarch = false;
        public boolean CrimsonMonarch = false;
        public boolean GlowstoneMorpho = false;
        public boolean Enderfly = false;
        public boolean ChorusMorpho = false;
        public boolean HasKilledTreeEnt = false;
        public boolean HasKilledKingHermit = false;
        public boolean HasKilledMummy = false;
        public boolean HasKilledSeaViper = false;
        public boolean HasKilledYeti = false;
        public boolean HasKilledPhoenix = false;
        public boolean HasKilledBoneStalker = false;
        public boolean HasKilledVileGator = false;
        public boolean HasKilledWitchdoctor = false;
        public boolean Firefly = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                LuminousworldMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("Monarch", this.Monarch);
            nbt.m_128379_("Blackswallowtail", this.Blackswallowtail);
            nbt.m_128379_("Springazure", this.Springazure);
            nbt.m_128379_("YellowSwallowtail", this.YellowSwallowtail);
            nbt.m_128379_("Buckeye", this.Buckeye);
            nbt.m_128379_("Hairstreak", this.Hairstreak);
            nbt.m_128379_("Whitehairstreak", this.Whitehairstreak);
            nbt.m_128379_("Bluemonarch", this.Bluemonarch);
            nbt.m_128379_("EmeraldSwallowtail", this.EmeraldSwallowtail);
            nbt.m_128379_("Rustypage", this.Rustypage);
            nbt.m_128379_("Littlewood", this.Littlewood);
            nbt.m_128379_("Zebralongwing", this.Zebralongwing);
            nbt.m_128379_("Orangetip", this.Orangetip);
            nbt.m_128379_("Mourningcloak", this.Mourningcloak);
            nbt.m_128379_("Charaxes", this.Charaxes);
            nbt.m_128379_("Ringlet", this.Ringlet);
            nbt.m_128379_("Cherryrose", this.Cherryrose);
            nbt.m_128379_("Birdwing", this.Birdwing);
            nbt.m_128379_("SoulMonarch", this.SoulMonarch);
            nbt.m_128379_("CrimsonMonarch", this.CrimsonMonarch);
            nbt.m_128379_("GlowstoneMorpho", this.GlowstoneMorpho);
            nbt.m_128379_("Enderfly", this.Enderfly);
            nbt.m_128379_("ChorusMorpho", this.ChorusMorpho);
            nbt.m_128379_("HasKilledTreeEnt", this.HasKilledTreeEnt);
            nbt.m_128379_("HasKilledKingHermit", this.HasKilledKingHermit);
            nbt.m_128379_("HasKilledMummy", this.HasKilledMummy);
            nbt.m_128379_("HasKilledSeaViper", this.HasKilledSeaViper);
            nbt.m_128379_("HasKilledYeti", this.HasKilledYeti);
            nbt.m_128379_("HasKilledPhoenix", this.HasKilledPhoenix);
            nbt.m_128379_("HasKilledBoneStalker", this.HasKilledBoneStalker);
            nbt.m_128379_("HasKilledVileGator", this.HasKilledVileGator);
            nbt.m_128379_("HasKilledWitchdoctor", this.HasKilledWitchdoctor);
            nbt.m_128379_("Firefly", this.Firefly);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Monarch = nbt.m_128471_("Monarch");
            this.Blackswallowtail = nbt.m_128471_("Blackswallowtail");
            this.Springazure = nbt.m_128471_("Springazure");
            this.YellowSwallowtail = nbt.m_128471_("YellowSwallowtail");
            this.Buckeye = nbt.m_128471_("Buckeye");
            this.Hairstreak = nbt.m_128471_("Hairstreak");
            this.Whitehairstreak = nbt.m_128471_("Whitehairstreak");
            this.Bluemonarch = nbt.m_128471_("Bluemonarch");
            this.EmeraldSwallowtail = nbt.m_128471_("EmeraldSwallowtail");
            this.Rustypage = nbt.m_128471_("Rustypage");
            this.Littlewood = nbt.m_128471_("Littlewood");
            this.Zebralongwing = nbt.m_128471_("Zebralongwing");
            this.Orangetip = nbt.m_128471_("Orangetip");
            this.Mourningcloak = nbt.m_128471_("Mourningcloak");
            this.Charaxes = nbt.m_128471_("Charaxes");
            this.Ringlet = nbt.m_128471_("Ringlet");
            this.Cherryrose = nbt.m_128471_("Cherryrose");
            this.Birdwing = nbt.m_128471_("Birdwing");
            this.SoulMonarch = nbt.m_128471_("SoulMonarch");
            this.CrimsonMonarch = nbt.m_128471_("CrimsonMonarch");
            this.GlowstoneMorpho = nbt.m_128471_("GlowstoneMorpho");
            this.Enderfly = nbt.m_128471_("Enderfly");
            this.ChorusMorpho = nbt.m_128471_("ChorusMorpho");
            this.HasKilledTreeEnt = nbt.m_128471_("HasKilledTreeEnt");
            this.HasKilledKingHermit = nbt.m_128471_("HasKilledKingHermit");
            this.HasKilledMummy = nbt.m_128471_("HasKilledMummy");
            this.HasKilledSeaViper = nbt.m_128471_("HasKilledSeaViper");
            this.HasKilledYeti = nbt.m_128471_("HasKilledYeti");
            this.HasKilledPhoenix = nbt.m_128471_("HasKilledPhoenix");
            this.HasKilledBoneStalker = nbt.m_128471_("HasKilledBoneStalker");
            this.HasKilledVileGator = nbt.m_128471_("HasKilledVileGator");
            this.HasKilledWitchdoctor = nbt.m_128471_("HasKilledWitchdoctor");
            this.Firefly = nbt.m_128471_("Firefly");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("luminousworld", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "luminousworld_mapvars";
        public double pebbleamount = 0.0;
        public double pit_number = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.pebbleamount = nbt.m_128459_("pebbleamount");
            this.pit_number = nbt.m_128459_("pit_number");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("pebbleamount", this.pebbleamount);
            nbt.m_128347_("pit_number", this.pit_number);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                LuminousworldMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "luminousworld_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                LuminousworldMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Monarch = original.Monarch;
            clone.Blackswallowtail = original.Blackswallowtail;
            clone.Springazure = original.Springazure;
            clone.YellowSwallowtail = original.YellowSwallowtail;
            clone.Buckeye = original.Buckeye;
            clone.Hairstreak = original.Hairstreak;
            clone.Whitehairstreak = original.Whitehairstreak;
            clone.Bluemonarch = original.Bluemonarch;
            clone.EmeraldSwallowtail = original.EmeraldSwallowtail;
            clone.Rustypage = original.Rustypage;
            clone.Littlewood = original.Littlewood;
            clone.Zebralongwing = original.Zebralongwing;
            clone.Orangetip = original.Orangetip;
            clone.Mourningcloak = original.Mourningcloak;
            clone.Charaxes = original.Charaxes;
            clone.Ringlet = original.Ringlet;
            clone.Cherryrose = original.Cherryrose;
            clone.Birdwing = original.Birdwing;
            clone.SoulMonarch = original.SoulMonarch;
            clone.CrimsonMonarch = original.CrimsonMonarch;
            clone.GlowstoneMorpho = original.GlowstoneMorpho;
            clone.Enderfly = original.Enderfly;
            clone.ChorusMorpho = original.ChorusMorpho;
            clone.HasKilledTreeEnt = original.HasKilledTreeEnt;
            clone.HasKilledKingHermit = original.HasKilledKingHermit;
            clone.HasKilledMummy = original.HasKilledMummy;
            clone.HasKilledSeaViper = original.HasKilledSeaViper;
            clone.HasKilledYeti = original.HasKilledYeti;
            clone.HasKilledPhoenix = original.HasKilledPhoenix;
            clone.HasKilledBoneStalker = original.HasKilledBoneStalker;
            clone.HasKilledVileGator = original.HasKilledVileGator;
            clone.HasKilledWitchdoctor = original.HasKilledWitchdoctor;
            clone.Firefly = original.Firefly;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    LuminousworldMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    LuminousworldMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                LuminousworldMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

