/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.peculiarprimordials.entity.custom;

import com.peeko32213.unusualprehistory.common.entity.EntityMajungasaurus;
import com.peeko32213.unusualprehistory.common.entity.EntityTyrannosaurusRex;
import com.peeko32213.unusualprehistory.common.entity.IBookEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.thevaliantsquidward.peculiarprimordials.entity.ModEntities;
import net.thevaliantsquidward.peculiarprimordials.entity.custom.NeilpeartiaEntity;
import net.thevaliantsquidward.peculiarprimordials.entity.msc.util.navigator.PPFlyingMoveController;
import net.thevaliantsquidward.peculiarprimordials.item.ModItems;
import net.thevaliantsquidward.peculiarprimordials.sound.ModSounds;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TapejaraEntity
extends EntityBaseDinosaurAnimal
implements GeoEntity,
NeutralMob,
IBookEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @javax.annotation.Nullable
    private UUID persistentAngerTarget;
    private static final EntityDataAccessor<Boolean> FLYING;
    private static final EntityDataAccessor<Integer> CROPS_POLLINATED;
    private static final EntityDataAccessor<Boolean> FROM_BOOK;
    private static final UniformInt PERSISTENT_ANGER_TIME;
    private static final UniformInt ALERT_INTERVAL;
    private static final int ALERT_RANGE_Y = 10;
    private int remainingPersistentAngerTime;
    private boolean isSchool = true;
    private int ticksUntilNextAlert;
    public int pollinateCooldown = 0;
    public final float[] ringBuffer = new float[64];
    public float prevFlyProgress;
    public float flyProgress;
    public int ringBufferIndex = -1;
    private boolean isLandNavigator;
    private int timeFlying;
    private static final RawAnimation ANURO_WALK;
    private static final RawAnimation ANURO_IDLE;
    private static final RawAnimation ANURO_FLY;
    private static final RawAnimation ANURO_BITE;
    private static final EntityDataAccessor<Integer> VARIANT;
    public boolean cooldown = false;
    public int cooldowntimer = 6000;

    public TapejaraEntity(EntityType<? extends EntityBaseDinosaurAnimal> entityType, Level level) {
        super(entityType, level);
        this.switchNavigator(true);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22276_, 16.0).m_22265_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new AIFlyIdle());
        GoalSelector var10000 = this.f_21345_;
        Predicate var10009 = EntitySelector.f_20408_;
        Objects.requireNonNull(var10009);
        var10000.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityMajungasaurus.class, 8.0f, 1.6, 1.4, var10009::test));
        var10000 = this.f_21345_;
        var10009 = EntitySelector.f_20408_;
        Objects.requireNonNull(var10009);
        var10000.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityTyrannosaurusRex.class, 8.0f, 1.6, 1.4, var10009::test));
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new PPFlyingMoveController((Mob)this, 0.6f, false, true);
            this.f_21344_ = new FlyingPathNavigation((Mob)this, this.m_9236_()){

                public boolean m_6342_(BlockPos pos) {
                    return !this.f_26495_.m_8055_(pos.m_6625_(2)).m_60795_();
                }
            };
            this.f_21344_.m_7008_(false);
            this.isLandNavigator = false;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(CROPS_POLLINATED, (Object)0);
        this.f_19804_.m_135372_(FROM_BOOK, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevFlyProgress = this.flyProgress;
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.ringBufferIndex < 0) {
            for (int i = 0; i < this.ringBuffer.length; ++i) {
                this.ringBuffer[i] = 15.0f;
            }
        }
        if (this.pollinateCooldown > 0) {
            --this.pollinateCooldown;
        }
        ++this.ringBufferIndex;
        if (this.ringBufferIndex == this.ringBuffer.length) {
            this.ringBufferIndex = 0;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.isFlying()) {
                if (this.isFlying() && !this.m_20096_() && !this.m_20072_()) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, (double)0.6f, 1.0));
                }
                if (this.m_20096_() && this.timeFlying > 20) {
                    this.setFlying(false);
                }
                ++this.timeFlying;
            } else {
                this.timeFlying = 0;
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean prev = super.m_6469_(source, amount);
        return prev;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268585_) || super.m_6673_(source);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        if (!flying || !this.m_6162_()) {
            this.f_19804_.m_135381_(FLYING, (Object)flying);
        }
    }

    public int getCropsPollinated() {
        return (Integer)this.f_19804_.m_135370_(CROPS_POLLINATED);
    }

    public void setCropsPollinated(int crops) {
        this.f_19804_.m_135381_(CROPS_POLLINATED, (Object)crops);
    }

    public boolean canBlockBeSeen(BlockPos pos) {
        double x = (float)pos.m_123341_() + 0.5f;
        double y = (float)pos.m_123342_() + 0.5f;
        double z = (float)pos.m_123343_() + 0.5f;
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_()), new Vec3(x, y, z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        double dist = result.m_82450_().m_82531_(x, y, z);
        return dist <= 1.0 || result.m_6662_() == HitResult.Type.MISS;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == UPItems.BLUE_FRUIT.get() && !this.cooldown && !this.m_9236_().f_46443_) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.cooldown = true;
            this.m_5634_(10.0f);
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            if (this.getVariant() == 1) {
                this.m_19998_((ItemLike)ModItems.FLAMBOYANT_CREST.get());
                this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
            } else if (this.getVariant() == 2) {
                this.m_19998_((ItemLike)ModItems.ELEGANT_CREST.get());
                this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
            } else {
                this.m_19998_((ItemLike)ModItems.GILDED_CREST.get());
                this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_8107_() {
        if (this.cooldown) {
            --this.cooldowntimer;
        }
        if (this.cooldowntimer <= 0) {
            this.cooldown = false;
        }
        super.m_8107_();
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Flying", this.isFlying());
        compound.m_128405_("CropsPollinated", this.getCropsPollinated());
        compound.m_128405_("PollinateCooldown", this.pollinateCooldown);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFlying(compound.m_128471_("Flying"));
        this.setCropsPollinated(compound.m_128451_("CropsPollinated"));
        this.pollinateCooldown = compound.m_128451_("PollinateCooldown");
        this.setVariant(compound.m_128451_("Variant"));
    }

    public void determineVariant(int variantChange) {
        if (variantChange <= 33) {
            this.setVariant(2);
        } else if (variantChange <= 66) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int variantChange = this.f_19796_.m_216339_(0, 100);
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.determineVariant(variantChange);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)ModEntities.TAPEJARA.get()).m_20615_((Level)serverLevel);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.FLAMBOYANT_TOOT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.FLAMBOYANT_TOOT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.FLAMBOYANT_TOOT.get();
    }

    public void killed(ServerLevel world, LivingEntity entity) {
        this.m_5634_(10.0f);
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = -9.450001f - (float)this.m_217043_().m_188503_(24);
        float neg = this.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float renderYawOffset = this.f_20883_;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.m_7096_() + extraX), (int)this.m_20186_(), (int)(fleePos.m_7094_() + extraZ));
        BlockPos ground = this.getAnuroGround(radialPos);
        if (ground.m_123342_() == -64) {
            return this.m_20182_();
        }
        ground = this.m_20183_();
        while (ground.m_123342_() > -64 && !this.m_9236_().m_8055_(ground).m_280296_()) {
            ground = ground.m_7495_();
        }
        return !this.isTargetBlocked(Vec3.m_82512_((Vec3i)ground.m_7494_())) ? Vec3.m_82512_((Vec3i)ground) : null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        return this.m_9236_().m_45547_(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() != HitResult.Type.MISS;
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = 5.0f + radiusAdd + (float)this.m_217043_().m_188503_(5);
        float neg = this.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float renderYawOffset = this.f_20883_;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.m_7096_() + extraX), (int)this.m_20186_(), (int)(fleePos.m_7094_() + extraZ));
        BlockPos ground = this.getAnuroGround(radialPos);
        int distFromGround = (int)this.m_20186_() - ground.m_123342_();
        int flightHeight = 5 + this.m_217043_().m_188503_(5);
        int j = this.m_217043_().m_188503_(5) + 5;
        BlockPos newPos = ground.m_6630_(distFromGround > 5 ? flightHeight : j);
        return !this.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos)) && this.m_20238_(Vec3.m_82512_((Vec3i)newPos)) > 1.0 ? Vec3.m_82512_((Vec3i)newPos) : null;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.m_20183_();
        while (position.m_123342_() > -65 && this.m_9236_().m_46859_(position)) {
            position = position.m_7495_();
        }
        return !this.m_9236_().m_6425_(position).m_76178_() || this.m_9236_().m_8055_(position).m_60713_(Blocks.f_50191_) || position.m_123342_() <= -65;
    }

    public BlockPos getAnuroGround(BlockPos in) {
        BlockPos position = new BlockPos(in.m_123341_(), (int)this.m_20186_(), in.m_123343_());
        while (position.m_123342_() > -64 && !this.m_9236_().m_8055_(position).m_280296_() && this.m_9236_().m_6425_(position).m_76178_()) {
            position = position.m_7495_();
        }
        return position;
    }

    public boolean m_7327_(Entity target) {
        boolean shouldHurt;
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            damage += livingEntity.m_6336_().equals(MobType.f_21642_) ? damage : 0.0f;
            knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if (shouldHurt = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage)) {
            if (knockback > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, target);
            this.m_21335_(target);
        }
        return shouldHurt;
    }

    protected SoundEvent getAttackSound() {
        return null;
    }

    protected int getKillHealAmount() {
        return 0;
    }

    protected boolean canGetHungry() {
        return false;
    }

    protected boolean hasTargets() {
        return false;
    }

    protected boolean hasAvoidEntity() {
        return false;
    }

    protected boolean hasCustomNavigation() {
        return false;
    }

    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 0, this::attackController)});
    }

    protected <E extends TapejaraEntity> PlayState Controller(AnimationState<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.m_20096_() && this.m_20096_()) {
            return event.setAndContinue(ANURO_WALK);
        }
        return !event.isMoving() && this.m_20096_() && this.m_20096_() ? event.setAndContinue(ANURO_IDLE) : event.setAndContinue(ANURO_FLY);
    }

    protected <E extends TapejaraEntity> PlayState attackController(AnimationState<E> event) {
        return this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.PAUSED) ? event.setAndContinue(ANURO_BITE) : PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    public void setFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int p_21673_) {
        this.remainingPersistentAngerTime = p_21673_;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_21672_) {
        this.persistentAngerTarget = p_21672_;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public boolean isFromBook() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOOK);
    }

    public void setIsFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }

    static {
        VARIANT = SynchedEntityData.m_135353_(NeilpeartiaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        FLYING = SynchedEntityData.m_135353_(TapejaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        CROPS_POLLINATED = SynchedEntityData.m_135353_(TapejaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        FROM_BOOK = SynchedEntityData.m_135353_(TapejaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
        ALERT_INTERVAL = TimeUtil.m_145020_((int)4, (int)6);
        ANURO_WALK = RawAnimation.begin().thenLoop("animation.model.new5");
        ANURO_IDLE = RawAnimation.begin().thenLoop("animation.model.new4");
        ANURO_FLY = RawAnimation.begin().thenLoop("animation.model.fly");
        ANURO_BITE = RawAnimation.begin().thenPlay("animation.anuro.bite");
    }

    private class AIFlyIdle
    extends Goal {
        protected double x;
        protected double y;
        protected double z;

        public AIFlyIdle() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!(TapejaraEntity.this.m_20160_() || TapejaraEntity.this.m_5448_() != null && TapejaraEntity.this.m_5448_().m_6084_() || TapejaraEntity.this.m_20159_())) {
                if (TapejaraEntity.this.m_217043_().m_188503_(45) != 0 && !TapejaraEntity.this.isFlying()) {
                    return false;
                }
                Vec3 lvt_1_1_ = this.getPosition();
                if (lvt_1_1_ == null) {
                    return false;
                }
                this.x = lvt_1_1_.f_82479_;
                this.y = lvt_1_1_.f_82480_;
                this.z = lvt_1_1_.f_82481_;
                return true;
            }
            return false;
        }

        public void m_8037_() {
            TapejaraEntity.this.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            if (TapejaraEntity.this.isFlying() && TapejaraEntity.this.m_20096_() && TapejaraEntity.this.timeFlying > 10) {
                TapejaraEntity.this.setFlying(false);
            }
        }

        @javax.annotation.Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = TapejaraEntity.this.m_20182_();
            return TapejaraEntity.this.timeFlying >= 200 && !TapejaraEntity.this.isOverWaterOrVoid() ? TapejaraEntity.this.getBlockGrounding(vector3d) : TapejaraEntity.this.getBlockInViewAway(vector3d, 0.0f);
        }

        public boolean m_8045_() {
            return TapejaraEntity.this.isFlying() && TapejaraEntity.this.m_20275_(this.x, this.y, this.z) > 5.0;
        }

        public void m_8056_() {
            TapejaraEntity.this.setFlying(true);
            TapejaraEntity.this.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
        }

        public void m_8041_() {
            TapejaraEntity.this.m_21573_().m_26573_();
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            super.m_8041_();
        }
    }
}

