/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.peculiarprimordials.entity.custom;

import com.peeko32213.unusualprehistory.common.entity.IHatchableEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.thevaliantsquidward.peculiarprimordials.entity.ModEntities;
import net.thevaliantsquidward.peculiarprimordials.entity.ai.BottomWalkGoal;
import net.thevaliantsquidward.peculiarprimordials.item.ModItems;
import net.thevaliantsquidward.peculiarprimordials.tag.ModTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NeilpeartiaEntity
extends EntityBaseDinosaurAnimal
implements GeoEntity,
IHatchableEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private Level level;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(NeilpeartiaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PASSIVE = SynchedEntityData.m_135353_(NeilpeartiaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean passive = false;
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("peculiarprimordials", "gameplay/frogfishing");
    public int gulpNumber = 6000;
    public int gulpInterval = this.f_19796_.m_188503_(this.gulpNumber) + this.gulpNumber;
    private boolean dance;
    private static final EntityDataAccessor<Boolean> IS_GULPING = SynchedEntityData.m_135353_(NeilpeartiaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private BlockPos jukebox;

    public NeilpeartiaEntity(EntityType<? extends EntityBaseDinosaurAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ModTags.NEIL_FOOD);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new BottomWalkGoal((PathfinderMob)this, 1.5, 100, 0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    protected SoundEvent getAttackSound() {
        return null;
    }

    protected int getKillHealAmount() {
        return 0;
    }

    protected boolean canGetHungry() {
        return false;
    }

    protected boolean hasTargets() {
        return false;
    }

    protected boolean hasAvoidEntity() {
        return false;
    }

    protected boolean hasCustomNavigation() {
        return false;
    }

    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    public boolean m_6040_() {
        return true;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22276_, 16.0).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(IS_GULPING, (Object)false);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    public void determineVariant(int variantChange) {
        if (this.isKermit()) {
            this.setVariant(2);
        } else if (variantChange <= 30) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
    }

    public boolean isKermit() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && s.toLowerCase().contains("kermit");
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == UPItems.GOLDEN_SCAU.get() && !this.passive) {
            if (!this.m_9236_().f_46443_) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(20.0f);
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                this.passive = true;
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.m_41720_() == ModItems.CHARRED_STETHACANTHUS.get() && this.passive && !this.m_9236_().f_46443_) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_5634_(10.0f);
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.passive = false;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int variantChange = this.f_19796_.m_216339_(0, 100);
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.determineVariant(variantChange);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || super.m_6673_(source);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)ModEntities.NEILPEARTIA.get()).m_20615_((Level)serverLevel);
    }

    public void m_6818_(BlockPos pPos, boolean dancing) {
        this.jukebox = pPos;
        this.dance = dancing;
    }

    public boolean isDancing() {
        return this.dance;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 3.46) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.dance = false;
            this.jukebox = null;
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_() && --this.gulpInterval <= 0 && !this.dance && !this.passive && this.m_20069_()) {
            this.setGulping(true);
            this.spawnRandomItems();
            this.m_146850_(GameEvent.f_157810_);
            this.gulpInterval = this.f_19796_.m_188503_(this.gulpNumber) + this.gulpNumber;
            this.m_5496_(SoundEvents.f_11940_, 0.5f, 1.0f);
        } else if (this.gulpInterval > 0) {
            this.setGulping(false);
        }
    }

    private void spawnRandomItems() {
        List<ItemStack> loot = NeilpeartiaEntity.getFishingLoot(this);
        for (ItemStack itemStack : loot) {
            this.m_5552_(itemStack, 0.0f);
        }
    }

    private static List<ItemStack> getFishingLoot(NeilpeartiaEntity entity) {
        LootTable loottable = entity.m_9236_().m_7654_().m_278653_().m_278676_(LOOT_TABLE);
        return loottable.m_287195_(new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287235_(LootContextParamSets.f_81417_));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return SoundEvents.f_12529_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12528_, 0.15f, 1.0f);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || !this.m_20069_() || this.isDancing();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.isGulping()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.model.gulp", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && this.m_20069_() && this.m_20096_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.model.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() <= 1.0E-6 && this.m_20069_() && this.m_20096_() && !this.isFromBook()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.model.idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_20069_() && !this.m_20096_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.model.swim", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.model.beached", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isGulping() {
        return (Boolean)this.f_19804_.m_135370_(IS_GULPING);
    }

    public void setGulping(boolean gulping) {
        this.f_19804_.m_135381_(IS_GULPING, (Object)gulping);
    }
}

