/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.quark;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.ECPlatformStuff;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.every_compat.modules.botanypots.BotanyPotsHelper;
import net.mehvahdjukaar.every_compat.modules.quark.CompatChestBlock;
import net.mehvahdjukaar.every_compat.modules.quark.CompatChestBlockTile;
import net.mehvahdjukaar.every_compat.modules.quark.CompatTrappedChestBlock;
import net.mehvahdjukaar.every_compat.modules.quark.CompatTrappedChestBlockTile;
import net.mehvahdjukaar.every_compat.modules.quark.QuarkSimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.content.building.block.HedgeBlock;
import org.violetmoon.quark.content.building.block.HollowLogBlock;
import org.violetmoon.quark.content.building.block.LeafCarpetBlock;
import org.violetmoon.quark.content.building.block.VariantBookshelfBlock;
import org.violetmoon.quark.content.building.block.VariantChestBlock;
import org.violetmoon.quark.content.building.block.VariantLadderBlock;
import org.violetmoon.quark.content.building.block.VariantTrappedChestBlock;
import org.violetmoon.quark.content.building.block.VerticalSlabBlock;
import org.violetmoon.quark.content.building.block.WoodPostBlock;
import org.violetmoon.quark.content.building.client.render.be.VariantChestRenderer;
import org.violetmoon.quark.content.building.module.HedgesModule;
import org.violetmoon.quark.content.building.module.HollowLogsModule;
import org.violetmoon.quark.content.building.module.LeafCarpetModule;
import org.violetmoon.quark.content.building.module.VariantBookshelvesModule;
import org.violetmoon.quark.content.building.module.VariantChestsModule;
import org.violetmoon.quark.content.building.module.VariantLaddersModule;
import org.violetmoon.quark.content.building.module.VerticalPlanksModule;
import org.violetmoon.quark.content.building.module.VerticalSlabsModule;
import org.violetmoon.quark.content.building.module.WoodenPostsModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.client.SimpleWithoutLevelRenderer;

public class QuarkModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> verticalSlabs;
    public final SimpleEntrySet<WoodType, Block> bookshelves;
    public final SimpleEntrySet<WoodType, Block> posts;
    public final SimpleEntrySet<WoodType, Block> strippedPosts;
    public final SimpleEntrySet<WoodType, Block> verticalPlanks;
    public final SimpleEntrySet<WoodType, Block> ladders;
    public final SimpleEntrySet<WoodType, Block> hollowLogs;
    public final SimpleEntrySet<WoodType, VariantChestBlock> chests;
    public final SimpleEntrySet<WoodType, VariantTrappedChestBlock> trappedChests;
    public final SimpleEntrySet<LeavesType, Block> hedges;
    public final SimpleEntrySet<LeavesType, Block> leafCarpets;
    public static BlockEntityType<ChestBlockEntity> CHEST_TILE;
    public static BlockEntityType<ChestBlockEntity> TRAPPED_CHEST_TILE;

    public QuarkModule(String modId) {
        super(modId, "q");
        ResourceKey tab = CreativeModeTabs.f_256788_;
        this.verticalSlabs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "vertical_slab", VerticalSlabsModule.class, this.getModBlock("oak_vertical_slab"), () -> WoodTypeRegistry.OAK_TYPE, w -> new VerticalSlabBlock(() -> w.getBlockOfThis("slab"), Utils.copyPropertySafe((Block)Objects.requireNonNull(w.getBlockOfThis("slab"))).m_60918_(w.getSound()))).requiresChildren(new String[]{"slab"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("wooden_vertical_slabs"), Registries.f_256747_)).addTag(this.modRes("vertical_slabs"), Registries.f_256747_)).addTag(this.modRes("vertical_slab"), Registries.f_256747_)).addTag(this.modRes("wooden_vertical_slabs"), Registries.f_256913_)).addTag(this.modRes("vertical_slabs"), Registries.f_256913_)).addTag(this.modRes("vertical_slab"), Registries.f_256913_)).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/vertslabs/oak_vertical_slab"))).addRecipe(this.modRes("building/crafting/vertslabs/oak_vertical_slab_revert"))).addCondition(woodType -> !PlatHelper.isModLoaded((String)"v_slab_compat"))).copyParentDrop().build();
        this.addEntry(this.verticalSlabs);
        this.bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "bookshelf", VariantBookshelvesModule.class, this.getModBlock("acacia_bookshelf"), () -> WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("acacia")), w -> new VariantBookshelfBlock(this.shortenedId() + "/" + w.getAppendableId(), null, w.canBurn(), w.getSound())).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).copyParentDrop().addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(new ResourceLocation("forge:bookshelves"), Registries.f_256747_)).addTag(new ResourceLocation("forge:bookshelves"), Registries.f_256913_)).addRecipe(this.modRes("building/crafting/acacia_bookshelf"))).addTextureM(EveryCompat.res("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))).setPalette(this::bookshelfPalette)).build();
        this.addEntry(this.bookshelves);
        this.posts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "post", WoodenPostsModule.class, this.getModBlock("oak_post"), () -> WoodTypeRegistry.OAK_TYPE, w -> {
            Block fence = w.getBlockOfThis("fence");
            return new WoodPostBlock(null, Objects.requireNonNull(fence), this.shortenedId() + "/" + w.getNamespace() + "/", Objects.requireNonNull(fence).m_49962_(fence.m_49966_()));
        }).requiresChildren(new String[]{"fence", "wood"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256913_)).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/oak_post"))).setRenderType(RenderLayer.CUTOUT).build();
        this.addEntry(this.posts);
        this.strippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "post", "stripped", WoodenPostsModule.class, this.getModBlock("stripped_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, w -> {
            if (w.getNamespace().equals("malum") || w.getNamespace().equals("twigs")) {
                return null;
            }
            Block fence = w.getBlockOfThis("fence");
            return new WoodPostBlock(null, Objects.requireNonNull(fence), this.shortenedId() + "/" + w.getNamespace() + "/stripped_", Objects.requireNonNull(fence).m_49962_(fence.m_49966_()));
        }).requiresChildren(new String[]{"fence", "stripped_log", "stripped_wood"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256747_)).addTag(this.modRes("posts"), Registries.f_256913_)).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/stripped_oak_post"))).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.strippedPosts);
        this.verticalPlanks = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "planks", "vertical", VerticalPlanksModule.class, this.getModBlock("vertical_oak_planks"), () -> WoodTypeRegistry.OAK_TYPE, w -> {
            String name = this.shortenedId() + "/" + w.getVariantId("planks", "vertical");
            return new ZetaBlock(name, null, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
        }).addCondition(w -> !w.getId().toString().equals("gardens_of_the_dead:whistle_planks"))).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13090_, Registries.f_256747_)).addTag(BlockTags.f_13090_, Registries.f_256913_)).addRecipe(this.modRes("building/crafting/vertplanks/vertical_oak_planks"))).build();
        this.addEntry(this.verticalPlanks);
        this.ladders = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "ladder", VariantLaddersModule.class, this.getModBlock("spruce_ladder"), () -> WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("spruce")), w -> new VariantLadderBlock(this.shortenedId() + "/" + w.getAppendableId(), null, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_).m_60918_(w.getSound()), w.canBurn())).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(BlockTags.f_13082_, Registries.f_256747_)).addTag(this.modRes("ladders"), Registries.f_256747_)).addTag(this.modRes("ladders"), Registries.f_256913_)).addTexture(EveryCompat.res("block/spruce_ladder"))).addRecipe(this.modRes("building/crafting/spruce_ladder"))).setRenderType(RenderLayer.TRANSLUCENT).build();
        this.addEntry(this.ladders);
        this.hollowLogs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "log", "hollow", HollowLogsModule.class, this.getModBlock("hollow_oak_log"), () -> WoodTypeRegistry.OAK_TYPE, w -> new HollowLogBlock(this.shortenedId() + "/" + w.getAppendableId(), w.log, null, w.canBurn())).requiresChildren(new String[]{"stripped_log"})).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("hollow_logs"), Registries.f_256747_)).addTag(this.modRes("hollow_logs"), Registries.f_256913_)).addRecipe(this.modRes("building/crafting/hollowlogs/hollow_oak_log"))).build();
        this.addEntry(this.hollowLogs);
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "chest", VariantChestsModule.class, this.getModBlock("oak_chest", VariantChestBlock.class), () -> WoodTypeRegistry.OAK_TYPE, w -> new CompatChestBlock((WoodType)w, this.shortenedId() + "/" + w.getAppendableId(), Utils.copyPropertySafe((Block)Blocks.f_50087_))).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(new ResourceLocation("forge:chests/wooden"), Registries.f_256747_)).addTag(new ResourceLocation("forge:chests/wooden"), Registries.f_256913_)).addTag(this.modRes("revertable_chests"), Registries.f_256913_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(new ResourceLocation("quark:revertable_chests"), Registries.f_256913_)).addTile(CompatChestBlockTile::new).excludeBlockTypes("twilightforest", new String[]{"dark"})).addRecipe(this.modRes("building/crafting/chests/oak_chest"))).build();
        this.addEntry(this.chests);
        this.trappedChests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "trapped_chest", VariantChestsModule.class, this.getModBlock("oak_trapped_chest", VariantTrappedChestBlock.class), () -> WoodTypeRegistry.OAK_TYPE, w -> {
            boolean isNamespaceLoaded;
            boolean bl = isNamespaceLoaded = w.getNamespace().equals("twilightforest") || w.getNamespace().equals("blue_skies");
            if (!this.chests.blocks.containsKey(w) && !isNamespaceLoaded) {
                return null;
            }
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new CompatTrappedChestBlock((WoodType)w, name, Utils.copyPropertySafe((Block)Blocks.f_50325_));
        }).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addTag(new ResourceLocation("forge:chests/trapped"), Registries.f_256747_)).addTag(new ResourceLocation("forge:chests/trapped"), Registries.f_256913_)).addTag(new ResourceLocation("forge:chests/wooden"), Registries.f_256913_)).addTag(new ResourceLocation("forge:chests/wooden"), Registries.f_256747_)).addTag(this.modRes("revertable_trapped_chests"), Registries.f_256913_)).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTile(CompatTrappedChestBlockTile::new).addRecipe(this.modRes("building/crafting/chests/oak_trapped_chest"))).build();
        this.addEntry(this.trappedChests);
        this.hedges = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(LeavesType.class, "hedge", HedgesModule.class, this.getModBlock("oak_hedge"), () -> LeavesTypeRegistry.OAK_TYPE, leavesType -> new HedgeBlock("", null, Blocks.f_50132_, leavesType.leaves)).addCondition(l -> l.getWoodType() != null)).addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", SpriteHelper.LOOKS_LIKE_LEAF_TEXTURE))).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("hedges"), Registries.f_256747_)).addTag(this.modRes("hedges"), Registries.f_256913_)).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).copyParentTint()).setRenderType(RenderLayer.CUTOUT_MIPPED).build();
        this.addEntry(this.hedges);
        this.leafCarpets = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(LeavesType.class, "leaf_carpet", LeafCarpetModule.class, this.getModBlock("oak_leaf_carpet"), () -> LeavesTypeRegistry.OAK_TYPE, leavesType -> {
            String name = this.shortenedId() + "/" + leavesType.getVariantId("%s_leaf_carpet");
            return new LeafCarpetBlock(name, leavesType.leaves, null);
        }).requiresChildren(new String[]{"leaves"})).addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", s -> !s.contains("/snow") && !s.contains("_snow")))).addTag(BlockTags.f_144281_, Registries.f_256747_)).addTag(new ResourceLocation("forge:mineable/sickle"), Registries.f_256747_)).addTag(new ResourceLocation("mynethersdelight:resurgent_soil_plant"), Registries.f_256747_)).setTabKey(tab)).setTabMode(TabAddMode.AFTER_SAME_WOOD)).addRecipe(this.modRes("building/crafting/oak_leaf_carpet"))).setRenderType(RenderLayer.CUTOUT_MIPPED).copyParentTint()).build();
        this.addEntry(this.leafCarpets);
    }

    @Override
    public void onModSetup() {
        this.posts.blocks.forEach((w, post) -> {
            Block stripped = (Block)this.strippedPosts.blocks.get(w);
            if (stripped != null) {
                ECPlatformStuff.registerStripping(post, stripped);
            }
        });
        this.leafCarpets.blocks.forEach((w, leaf) -> ComposterBlock.f_51914_.put(leaf, 0.2f));
    }

    @Override
    public void registerTiles(Registrator<BlockEntityType<?>> registry) {
        super.registerTiles(registry);
        CHEST_TILE = this.chests.getTile(ChestBlockEntity.class);
        TRAPPED_CHEST_TILE = this.trappedChests.getTile(ChestBlockEntity.class);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientSetup() {
        super.onClientSetup();
        QuarkClientModule.initClient(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        event.register(CHEST_TILE, context -> new VariantChestRenderer(context, false));
        event.register(TRAPPED_CHEST_TILE, context -> new VariantChestRenderer(context, true));
    }

    private Pair<List<Palette>, McMetaFile> bookshelfPalette(BlockType w, ResourceManager m) {
        Pair pair;
        block8: {
            TextureImage plankTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)m, (Block)((WoodType)w).planks));
            try {
                List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                targetPalette.forEach(p -> {
                    PaletteColor l0 = p.getDarkest();
                    p.increaseDown();
                    p.increaseDown();
                    p.increaseDown();
                    p.increaseDown();
                    p.remove(l0);
                });
                pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMcMeta());
                if (plankTexture == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (plankTexture != null) {
                        try {
                            plankTexture.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                }
            }
            plankTexture.close();
        }
        return pair;
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept(this::generateChestTextures);
    }

    private void generateChestTextures(ResourceManager manager, ResourceSink handler) {
        try (TextureImage normal = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("quark_variant_chests/oak/normal"));
             TextureImage normal_m = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("model/oak_chest_normal_m"));
             TextureImage normal_o = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("model/oak_chest_normal_o"));
             TextureImage left = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("quark_variant_chests/oak/left"));
             TextureImage left_m = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("model/oak_chest_left_m"));
             TextureImage left_o = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("model/oak_chest_left_o"));
             TextureImage right = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("quark_variant_chests/oak/right"));
             TextureImage right_m = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("model/oak_chest_right_m"));
             TextureImage right_o = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("model/oak_chest_right_o"));
             TextureImage left_t = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("model/trapped_chest_left"));
             TextureImage right_t = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("model/trapped_chest_right"));
             TextureImage normal_t = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("model/trapped_chest_normal"));){
            Respriter respriterNormal = Respriter.masked((TextureImage)normal, (TextureImage)normal_m);
            Respriter respriterLeft = Respriter.masked((TextureImage)left, (TextureImage)left_m);
            Respriter respriterRight = Respriter.masked((TextureImage)right, (TextureImage)right_m);
            Respriter respriterNormalO = Respriter.of((TextureImage)normal_o);
            Respriter respriterLeftO = Respriter.of((TextureImage)left_o);
            Respriter respriterRightO = Respriter.of((TextureImage)right_o);
            this.trappedChests.blocks.forEach((wood, block) -> {
                CompatTrappedChestBlock b = (CompatTrappedChestBlock)((Object)block);
                try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                    ResourceLocation trappedRes;
                    List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    McMetaFile meta = plankTexture.getMcMeta();
                    ArrayList<Palette> overlayPalette = new ArrayList<Palette>();
                    for (Palette p : targetPalette) {
                        PaletteColor d1 = p.getDarkest();
                        p.remove(d1);
                        PaletteColor d2 = p.getDarkest();
                        p.remove(d2);
                        HCLColor n1 = new HCLColor(d1.hcl().hue(), d1.hcl().chroma() * 0.75f, d1.hcl().luminance() * 0.4f, d1.hcl().alpha());
                        HCLColor n2 = new HCLColor(d2.hcl().hue(), d2.hcl().chroma() * 0.75f, d2.hcl().luminance() * 0.6f, d2.hcl().alpha());
                        Palette pal = Palette.ofColors(List.of(n1, n2));
                        overlayPalette.add(pal);
                    }
                    ResourceLocation res = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/normal");
                    if (!handler.alreadyHasTextureAtLocation(manager, res)) {
                        trappedRes = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/trap");
                        this.createChestTextures(handler, normal_t, respriterNormal, respriterNormalO, meta, targetPalette, (List<Palette>)overlayPalette, res, trappedRes, (WoodType)wood);
                    }
                    if (!handler.alreadyHasTextureAtLocation(manager, res = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/left"))) {
                        trappedRes = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/trap_left");
                        this.createChestTextures(handler, left_t, respriterLeft, respriterLeftO, meta, targetPalette, (List<Palette>)overlayPalette, res, trappedRes, (WoodType)wood);
                    }
                    if (!handler.alreadyHasTextureAtLocation(manager, res = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/right"))) {
                        trappedRes = this.modRes(b.getTextureFolder() + "/" + b.getTexturePath() + "/trap_right");
                        this.createChestTextures(handler, right_t, respriterRight, respriterRightO, meta, targetPalette, (List<Palette>)overlayPalette, res, trappedRes, (WoodType)wood);
                    }
                }
                catch (Exception ex) {
                    EveryCompat.LOGGER.error("Failed to generate Chest block texture for for {} : {}", (Object)b, (Object)ex);
                }
            });
        }
        catch (Exception ex) {
            EveryCompat.LOGGER.error("Could not generate any Chest block texture : ", (Throwable)ex);
        }
    }

    private void createChestTextures(ResourceSink handler, TextureImage trappedOverlay, Respriter respriterLeft, Respriter respriterLeftO, McMetaFile baseMeta, List<Palette> basePalette, List<Palette> overlayPalette, ResourceLocation res, ResourceLocation trappedRes, WoodType wood) {
        TextureImage recoloredBase = respriterLeft.recolorWithAnimation(basePalette, baseMeta);
        TextureImage recoloredOverlay = respriterLeftO.recolorWithAnimation(overlayPalette, baseMeta);
        recoloredBase.applyOverlay(new TextureImage[]{recoloredOverlay});
        TextureImage trapped = recoloredBase.makeCopy();
        if (!wood.getNamespace().equals("blue_skies") || wood.getNamespace().equals("blue_skies") && wood.getTypeName().equals("crystallized")) {
            handler.addAndCloseTexture(res, recoloredBase);
        }
        trapped.applyOverlay(new TextureImage[]{trappedOverlay.makeCopy()});
        handler.addAndCloseTexture(trappedRes, trapped);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, handler) -> {
            if (PlatHelper.isModLoaded((String)"botanypots")) {
                this.hedges.items.forEach((leaves, item) -> {
                    Item leavesItem = leaves.leaves.m_5456_();
                    BotanyPotsHelper.cropQuarkHedgeRecipe(this, item, leavesItem, handler, manager, leaves);
                });
            }
            for (Map.Entry entry : this.hedges.blocks.entrySet()) {
                LeavesType leavesType = (LeavesType)entry.getKey();
                Block block = (Block)entry.getValue();
                if (block == null) continue;
                if (!leavesType.getNamespace().equals("fruitfulfun")) {
                    this.generalHedgeRecipe(leavesType, block, handler, manager);
                }
                if (!leavesType.getNamespace().equals("fruitfulfun")) continue;
                switch (leavesType.getTypeName()) {
                    case "apple": {
                        this.specialHedgeRecipe("minecraft:oak", leavesType, block, handler, manager);
                        break;
                    }
                    case "grapefruit": 
                    case "lemon": 
                    case "tangerine": 
                    case "lime": 
                    case "citron": 
                    case "pomelo": 
                    case "orange": {
                        this.specialHedgeRecipe("fruitfulfun:citrus", leavesType, block, handler, manager);
                        break;
                    }
                    case "pomegranate": {
                        this.specialHedgeRecipe("minecraft:jungle", leavesType, block, handler, manager);
                        break;
                    }
                    case "redlove": {
                        this.specialHedgeRecipe("fruitfulfun:redlove", leavesType, block, handler, manager);
                    }
                }
            }
        });
    }

    public void generalHedgeRecipe(LeavesType leavesType, Block block, ResourceSink handler, ResourceManager manager) {
        ResourceLocation recipeLoc = this.modRes("recipes/building/crafting/oak_hedge.json");
        WoodType woodType = leavesType.getWoodType();
        try (InputStream recipeStream = ((Resource)manager.m_213713_(recipeLoc).orElseThrow(() -> new FileNotFoundException("Failed to open recipe @ " + String.valueOf(recipeLoc)))).m_215507_();){
            JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            JsonObject underKey = recipe.getAsJsonObject("key");
            JsonObject underResult = recipe.getAsJsonObject("result");
            underKey.getAsJsonObject("L").addProperty("item", Utils.getID((Block)leavesType.leaves).toString());
            underKey.getAsJsonObject("W").addProperty("tag", TagUtility.getATagOrCreateANew("logs", "caps", (BlockType)woodType, handler, manager).toString());
            underResult.addProperty("item", Utils.getID((Block)block).toString());
            String path = this.shortenedId() + "/" + leavesType.getNamespace() + "/";
            handler.addJson(EveryCompat.res(path + leavesType.getTypeName() + "_hedge"), (JsonElement)recipe, ResType.RECIPES);
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("Failed to open the recipe file @ {} : {}", (Object)recipeLoc, (Object)e);
        }
    }

    public void specialHedgeRecipe(String reslocWood, LeavesType leavesType, Block block, ResourceSink handler, ResourceManager manager) {
        ResourceLocation recipeLoc = this.modRes("recipes/building/crafting/oak_hedge.json");
        try (InputStream recipeStream = ((Resource)manager.m_213713_(recipeLoc).orElseThrow(() -> new FileNotFoundException("Failed to open recipe @ " + String.valueOf(recipeLoc)))).m_215507_();){
            JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            JsonObject underKey = recipe.getAsJsonObject("key");
            JsonObject underResult = recipe.getAsJsonObject("result");
            WoodType woodType = leavesType.getWoodType();
            underKey.getAsJsonObject("L").addProperty("item", Utils.getID((Block)leavesType.leaves).toString());
            underKey.getAsJsonObject("W").addProperty("tag", QuarkModule.whichSpecialTags("logs", woodType, reslocWood, handler, manager).toString());
            underResult.addProperty("item", Utils.getID((Block)block).toString());
            ResourceLocation newLoc = EveryCompat.res(this.shortenedId() + "/" + leavesType.getAppendableId() + "_hedge");
            handler.addJson(newLoc, (JsonElement)recipe, ResType.RECIPES);
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("Failed to open the recipe file: {} : {}", (Object)recipeLoc, (Object)e);
        }
    }

    public static ResourceLocation whichSpecialTags(String suffixTag, WoodType woodType, String wood, ResourceSink handler, ResourceManager manager) {
        ResourceLocation RLocLogsTag = new ResourceLocation(wood + "_" + suffixTag);
        ResourceLocation RLocECTag = EveryCompat.res(woodType.getAppendableId() + "_" + suffixTag);
        if (manager.m_213713_(ResType.TAGS.getPath(RLocLogsTag.m_246208_("blocks/"))).isPresent()) {
            return RLocLogsTag;
        }
        if (manager.m_213713_(ResType.TAGS.getPath(RLocECTag.m_246208_("blocks/"))).isPresent()) {
            return RLocECTag;
        }
        TagUtility.createAndAddDefaultTags(RLocECTag, handler, (BlockType)woodType, new Block[0]);
        return RLocECTag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class QuarkClientModule {
        private static void initClient(QuarkModule module) {
            for (VariantChestBlock b : module.chests.blocks.values()) {
                QuarkClient.ZETA_CLIENT.setBlockEntityWithoutLevelRenderer(b.m_5456_(), (BlockEntityWithoutLevelRenderer)new SimpleWithoutLevelRenderer(CHEST_TILE, b.m_49966_()));
            }
            for (VariantChestBlock b : module.trappedChests.blocks.values()) {
                QuarkClient.ZETA_CLIENT.setBlockEntityWithoutLevelRenderer(b.m_5456_(), (BlockEntityWithoutLevelRenderer)new SimpleWithoutLevelRenderer(TRAPPED_CHEST_TILE, b.m_49966_()));
            }
        }
    }
}

