/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.dynamicpack;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.Logger;

public class ServerDynamicResourcesHandler
extends DynServerResourcesGenerator {
    public static final ServerDynamicResourcesHandler INSTANCE = new ServerDynamicResourcesHandler();

    public ServerDynamicResourcesHandler() {
        super(new DynamicDataPack(EveryCompat.res("generated_pack")));
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"minecraft"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"forge"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"everycomp"});
        if (PlatHelper.isModLoaded((String)"lolmcv")) {
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"lieonstudio"});
        }
    }

    public Logger getLogger() {
        return EveryCompat.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return ECConfigs.SPEC == null || ECConfigs.DEPEND_ON_PACKS.get() != false;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        ArrayList tasks = new ArrayList();
        EveryCompat.forAllModules(m -> m.addDynamicServerResources(tasks::add));
        int batchSize = Math.max(10, tasks.size() / Runtime.getRuntime().availableProcessors());
        EveryCompat.LOGGER.info("Dynamic server resources generation tasks: {} in batches of: {}", (Object)tasks.size(), (Object)batchSize);
        for (int i = 0; i < tasks.size(); i += batchSize) {
            int end = Math.min(i + batchSize, tasks.size());
            List subList = tasks.subList(i, end);
            executor.accept((resourceManager, resourceSink) -> {
                for (ResourceGenTask task : subList) {
                    task.accept(resourceManager, resourceSink);
                }
            });
        }
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        if (!ECConfigs.GENERATE_DYNAMIC_SERVER.get().booleanValue()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ((DynamicDataPack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || ECConfigs.DEBUG_RESOURCES.get() != false);
        super.regenerateDynamicAssets(manager);
        EveryCompat.LOGGER.info("Dynamic server assets generation took: {}", (Object)stopwatch.stop().toString());
    }

    public void addModToDynamicPack(String modId) {
        if (PlatHelper.isModLoaded((String)modId)) {
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{modId});
        }
    }
}

