/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.renderer.AstemirRenderDispatcher;
import ru.astemir.astemirlib.client.event.EntityRenderEvent;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class MixinEntityRenderDispatcher
implements AstemirRenderDispatcher {
    @Shadow
    @Final
    public Options f_114360_;
    @Shadow
    private boolean f_114368_;
    @Shadow
    private Level f_114366_;
    @Shadow
    private boolean f_114369_;
    @Shadow
    @Final
    private static RenderType f_114361_;

    @Shadow
    public abstract <T extends Entity> EntityRenderer<? super T> m_114382_(T var1);

    @Shadow
    protected abstract void m_114453_(PoseStack var1, MultiBufferSource var2, Entity var3);

    @Shadow
    public abstract double m_114378_(double var1, double var3, double var5);

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public <E extends Entity> void onRenderEntity(E entity, double x, double y, double z, float yRot, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, CallbackInfo ci) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityRenderEvent(entity, x, y, z, partialTick, poseStack, bufferSource)) || entity instanceof Animated) {
            ci.cancel();
        }
    }

    @Override
    public <E extends Entity> void _renderUnsafe(E entity, double x, double y, double z, float yRot, float partialTick, PoseStack poseStack, MultiBufferSource p_114392_, int p_114393_) {
        EntityRenderer<E> entityrenderer = this.m_114382_(entity);
        try {
            double d1;
            float f;
            Vec3 vec3 = entityrenderer.m_7860_(entity, partialTick);
            double d2 = x + vec3.m_7096_();
            double d3 = y + vec3.m_7098_();
            double d0 = z + vec3.m_7094_();
            poseStack.m_85836_();
            poseStack.m_85837_(d2, d3, d0);
            entityrenderer.m_7392_(entity, yRot, partialTick, poseStack, p_114392_, p_114393_);
            if (entity.m_6051_()) {
                this.m_114453_(poseStack, p_114392_, entity);
            }
            poseStack.m_85837_(-vec3.m_7096_(), -vec3.m_7098_(), -vec3.m_7094_());
            float shadowRadius = entityrenderer.f_114477_;
            float shadowStrength = entityrenderer.f_114478_;
            if (((Boolean)this.f_114360_.m_231818_().m_231551_()).booleanValue() && this.f_114368_ && shadowRadius > 0.0f && !entity.m_20145_() && (f = (float)((1.0 - (d1 = this.m_114378_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())) / 256.0) * (double)shadowStrength)) > 0.0f) {
                MixinEntityRenderDispatcher._renderShadow(poseStack, p_114392_, entity, f, partialTick, (LevelReader)this.f_114366_, Math.min(shadowRadius, 32.0f));
            }
            if (this.f_114369_ && !entity.m_20145_() && !Minecraft.m_91087_().m_91299_()) {
                MixinEntityRenderDispatcher._renderHitbox(poseStack, p_114392_.m_6299_(RenderType.m_110504_()), entity, partialTick);
            }
            poseStack.m_85849_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
            entity.m_7976_(crashreportcategory);
            CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
            crashreportcategory1.m_128159_("Assigned renderer", entityrenderer);
            crashreportcategory1.m_128159_("Location", (Object)CrashReportCategory.m_178937_((LevelHeightAccessor)this.f_114366_, (double)x, (double)y, (double)z));
            crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yRot));
            crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTick));
            throw new ReportedException(crashreport);
        }
    }

    private static void _renderHitbox(PoseStack poseStack, VertexConsumer vertexConsumer, Entity entity, float partialTick) {
        AABB aabb = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (entity.isMultipartEntity()) {
            double d0 = -Mth.m_14139_((double)partialTick, (double)entity.f_19790_, (double)entity.m_20185_());
            double d1 = -Mth.m_14139_((double)partialTick, (double)entity.f_19791_, (double)entity.m_20186_());
            double d2 = -Mth.m_14139_((double)partialTick, (double)entity.f_19792_, (double)entity.m_20189_());
            for (PartEntity enderdragonpart : entity.getParts()) {
                poseStack.m_85836_();
                double d3 = d0 + Mth.m_14139_((double)partialTick, (double)enderdragonpart.f_19790_, (double)enderdragonpart.m_20185_());
                double d4 = d1 + Mth.m_14139_((double)partialTick, (double)enderdragonpart.f_19791_, (double)enderdragonpart.m_20186_());
                double d5 = d2 + Mth.m_14139_((double)partialTick, (double)enderdragonpart.f_19792_, (double)enderdragonpart.m_20189_());
                poseStack.m_85837_(d3, d4, d5);
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)enderdragonpart.m_20191_().m_82386_(-enderdragonpart.m_20185_(), -enderdragonpart.m_20186_(), -enderdragonpart.m_20189_()), (float)0.25f, (float)1.0f, (float)0.0f, (float)1.0f);
                poseStack.m_85849_();
            }
        }
        if (entity instanceof LivingEntity) {
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)aabb.f_82288_, (double)(entity.m_20192_() - 0.01f), (double)aabb.f_82290_, (double)aabb.f_82291_, (double)(entity.m_20192_() + 0.01f), (double)aabb.f_82293_, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        Vec3 vec3 = entity.m_20252_(partialTick);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, entity.m_20192_(), 0.0f).m_6122_(0, 0, 255, 255).m_252939_(matrix3f, (float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)(vec3.f_82479_ * 2.0), (float)((double)entity.m_20192_() + vec3.f_82480_ * 2.0), (float)(vec3.f_82481_ * 2.0)).m_6122_(0, 0, 255, 255).m_252939_(matrix3f, (float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_).m_5752_();
    }

    private static void _renderShadow(PoseStack poseStack, MultiBufferSource bufferSource, Entity entity, float shadowStrength, float partialTick, LevelReader levelReader, float shadowRadius) {
        Mob mob;
        float f = shadowRadius;
        if (entity instanceof Mob && (mob = (Mob)entity).m_6162_()) {
            f = shadowRadius * 0.5f;
        }
        double x = Mth.m_14139_((double)partialTick, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)partialTick, (double)entity.f_19791_, (double)entity.m_20186_());
        double z = Mth.m_14139_((double)partialTick, (double)entity.f_19792_, (double)entity.m_20189_());
        float f1 = Math.min(shadowStrength / 0.5f, f);
        int i = Mth.m_14107_((double)(x - (double)f));
        int j = Mth.m_14107_((double)(x + (double)f));
        int k = Mth.m_14107_((double)(y - (double)f1));
        int l = Mth.m_14107_((double)y);
        int i1 = Mth.m_14107_((double)(z - (double)f));
        int j1 = Mth.m_14107_((double)(z + (double)f));
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(f_114361_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i1; k1 <= j1; ++k1) {
            for (int l1 = i; l1 <= j; ++l1) {
                blockpos$mutableblockpos.m_122178_(l1, 0, k1);
                ChunkAccess chunkaccess = levelReader.m_46865_((BlockPos)blockpos$mutableblockpos);
                for (int i2 = k; i2 <= l; ++i2) {
                    blockpos$mutableblockpos.m_142448_(i2);
                    float f2 = shadowStrength - (float)(y - (double)blockpos$mutableblockpos.m_123342_()) * 0.5f;
                    MixinEntityRenderDispatcher._renderBlockShadow(posestack$pose, vertexconsumer, chunkaccess, levelReader, (BlockPos)blockpos$mutableblockpos, x, y, z, f, f2);
                }
            }
        }
    }

    private static void _renderBlockShadow(PoseStack.Pose pose, VertexConsumer vertexConsumer, ChunkAccess chunkAccess, LevelReader levelReader, BlockPos blockPos, double p_277682_, double p_278099_, double p_277806_, float p_277844_, float p_277496_) {
        float f;
        float f1;
        VoxelShape voxelshape;
        BlockPos blockpos = blockPos.m_7495_();
        BlockState blockstate = chunkAccess.m_8055_(blockpos);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE && levelReader.m_46803_(blockPos) > 3 && blockstate.m_60838_((BlockGetter)chunkAccess, blockpos) && !(voxelshape = blockstate.m_60808_((BlockGetter)chunkAccess, blockpos)).m_83281_() && (f1 = p_277496_ * 0.5f * (f = LightTexture.m_234316_((DimensionType)levelReader.m_6042_(), (int)levelReader.m_46803_(blockPos)))) >= 0.0f) {
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            AABB aabb = voxelshape.m_83215_();
            double d0 = (double)blockPos.m_123341_() + aabb.f_82288_;
            double d1 = (double)blockPos.m_123341_() + aabb.f_82291_;
            double d2 = (double)blockPos.m_123342_() + aabb.f_82289_;
            double d3 = (double)blockPos.m_123343_() + aabb.f_82290_;
            double d4 = (double)blockPos.m_123343_() + aabb.f_82293_;
            float f2 = (float)(d0 - p_277682_);
            float f3 = (float)(d1 - p_277682_);
            float f4 = (float)(d2 - p_278099_);
            float f5 = (float)(d3 - p_277806_);
            float f6 = (float)(d4 - p_277806_);
            float f7 = -f2 / 2.0f / p_277844_ + 0.5f;
            float f8 = -f3 / 2.0f / p_277844_ + 0.5f;
            float f9 = -f5 / 2.0f / p_277844_ + 0.5f;
            float f10 = -f6 / 2.0f / p_277844_ + 0.5f;
            MixinEntityRenderDispatcher._shadowVertex(pose, vertexConsumer, f1, f2, f4, f5, f7, f9);
            MixinEntityRenderDispatcher._shadowVertex(pose, vertexConsumer, f1, f2, f4, f6, f7, f10);
            MixinEntityRenderDispatcher._shadowVertex(pose, vertexConsumer, f1, f3, f4, f6, f8, f10);
            MixinEntityRenderDispatcher._shadowVertex(pose, vertexConsumer, f1, f3, f4, f5, f8, f9);
        }
    }

    private static void _shadowVertex(PoseStack.Pose p_114423_, VertexConsumer p_114424_, float p_114425_, float p_114426_, float p_114427_, float p_114428_, float p_114429_, float p_114430_) {
        Vector3f vector3f = p_114423_.m_252922_().transformPosition(p_114426_, p_114427_, p_114428_, new Vector3f());
        p_114424_.m_5954_(vector3f.x(), vector3f.y(), vector3f.z(), 1.0f, 1.0f, 1.0f, p_114425_, p_114429_, p_114430_, OverlayTexture.f_118083_, 0xF000F0, 0.0f, 1.0f, 0.0f);
    }
}

