/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.network.messages;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import ru.astemir.astemirlib.common.handler.LevelEventHandler;
import ru.astemir.astemirlib.common.network.PacketArgument;

public class ServerMessageWorldPosEvent {
    private BlockPos pos;
    private int eventId;
    private PacketArgument[] arguments;

    public ServerMessageWorldPosEvent(BlockPos pos, int eventId, PacketArgument ... arguments) {
        this.pos = pos;
        this.eventId = eventId;
        this.arguments = arguments;
    }

    public static void encode(ServerMessageWorldPosEvent message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeInt(message.eventId);
        buf.writeInt(message.arguments.length);
        for (PacketArgument argument : message.arguments) {
            argument.write(buf);
        }
    }

    public static ServerMessageWorldPosEvent decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int eventId = buf.readInt();
        int length = buf.readInt();
        PacketArgument[] arguments = new PacketArgument[length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PacketArgument.read(buf);
        }
        ServerMessageWorldPosEvent message = new ServerMessageWorldPosEvent(pos, eventId, arguments);
        return message;
    }

    public static class Handler
    implements BiConsumer<ServerMessageWorldPosEvent, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(ServerMessageWorldPosEvent message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            LogicalSide side = context.getDirection().getReceptionSide();
            context.setPacketHandled(true);
            if (!side.isServer()) {
                return;
            }
            ServerPlayer playerEntity = context.getSender();
            if (playerEntity == null) {
                return;
            }
            context.enqueueWork(() -> Handler.processMessage(message, playerEntity));
        }

        private static void processMessage(ServerMessageWorldPosEvent message, ServerPlayer playerEntity) {
            Level level;
            if (playerEntity != null && (level = playerEntity.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LevelEventHandler.getInstance().onServerHandleEvent(serverLevel, message.pos, message.eventId, message.arguments);
            }
        }
    }
}

