/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.network.messages;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import ru.astemir.astemirlib.common.action.ActionController;
import ru.astemir.astemirlib.common.action.ActionListener;
import ru.astemir.astemirlib.common.action.ActionStateMachine;
import ru.astemir.astemirlib.common.action.HolderKey;

public class ServerMessageActionSync {
    private HolderKey holderKey;

    public ServerMessageActionSync(HolderKey key) {
        this.holderKey = key;
    }

    public static void encode(ServerMessageActionSync message, FriendlyByteBuf buf) {
        message.holderKey.write(buf);
    }

    public static ServerMessageActionSync decode(FriendlyByteBuf buf) {
        return new ServerMessageActionSync(HolderKey.read(buf));
    }

    public static class Handler
    implements BiConsumer<ServerMessageActionSync, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(ServerMessageActionSync message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            LogicalSide side = context.getDirection().getReceptionSide();
            context.setPacketHandled(true);
            if (!side.isServer()) {
                return;
            }
            ServerPlayer playerEntity = context.getSender();
            if (playerEntity == null) {
                return;
            }
            context.enqueueWork(() -> Handler.processMessage(message, playerEntity));
        }

        private static void processMessage(ServerMessageActionSync message, ServerPlayer playerEntity) {
            if (playerEntity != null) {
                ActionStateMachine machine = null;
                switch (message.holderKey.getTarget()) {
                    case ENTITY: {
                        for (Entity entity : playerEntity.m_9236_().m_45933_((Entity)playerEntity, playerEntity.m_20191_().m_82377_(100.0, 100.0, 100.0))) {
                            ActionListener actionListener;
                            if (!(entity instanceof ActionListener) || !((Entity)(actionListener = (ActionListener)entity)).m_20148_().equals(message.holderKey.getId())) continue;
                            machine = actionListener.getActionStateMachine();
                        }
                        break;
                    }
                    case BLOCK: {
                        BlockEntity blockEntity = playerEntity.m_9236_().m_7702_(message.holderKey.getPos());
                        if (!(blockEntity instanceof ActionListener)) break;
                        machine = ((ActionListener)blockEntity).getActionStateMachine();
                    }
                }
                if (machine != null) {
                    for (ActionController controller : machine.getControllers()) {
                        controller.sendUpdatePacket(playerEntity);
                    }
                }
            }
        }
    }
}

