/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.network.messages;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import ru.astemir.astemirlib.common.action.ActionController;
import ru.astemir.astemirlib.common.action.ActionListener;
import ru.astemir.astemirlib.common.action.HolderKey;
import ru.astemir.astemirlib.common.action.HolderTarget;

public class ClientMessageActionController {
    private HolderKey holderKey;
    private int controllerId;
    private int stateId;
    private int ticks;

    public ClientMessageActionController(HolderKey holderKey, int controllerId, int stateId, int ticks) {
        this.holderKey = holderKey;
        this.controllerId = controllerId;
        this.stateId = stateId;
        this.ticks = ticks;
    }

    public static void encode(ClientMessageActionController message, FriendlyByteBuf buf) {
        message.holderKey.write(buf);
        buf.writeInt(message.controllerId);
        buf.writeInt(message.stateId);
        buf.writeInt(message.ticks);
    }

    public static ClientMessageActionController decode(FriendlyByteBuf buf) {
        return new ClientMessageActionController(HolderKey.read(buf), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static class Handler
    implements BiConsumer<ClientMessageActionController, Supplier<NetworkEvent.Context>> {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void accept(ClientMessageActionController message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                BlockEntity block;
                Minecraft minecraft = Minecraft.m_91087_();
                if (message.holderKey.getTarget() == HolderTarget.ENTITY) {
                    Entity entity = minecraft.f_91073_.m_6815_(message.holderKey.getId());
                    if (entity != null && entity instanceof ActionListener) {
                        ActionController controller = ((ActionListener)entity).getActionStateMachine().getControllers().get(message.controllerId);
                        controller.setActionWithoutSync(controller.getActionById(message.stateId), message.ticks);
                    }
                } else if (message.holderKey.getTarget() == HolderTarget.BLOCK && (block = minecraft.f_91073_.m_7702_(message.holderKey.getPos())) != null && block instanceof ActionListener) {
                    ActionController controller = ((ActionListener)block).getActionStateMachine().getControllers().get(message.controllerId);
                    controller.setActionWithoutSync(controller.getActionById(message.stateId), message.ticks);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

