/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.misc;

import java.util.LinkedList;
import ru.astemir.astemirlib.common.misc.KeyFrame;

public class KeyedTimeline<T> {
    private KeyFrame<T>[] frames;

    public KeyedTimeline(KeyFrame<T> ... frames) {
        this.frames = frames;
    }

    public KeyedTimeline extended(float newLength) {
        LinkedList<KeyFrame<T>> newFrames = new LinkedList<KeyFrame<T>>();
        double length = this.getLength();
        if (length == 0.0) {
            return this;
        }
        int multiplication = (int)(1.0 / (length / (double)newLength));
        double lastLength = 0.0;
        for (int i = 0; i < multiplication; ++i) {
            for (int j = 0; j < this.frames.length; ++j) {
                KeyFrame<T> frame = this.frames[j];
                if ((double)frame.getTime() == 0.0 && i > 0) continue;
                float time = (float)((double)frame.getTime() + lastLength);
                if (j == this.frames.length - 1) {
                    lastLength = time;
                }
                if (!(time < newLength)) continue;
                newFrames.add(new KeyFrame<T>(time, frame.getValue(), frame.getInterpolationType(), frame.getEasingType()));
            }
        }
        return new KeyedTimeline<T>(newFrames.toArray(new KeyFrame[this.frames.length]));
    }

    public KeyedTimeline narrowed(float newLength) {
        LinkedList<KeyFrame<T>> newFrames = new LinkedList<KeyFrame<T>>();
        for (KeyFrame<T> frame : this.frames) {
            if (!(frame.getTime() <= newLength)) continue;
            newFrames.add(frame);
        }
        return new KeyedTimeline<T>(newFrames.toArray(new KeyFrame[this.frames.length]));
    }

    public T getInterpolated(double time, boolean rotation) {
        if (this.frames.length == 0) {
            return null;
        }
        KeyFrame<T> first = this.frames[0];
        KeyFrame<T> last = this.frames[this.frames.length - 1];
        if (time <= (double)first.getTime()) {
            return first.getValue();
        }
        if (time >= (double)last.getTime()) {
            return last.getValue();
        }
        int startIndex = 0;
        int endIndex = this.frames.length - 1;
        while (startIndex < endIndex) {
            int middleIndex = startIndex + (endIndex - startIndex) / 2;
            if (time < (double)this.frames[middleIndex].getTime()) {
                endIndex = middleIndex;
                continue;
            }
            startIndex = middleIndex + 1;
        }
        KeyFrame<T> startFrame = this.frames[startIndex - 1];
        KeyFrame<T> endFrame = this.frames[startIndex];
        float newTime = (float)((time - (double)startFrame.getTime()) / (double)(endFrame.getTime() - startFrame.getTime()));
        if (rotation) {
            return endFrame.getInterpolationType().interpolateRotUniversal(startFrame.getValue(), endFrame.getValue(), endFrame.getEasingType().ease(newTime));
        }
        return endFrame.getInterpolationType().interpolateUniversal(startFrame.getValue(), endFrame.getValue(), endFrame.getEasingType().ease(newTime));
    }

    public void setFrames(KeyFrame<T>[] frames) {
        this.frames = frames;
    }

    public void setFrame(int index, KeyFrame<T> frame) {
        this.frames[index] = frame;
    }

    public KeyFrame<T>[] getFrames() {
        return this.frames;
    }

    public KeyFrame<T> getLastFrame() {
        return this.frames[this.frames.length - 1];
    }

    public KeyFrame<T> getFirstFrame() {
        return this.frames[0];
    }

    public float getLength() {
        if (this.frames.length > 0) {
            return this.frames[this.frames.length - 1].getTime();
        }
        return 0.0f;
    }

    public boolean isEmpty() {
        return this.frames.length == 0;
    }
}

