/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.math;

import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;

public class Color {
    private static final String HEX_PREFIX = "#";
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Color DARK_GREEN = new Color(0.5f, 0.0f, 0.0f, 0.5f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color DARK_BLUE = new Color(0.0f, 0.0f, 0.5f, 1.0f);
    public static final Color YELLOW = new Color(1.0f, 1.0f, 0.0f, 1.0f);
    public static final Color GOLD = new Color(1.0f, 0.823529f, 0.0392156f, 1.0f);
    public static final Color ORANGE = new Color(1.0f, 0.5f, 0.0f, 1.0f);
    public static final Color AQUA = new Color(0.0f, 1.0f, 1.0f, 1.0f);
    public static final Color CYAN = new Color(0.0f, 0.5f, 0.5f, 1.0f);
    public static final Color PURPLE = new Color(1.0f, 0.0f, 1.0f, 1.0f);
    public static final Color PINK = new Color(1.0f, 0.5f, 1.0f, 1.0f);
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color MAGENTA = new Color(1.0f, 0.0f, 0.78431374f, 1.0f);
    public static final Color LIGHT_GREEN = new Color(0.5176471f, 1.0f, 0.0f, 1.0f);
    public final float r;
    public final float g;
    public final float b;
    public final float a;

    public Color(int r, int g, int b) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = 1.0f;
    }

    public Color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color(int rgba) {
        this((float)(rgba >> 16 & 0xFF) / 255.0f, (float)(rgba >> 8 & 0xFF) / 255.0f, (float)(rgba & 0xFF) / 255.0f, (float)(rgba >> 24 & 0xFF) / 255.0f);
    }

    public int rgb() {
        return ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.b * 255.0f) & 0xFF;
    }

    public int rgba() {
        return ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.b * 255.0f) & 0xFF;
    }

    public Color interpolate(Color color, InterpolationType interpolationType, float t) {
        return new Color((float)interpolationType.interpolate(this.r, color.r, (double)t), (float)interpolationType.interpolate(this.g, color.g, (double)t), (float)interpolationType.interpolate(this.b, color.b, (double)t), (float)interpolationType.interpolate(this.a, color.a, (double)t));
    }

    public int[] toArray() {
        int[] colors = new int[]{(int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f), (int)(this.a * 255.0f)};
        return colors;
    }

    public HSV getHSV() {
        float[] floats = new float[3];
        java.awt.Color.RGBtoHSB((int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f), floats);
        return new HSV(floats[0], floats[1], floats[2]);
    }

    public HSV toHSV() {
        float hue;
        int cmin;
        int cmax;
        int r = (int)(this.r * 255.0f);
        int g = (int)(this.g * 255.0f);
        int b = (int)(this.b * 255.0f);
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new HSV(hue, saturation, brightness);
    }

    public Color red(Color color, float r) {
        return new Color(r, this.g, this.b, this.a);
    }

    public Color green(Color color, float g) {
        return new Color(this.r, g, this.b, this.a);
    }

    public Color blue(Color color, float b) {
        return new Color(this.r, this.g, b, this.a);
    }

    public Color alpha(float a) {
        return new Color(this.r, this.g, this.b, a);
    }

    public AVector3f toVector3f() {
        return new AVector3f(this.r, this.g, this.b);
    }

    public Vec3 toVec3() {
        return new Vec3((double)this.r, (double)this.g, (double)this.b);
    }

    public boolean equalsApprox(Color color, float t) {
        return MathUtils.equalsApprox(this.r, color.r, t) && MathUtils.equalsApprox(this.g, color.g, t) && MathUtils.equalsApprox(this.b, color.b, t) && MathUtils.equalsApprox(this.a, color.a, t);
    }

    public static Color fromArray(float[] array) {
        return new Color(array[0], array[1], array[2], array[3]);
    }

    public static Color fromArray(int[] array) {
        return Color.fromRGBA(array[0], array[1], array[2], array[3]);
    }

    public static Color fromRGBA(int r, int g, int b, int a) {
        return new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    private static Color fromHSV(HSV hsv) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (hsv.s == 0.0f) {
            g = b = (int)(hsv.v * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hsv.h - (float)Math.floor(hsv.h)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = hsv.v * (1.0f - hsv.s);
            float q = hsv.v * (1.0f - hsv.s * f);
            float t = hsv.v * (1.0f - hsv.s * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(hsv.v * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(hsv.v * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(hsv.v * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(hsv.v * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(hsv.v * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(hsv.v * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new Color(0xFF000000 | r << 16 | g << 8 | b << 0);
    }

    public static Color fromHexString(String string) {
        if (string.startsWith(HEX_PREFIX)) {
            try {
                int hex = Integer.parseInt(string.substring(1), 16);
                return new Color(hex).alpha(1.0f);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static Color fromName(String name) {
        switch (name.toLowerCase()) {
            case "red": {
                return RED;
            }
            case "green": {
                return GREEN;
            }
            case "light_green": {
                return LIGHT_GREEN;
            }
            case "dark_green": {
                return DARK_GREEN;
            }
            case "blue": {
                return BLUE;
            }
            case "dark_blue": {
                return DARK_BLUE;
            }
            case "yellow": {
                return YELLOW;
            }
            case "gold": {
                return GOLD;
            }
            case "orange": {
                return ORANGE;
            }
            case "aqua": {
                return AQUA;
            }
            case "cyan": {
                return CYAN;
            }
            case "purple": {
                return PURPLE;
            }
            case "pink": {
                return PINK;
            }
            case "magenta": {
                return MAGENTA;
            }
            case "white": {
                return WHITE;
            }
            case "black": {
                return BLACK;
            }
        }
        return BLACK;
    }

    public class HSV {
        public float h;
        public float s;
        public float v;

        public HSV(float h, float s, float v) {
            this.h = h;
            this.s = s;
            this.v = v;
        }
    }
}

