/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import ru.astemir.astemirlib.common.handler.ClientLevelEventHandler;
import ru.astemir.astemirlib.common.handler.LevelEvent;
import ru.astemir.astemirlib.common.handler.ServerLevelEventHandler;
import ru.astemir.astemirlib.common.network.NetworkUtils;
import ru.astemir.astemirlib.common.network.PacketArgument;
import ru.astemir.astemirlib.common.network.messages.ClientMessageWorldPosEvent;
import ru.astemir.astemirlib.common.network.messages.ServerMessageWorldPosEvent;

public class LevelEventHandler {
    public static LevelEventHandler INSTANCE = new LevelEventHandler();
    private Map<String, ClientLevelEventHandler> clientListeners = new HashMap<String, ClientLevelEventHandler>();
    private Map<String, ServerLevelEventHandler> serverListeners = new HashMap<String, ServerLevelEventHandler>();

    public void addClientListener(ResourceLocation name, ClientLevelEventHandler listener) {
        this.clientListeners.put(name.toString(), listener);
    }

    public void addServerListener(ResourceLocation name, ServerLevelEventHandler listener) {
        this.serverListeners.put(name.toString(), listener);
    }

    public <T extends ClientLevelEventHandler> T getClientEventListener(String name) {
        return (T)this.clientListeners.get(name);
    }

    public <T extends ServerLevelEventHandler> T getServerEventListener(String name) {
        return (T)this.serverListeners.get(name);
    }

    public void onClientHandleEvent(BlockPos pos, int event, PacketArgument[] arguments) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        for (ClientLevelEventHandler listener : this.clientListeners.values()) {
            listener.onHandleEvent(level, pos, event, arguments);
        }
    }

    public void onServerHandleEvent(ServerLevel level, BlockPos pos, int event, PacketArgument[] arguments) {
        for (ServerLevelEventHandler listener : this.serverListeners.values()) {
            listener.onHandleEvent(level, pos, event, arguments);
        }
    }

    public static void playClientEvent(Level level, BlockPos pos, LevelEvent event, PacketArgument ... arguments) {
        if (level.f_46443_) {
            return;
        }
        NetworkUtils.sendToAllPlayers(new ClientMessageWorldPosEvent(pos, event.getId(), arguments));
    }

    public static void playClientEvent(Player player, Level level, BlockPos pos, LevelEvent levelEvent, PacketArgument ... arguments) {
        if (level.f_46443_) {
            return;
        }
        NetworkUtils.sendToPlayer((ServerPlayer)player, new ClientMessageWorldPosEvent(pos, levelEvent.getId(), arguments));
    }

    public static void playServerEvent(Level level, BlockPos pos, LevelEvent event, PacketArgument ... arguments) {
        if (!level.f_46443_) {
            return;
        }
        NetworkUtils.sendToServer(new ServerMessageWorldPosEvent(pos, event.getId(), arguments));
    }

    public static void registerClientHandler(ResourceLocation location, ClientLevelEventHandler handler) {
        LevelEventHandler.getInstance().addClientListener(location, handler);
    }

    public static void registerServerHandler(ResourceLocation location, ServerLevelEventHandler handler) {
        LevelEventHandler.getInstance().addServerListener(location, handler);
    }

    public static LevelEventHandler getInstance() {
        return INSTANCE;
    }
}

