/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.action;

import java.util.LinkedList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import ru.astemir.astemirlib.common.action.ActionController;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.misc.ForgeRunLater;

public class ActionStateMachine {
    private LinkedList<ActionController> controllers = new LinkedList();

    public static ActionStateMachine loadControllers(ActionController ... controllers) {
        return new ActionStateMachine(controllers);
    }

    public ActionStateMachine(ActionController ... controllers) {
        for (ActionController controller : controllers) {
            this.addController(controller);
        }
    }

    public int getIdByName(String name) {
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (!name.equals(this.controllers.get(i).getName())) continue;
            return i;
        }
        return 0;
    }

    public void update() {
        for (ActionController controller : this.controllers) {
            controller.update();
        }
    }

    public ActionController getController(String name) {
        for (ActionController controller : this.controllers) {
            if (!controller.getName().equals(name)) continue;
            return controller;
        }
        return null;
    }

    public void addController(ActionController controller) {
        this.controllers.add(controller);
    }

    public LinkedList<ActionController> getControllers() {
        return this.controllers;
    }

    public void read(final CompoundTag tag) {
        new ForgeRunLater(){

            @Override
            public void run() {
                CompoundTag actionMachineTag = tag.m_128469_("ActionMachine");
                for (ActionController controller : ActionStateMachine.this.controllers) {
                    CompoundTag controllerTag;
                    if (!actionMachineTag.m_128441_(controller.getName()) || (controllerTag = actionMachineTag.m_128469_(controller.getName())).m_128456_()) continue;
                    ActionState action = controller.getActionByName(controllerTag.m_128461_("Action"));
                    int ticks = controllerTag.m_128451_("Ticks");
                    controller.setActionWithTime(action, ticks);
                }
            }
        }.runTaskLater(10L);
    }

    public void write(CompoundTag tag) {
        CompoundTag actionMachineTag = new CompoundTag();
        for (ActionController controller : this.controllers) {
            if (controller.isNoAction()) continue;
            CompoundTag controllerTag = new CompoundTag();
            controllerTag.m_128359_("Action", controller.getActionState().getName());
            controllerTag.m_128405_("Ticks", controller.getTicks());
            actionMachineTag.m_128365_(controller.getName(), (Tag)controllerTag);
        }
        tag.m_128365_("ActionMachine", (Tag)actionMachineTag);
    }
}

