/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.action;

import ru.astemir.astemirlib.common.action.ActionController;
import ru.astemir.astemirlib.common.action.ActionLinks;

public class ActionState {
    private int id = 0;
    private String name;
    private int length = 0;
    private boolean canOverrideSelf = false;
    private ActionLinks links = new ActionLinks();

    public ActionState(int id, String name, int length) {
        this.id = id;
        this.name = name;
        this.length = length;
    }

    public ActionState(int id, String name, float length) {
        this.id = id;
        this.name = name;
        this.length = (int)Math.floor(length * 20.0f);
    }

    public ActionState canOverrideSelf() {
        this.canOverrideSelf = true;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isCanOverrideSelf() {
        return this.canOverrideSelf;
    }

    public ActionState onStart(ActionLinks.Start start) {
        this.links.onStart = start;
        return this;
    }

    public ActionState onTick(ActionLinks.Tick tick) {
        this.links.onTick = tick;
        return this;
    }

    public ActionState onEnd(ActionLinks.End end) {
        this.links.onEnd = end;
        return this;
    }

    public ActionLinks getLinks() {
        return this.links;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder = builder.append("[").append(this.name).append(" ").append(this.id).append("]");
        return builder.toString();
    }

    public void onStart(ActionController controller) {
    }

    public void onTick(ActionController controller, int tick) {
    }

    public void onEnd(ActionController controller) {
    }

    public static ActionState timed(int id, String name, float length) {
        return new ActionState(id, name, length);
    }

    public static ActionState timed(int id, String name, int length) {
        return new ActionState(id, name, length);
    }

    public static ActionState infinite(int id, String name) {
        return new ActionState(id, name, -1);
    }
}

