/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.resources.ResourceLocation;
import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.Rect2f;

public class UVTexture {
    private AVector2f textureSize;
    private ResourceLocation texture;
    private Rect2f[] frames = new Rect2f[0];

    public UVTexture(ResourceLocation texture, AVector2f textureSize) {
        this.texture = texture;
        this.textureSize = textureSize;
    }

    public Rect2f getUV(long ticks, long maxTicks) {
        float percent = (float)ticks / (float)maxTicks;
        int index = (int)((float)this.frames.length * percent);
        if (index >= this.frames.length) {
            index = this.frames.length - 1;
        }
        Rect2f textureRect = this.frames[index];
        float pMinU = textureRect.getX() / this.textureSize.getX();
        float pMaxU = (textureRect.getX() + textureRect.getWidth()) / this.textureSize.getX();
        float pMinV = textureRect.getY() / this.textureSize.getY();
        float pMaxV = (textureRect.getY() + textureRect.getHeight()) / this.textureSize.getY();
        return new Rect2f(pMinU, pMinV, pMaxU, pMaxV);
    }

    public UVTexture frames(Rect2f ... rects) {
        this.frames = rects;
        return this;
    }

    public UVTexture frames(Rect2f rect, int count) {
        this.frames = new Rect2f[count];
        for (int i = 0; i < 12; ++i) {
            this.frames[i] = Rect2f.rect((float)i * rect.getX(), (float)i * rect.getY(), rect.getWidth(), rect.getHeight());
        }
        return this;
    }

    public void use() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }
}

