/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Team;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Matrix4f;
import ru.astemir.astemirlib.client.bedrock.model.BedrockEntityModel;
import ru.astemir.astemirlib.client.bedrock.renderer.BaseEntityRenderer;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.client.event.LivingRenderSetupEvent;
import ru.astemir.astemirlib.common.math.Color;

public interface BaseLivingRenderer<T extends LivingEntity, K extends BedrockEntityModel<T>>
extends BaseEntityRenderer<T, K> {
    default public void renderFinal(T entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Direction direction;
        Object model = this.getModel(entity);
        if (model == null) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(entity, this.asLivingRenderer(), partialTick, poseStack, bufferSource, packedLight))) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        poseStack.m_85836_();
        EntityRenderData renderData = EntityRenderData.prepare(entity, partialTick);
        ((BedrockEntityModel)model).f_102608_ = entity.m_21324_(partialTick);
        ((BedrockEntityModel)model).f_102610_ = entity.m_6162_();
        ((BedrockEntityModel)model).f_102609_ = renderData.shouldSit;
        if (entity.m_217003_(Pose.SLEEPING) && (direction = entity.m_21259_()) != null) {
            float eyeHeight = entity.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-direction.m_122429_()) * eyeHeight, 0.0f, (float)(-direction.m_122431_()) * eyeHeight);
        }
        this.setupRotation(entity, (BedrockEntityModel<T>)model, poseStack, renderData.bodyRotation, partialTick);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.setupScale(entity, model, poseStack, partialTick);
        LivingRenderSetupEvent.Scale event = new LivingRenderSetupEvent.Scale((LivingEntity)entity, poseStack, partialTick);
        MinecraftForge.EVENT_BUS.post((Event)event);
        model.m_6839_(entity, renderData.walkingPosition, renderData.walkingSpeed, partialTick);
        boolean bodyVisible = !entity.m_20145_();
        boolean invisibleToPlayer = !bodyVisible && !entity.m_20177_((Player)minecraft.f_91074_);
        boolean glowing = minecraft.m_91314_(entity);
        RenderType renderType = ((BedrockEntityModel)model).getEntityRenderType(entity, bodyVisible, invisibleToPlayer, glowing);
        if (renderType != null) {
            Color color = model.getColor(entity);
            color.alpha(invisibleToPlayer ? ((BedrockEntityModel)model).getInvisibilityAlpha(entity) : color.a);
            model.renderFinal(model, entity, poseStack, bufferSource, packedLight, ((BedrockEntityModel)model).getOverlayCoords((LivingEntity)entity, ((BedrockEntityModel)model).getWhiteOverlayProgress((LivingEntity)entity, partialTick)), color);
        }
        poseStack.m_85849_();
        if (((BedrockEntityModel)model).isShouldRenderName(entity)) {
            RenderNameTagEvent renderNameTagEvent = new RenderNameTagEvent(entity, entity.m_5446_(), (EntityRenderer)this.asLivingRenderer(), poseStack, bufferSource, packedLight, partialTick);
            MinecraftForge.EVENT_BUS.post((Event)renderNameTagEvent);
            if (renderNameTagEvent.getResult() != Event.Result.DENY && (renderNameTagEvent.getResult() == Event.Result.ALLOW || this.isShowingName(entity))) {
                EntityRenderDispatcher entityRenderDispatcher = minecraft.m_91290_();
                Component component = renderNameTagEvent.getContent();
                double d0 = entityRenderDispatcher.m_114471_(entity);
                if (ForgeHooksClient.isNameplateInRenderDistance(entity, (double)d0)) {
                    boolean flag = !entity.m_20163_();
                    float f = entity.m_278726_();
                    int i = "deadmau5".equals(component.getString()) ? -10 : 0;
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.0, (double)f, 0.0);
                    poseStack.m_252781_(entityRenderDispatcher.m_253208_());
                    poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
                    Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                    float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
                    int j = (int)(f1 * 255.0f) << 24;
                    Font font = this.asLivingRenderer().m_114481_();
                    float f2 = -font.m_92852_((FormattedText)component) / 2;
                    font.m_272077_(component, f2, (float)i, 0x20FFFFFF, false, matrix4f, bufferSource, flag ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, packedLight);
                    if (flag) {
                        font.m_272077_(component, f2, (float)i, -1, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
                    }
                    poseStack.m_85849_();
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(entity, this.asLivingRenderer(), partialTick, poseStack, bufferSource, packedLight));
    }

    @Override
    default public void setupRotation(T entity, BedrockEntityModel<T> model, PoseStack poseStack, float bodyRotation, float partialTicks) {
        LivingRenderSetupEvent.Rotation.Pre preEvent = new LivingRenderSetupEvent.Rotation.Pre((LivingEntity)entity, poseStack, (float)((LivingEntity)entity).f_19797_ + partialTicks, bodyRotation, partialTicks);
        if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        bodyRotation = preEvent.getBodyRotation();
        if (entity.m_146890_()) {
            bodyRotation += (float)(Math.cos((double)((LivingEntity)entity).f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if (!entity.m_217003_(Pose.SLEEPING)) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - bodyRotation));
        }
        if (((LivingEntity)entity).f_20919_ > 0) {
            float f = ((float)((LivingEntity)entity).f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f * model.getFlipDegrees(entity)));
        } else if (entity.m_21209_()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - entity.m_146909_()));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)((LivingEntity)entity).f_19797_ + partialTicks) * -75.0f));
        } else if (entity.m_217003_(Pose.SLEEPING)) {
            Direction direction = entity.m_21259_();
            float f1 = direction != null ? this.getRotationFromDir(direction) : bodyRotation;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(f1));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(model.getFlipDegrees(entity)));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (model.isEntityUpsideDown(entity)) {
            poseStack.m_85837_(0.0, (double)(entity.m_20206_() + 0.1f), 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
        LivingRenderSetupEvent.Rotation.Post postEvent = new LivingRenderSetupEvent.Rotation.Post((LivingEntity)entity, poseStack, (float)((LivingEntity)entity).f_19797_ + partialTicks, bodyRotation, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
    }

    default public boolean isShowingName(T entity) {
        boolean flag;
        float f;
        Minecraft minecraft = Minecraft.m_91087_();
        EntityRenderDispatcher entityRenderDispatcher = minecraft.m_91290_();
        double d0 = entityRenderDispatcher.m_114471_(entity);
        float f2 = f = entity.m_20163_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        LocalPlayer localplayer = minecraft.f_91074_;
        boolean bl = flag = !entity.m_20177_((Player)localplayer);
        if (entity != localplayer) {
            Team team = entity.m_5647_();
            Team team1 = localplayer.m_5647_();
            if (team != null) {
                Team.Visibility team$visibility = team.m_7470_();
                switch (team$visibility) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.m_83536_(team1) && (team.m_6259_() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.m_83536_(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.m_91404_() && entity != minecraft.m_91288_() && flag && !entity.m_20160_();
    }

    default public LivingEntityRenderer asLivingRenderer() {
        return (LivingEntityRenderer)this;
    }
}

