/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.model.render.uv;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumMap;
import net.minecraft.core.Direction;
import ru.astemir.astemirlib.client.bedrock.model.render.uv.UV;
import ru.astemir.astemirlib.client.bedrock.model.render.uv.UVFace;
import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.AVector3f;

public interface UVType {
    public UV bake(AVector3f var1);

    public static final class PerFace
    implements UVType {
        private final EnumMap<Direction, UVFace> mappings;

        private PerFace(EnumMap<Direction, UVFace> mappings) {
            this.mappings = mappings;
        }

        @Override
        public UV bake(AVector3f size) {
            return new UV.Faced(Collections.unmodifiableMap(this.mappings));
        }

        private static class Deserializer
        implements JsonDeserializer<PerFace> {
            public static final Direction[] DIRECTIONS = Direction.values();

            private Deserializer() {
            }

            public PerFace deserialize(JsonElement jsonIn, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject json = jsonIn.getAsJsonObject();
                EnumMap<Direction, UVFace> map = new EnumMap<Direction, UVFace>(Direction.class);
                for (Direction direction : DIRECTIONS) {
                    UVFace face = (UVFace)context.deserialize(json.get(direction.m_122433_()), UVFace.class);
                    if (face == null) {
                        face = new UVFace(new AVector2f(), new AVector2f());
                    }
                    map.put(direction, face);
                }
                return new PerFace(map);
            }
        }
    }

    public static final class Box
    implements UVType {
        private final AVector2f uv;

        private Box(AVector2f uv) {
            this.uv = uv;
        }

        @Override
        public UV bake(AVector3f size) {
            return new UV.Box(this.uv, size);
        }

        private static class Deserializer
        implements JsonDeserializer<Box> {
            private Deserializer() {
            }

            public Box deserialize(JsonElement jsonIn, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new Box((AVector2f)context.deserialize(jsonIn, AVector2f.class));
            }
        }
    }

    public static class Deserializer
    implements JsonDeserializer<UVType> {
        private static final PerFace.Deserializer perFaceDecoder = new PerFace.Deserializer();

        public UVType deserialize(JsonElement jsonIn, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (jsonIn.isJsonArray()) {
                return new Box((AVector2f)context.deserialize(jsonIn, AVector2f.class));
            }
            return perFaceDecoder.deserialize(jsonIn, typeOfT, context);
        }
    }
}

