/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.common.math.Color;

public abstract class BedrockModelLayer<T extends Animated> {
    private BedrockModel<T> model;

    public BedrockModelLayer(BedrockModel<T> model) {
        this.model = model;
    }

    public void render(T object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
    }

    public void renderModel(T object, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ResourceLocation texture = this.getTexture(object);
        if (texture != null) {
            VertexConsumer consumer = bufferSource.m_6299_(this.getRenderType(object, this.getTexture(object)));
            Color color = this.getColor(object);
            this.model.getRoot().renderFinal(this.model, object, poseStack, consumer, bufferSource, packedLight, packedOverlay, color);
        }
    }

    public void renderItem(Entity entity, ItemStack itemStack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int overlayCoords = LivingEntityRenderer.m_115338_((LivingEntity)livingEntity, (float)0.0f);
                Minecraft.m_91087_().m_91291_().m_269491_(livingEntity, itemStack, displayContext, false, poseStack, bufferSource, null, packedLightIn, overlayCoords, entity.m_19879_());
            } else {
                Minecraft.m_91087_().m_91291_().m_269128_(itemStack, displayContext, packedLightIn, OverlayTexture.f_118083_, poseStack, bufferSource, null, entity.m_19879_());
            }
        } else {
            Minecraft.m_91087_().m_91291_().m_269128_(itemStack, displayContext, packedLightIn, OverlayTexture.f_118083_, poseStack, bufferSource, null, 0);
        }
    }

    public Color getColor(T object) {
        return Color.WHITE;
    }

    public BedrockModel<T> getModel() {
        return this.model;
    }

    public RenderType getRenderType(T object, ResourceLocation texture) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    public ResourceLocation getTexture(T object) {
        return null;
    }
}

