/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.json.AnimationParser;
import ru.astemir.astemirlib.client.bedrock.json.BedrockModelParser;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModelLayer;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelPart;
import ru.astemir.astemirlib.client.bedrock.renderer.BedrockLivingRenderer;
import ru.astemir.astemirlib.client.bedrock.renderer.EntityRenderData;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.AVector3f;

public abstract class BedrockEntityModel<T extends Entity>
extends EntityModel<T>
implements BedrockModel<T> {
    private BedrockModelPart modelRoot;
    private Map<String, Animation> animations;
    private LinkedList<BedrockModelLayer<T>> layers = new LinkedList();

    public BedrockEntityModel(ResourceLocation model, ResourceLocation animations) {
        this.modelRoot = BedrockModelParser.parseModel(model).bakeRoot();
        this.animations = animations != null ? AnimationParser.parseAnimations(animations) : new HashMap<String, Animation>();
    }

    public void updateAnimations(T entity, EntityRenderData renderData) {
        this.resetAll();
        Animator animator = ((Animated)entity).getOrCreateAnimator(this);
        animator.check(this);
        animator.update(entity);
        animator.applyTransform(entity);
        this.animate(animator, entity, renderData);
    }

    public abstract void animate(Animator var1, T var2, EntityRenderData var3);

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        this.modelRoot.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    public RenderType getEntityRenderType(T entity, boolean visible, boolean invisible, boolean glow) {
        ResourceLocation textureLocation = this.getTexture((Animated)entity);
        if (invisible) {
            return RenderType.m_110470_((ResourceLocation)textureLocation);
        }
        if (visible) {
            return this.getRenderType((Animated)entity, textureLocation);
        }
        return glow ? RenderType.m_110491_((ResourceLocation)textureLocation) : null;
    }

    public AVector3f getBoneRotation(EntityRenderData renderData, LivingEntity entity, String boneName) {
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        if (renderer instanceof BedrockLivingRenderer) {
            BedrockLivingRenderer bedrockLivingRenderer = (BedrockLivingRenderer)renderer;
            PoseStack poseStack = new PoseStack();
            bedrockLivingRenderer.setupRotation(entity, this, poseStack, renderData.bodyRotation, renderData.partialTick);
            for (BedrockModelPart affectedPart : this.getAffectedParts(new LinkedList(), this.getPart(boneName))) {
                affectedPart.applyRotation(poseStack);
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            Quaternionf quaternionf = matrix4f.getNormalizedRotation(new Quaternionf());
            return AVector3f.from(new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)quaternionf)).normalize();
        }
        throw new IllegalStateException("Invalid entity target");
    }

    public PoseStack getBonePose(EntityRenderData renderData, LivingEntity entity, String boneName) {
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        if (renderer instanceof BedrockLivingRenderer) {
            BedrockLivingRenderer bedrockLivingRenderer = (BedrockLivingRenderer)renderer;
            PoseStack poseStack = new PoseStack();
            poseStack.m_85837_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            bedrockLivingRenderer.setupRotation(entity, this, poseStack, renderData.bodyRotation, renderData.partialTick);
            for (BedrockModelPart affectedPart : this.getAffectedParts(new LinkedList(), this.getPart(boneName))) {
                affectedPart.m_104299_(poseStack);
            }
            return poseStack;
        }
        throw new IllegalStateException("Invalid entity target");
    }

    public boolean isMoving(LivingEntity entity, float min, float max, float partialTicks) {
        return EntityUtils.isMoving(entity, min, max, partialTicks);
    }

    public boolean isMoving(Entity entity, float min, float max) {
        return EntityUtils.isMoving(entity, min, max);
    }

    public boolean isMovingByPlayer(Entity entity) {
        return EntityUtils.isMovingByPlayer(entity);
    }

    public float getMotionPotential(Entity entity) {
        return EntityUtils.getMotionPotential(entity);
    }

    public boolean isEntityUpsideDown(T entity) {
        String s;
        if ((entity instanceof Player || entity.m_8077_()) && ("Dinnerbone".equals(s = ChatFormatting.m_126649_((String)entity.m_7755_().getString())) || "Grumm".equals(s))) {
            return !(entity instanceof Player) || ((Player)entity).m_36170_(PlayerModelPart.CAPE);
        }
        return false;
    }

    public int getOverlayCoords(LivingEntity livingEntity, float partialTick) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)partialTick), (int)OverlayTexture.m_118096_((livingEntity.f_20916_ > 0 || livingEntity.f_20919_ > 0 ? 1 : 0) != 0));
    }

    public float getWhiteOverlayProgress(LivingEntity livingEntity, float partialTick) {
        return 0.0f;
    }

    public float getFlipDegrees(T entity) {
        return 90.0f;
    }

    public float getInvisibilityAlpha(T entity) {
        return 0.15f;
    }

    public boolean isShouldRenderName(T entity) {
        return (entity.m_6052_() || entity == Minecraft.m_91087_().m_91290_().f_114359_) && entity.m_8077_();
    }

    @Override
    public LinkedList<BedrockModelLayer<T>> getLayers() {
        return this.layers;
    }

    @Override
    public BedrockModelPart getRoot() {
        return this.modelRoot;
    }

    @Override
    public Map<String, Animation> getAnimations() {
        return this.animations;
    }

    @Deprecated
    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

