/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;

public class TextureLoader {

    public class Texture {
        public static AbstractTexture load(ResourceLocation location) {
            return Texture.load(location, WrapMode.CLAMP_TO_EDGE, WrapMode.CLAMP_TO_EDGE, FilterMode.LINEAR, FilterMode.LINEAR);
        }

        public static AbstractTexture load(ResourceLocation location, WrapMode wrapS, WrapMode wrapT, FilterMode minFilter, FilterMode magFilter) {
            Minecraft minecraft = Minecraft.m_91087_();
            AbstractTexture texture = minecraft.m_91097_().m_118506_(location);
            if (texture == null) {
                texture = new SimpleTexture(location);
                minecraft.m_91097_().m_118495_(location, texture);
            }
            if (wrapS != null || wrapT != null) {
                Texture.setWrapMode(texture, wrapS, wrapT);
            }
            if (minFilter != null || magFilter != null) {
                Texture.setFilterMode(texture, minFilter, magFilter);
            }
            return texture;
        }

        public static AbstractTexture setWrapMode(AbstractTexture texture, WrapMode wrapS, WrapMode wrapT) {
            GlStateManager._bindTexture((int)texture.m_117963_());
            GlStateManager._texParameter((int)texture.m_117963_(), (int)10242, (int)wrapS.getGlEnum());
            GlStateManager._texParameter((int)texture.m_117963_(), (int)10243, (int)wrapT.getGlEnum());
            GlStateManager._bindTexture((int)0);
            return texture;
        }

        public static AbstractTexture setFilterMode(AbstractTexture texture, FilterMode minFilter, FilterMode magFilter) {
            GlStateManager._bindTexture((int)texture.m_117963_());
            GlStateManager._texParameter((int)texture.m_117963_(), (int)10241, (int)minFilter.getMinFilter());
            GlStateManager._texParameter((int)texture.m_117963_(), (int)10240, (int)magFilter.getMagFilter());
            GlStateManager._bindTexture((int)0);
            return texture;
        }

        public static enum WrapMode {
            CLAMP_TO_EDGE(33071),
            REPEAT(10497),
            MIRRORED_REPEAT(33648);

            private final int glEnum;

            private WrapMode(int glEnum) {
                this.glEnum = glEnum;
            }

            public int getGlEnum() {
                return this.glEnum;
            }
        }

        public static enum FilterMode {
            NEAREST(9728, 9984),
            LINEAR(9729, 9987);

            private final int minFilter;
            private final int magFilter;

            private FilterMode(int minFilter, int magFilter) {
                this.minFilter = minFilter;
                this.magFilter = magFilter;
            }

            public int getMinFilter() {
                return this.minFilter;
            }

            public int getMagFilter() {
                return this.magFilter;
            }
        }
    }
}

