/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.astemir.astemirlib.client.bedrock.renderer.AstemirRenderDispatcher;
import ru.astemir.astemirlib.client.event.DeferredRendererEvent;
import ru.astemir.astemirlib.client.event.EntityRenderEvent;
import ru.astemir.astemirlib.common.math.AVector3f;

@Mod.EventBusSubscriber(modid="astemirlib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class DeferredEntityRenderer {
    private static Map<UUID, EntityRenderEvent> renderEvents = new HashMap<UUID, EntityRenderEvent>();

    @SubscribeEvent
    public static void onEntityRender(EntityRenderEvent e) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DeferredRendererEvent.Prepare(e))) {
            renderEvents.put(e.getEntity().m_20148_(), e);
            e.setCanceled(true);
        }
    }

    public static void renderDeferred(UUID uuid, PoseStack newPoseStack, AVector3f renderPosition, float yRot) {
        EntityRenderEvent event = DeferredEntityRenderer.getRenderEvent(uuid);
        if (event != null) {
            Entity entity = event.getEntity();
            EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
            AstemirRenderDispatcher.getInstance()._renderUnsafe(entity, renderPosition.x, renderPosition.y, renderPosition.z, yRot, event.getPartialTick(), newPoseStack != null ? newPoseStack : event.getPoseStack(), event.getBufferSource(), entityRenderDispatcher.m_114394_(entity, event.getPartialTick()));
            DeferredEntityRenderer.releaseEvent(uuid);
        }
    }

    public static EntityRenderEvent getRenderEvent(UUID uuid) {
        if (renderEvents.containsKey(uuid)) {
            return renderEvents.get(uuid);
        }
        return null;
    }

    public static void releaseEvent(UUID uuid) {
        if (renderEvents.containsKey(uuid)) {
            renderEvents.remove(uuid);
        }
    }
}

