/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.MusselBlock;
import com.github.alexmodguy.alexscaves.server.level.feature.config.WhalefallFeatureConfiguration;
import com.github.alexmodguy.alexscaves.server.level.structure.processor.WhalefallProcessor;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WhalefallFeature
extends Feature<WhalefallFeatureConfiguration> {
    public WhalefallFeature(Codec<WhalefallFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<WhalefallFeatureConfiguration> context) {
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos.MutableBlockPos trenchBottom = new BlockPos.MutableBlockPos();
        trenchBottom.m_122190_((Vec3i)context.m_159777_());
        while (!level.m_8055_((BlockPos)trenchBottom).m_60819_().m_76178_() && trenchBottom.m_123342_() > level.m_141937_()) {
            trenchBottom.m_122184_(0, -1, 0);
        }
        if (level.m_8055_(trenchBottom.m_7495_()).m_60713_((Block)ACBlockRegistry.MUCK.get())) {
            Rotation rotation = Rotation.m_221990_((RandomSource)randomsource);
            ResourceLocation head = ((WhalefallFeatureConfiguration)context.m_159778_()).headStructures.get(randomsource.m_188503_(((WhalefallFeatureConfiguration)context.m_159778_()).headStructures.size()));
            ResourceLocation body = ((WhalefallFeatureConfiguration)context.m_159778_()).bodyStructures.get(randomsource.m_188503_(((WhalefallFeatureConfiguration)context.m_159778_()).bodyStructures.size()));
            ResourceLocation tail = ((WhalefallFeatureConfiguration)context.m_159778_()).tailStructures.get(randomsource.m_188503_(((WhalefallFeatureConfiguration)context.m_159778_()).tailStructures.size()));
            Direction direction = rotation.m_55954_(Direction.SOUTH);
            Direction bendTo = randomsource.m_188499_() ? direction.m_122427_() : direction.m_122428_();
            StructureTemplateManager structuretemplatemanager = level.m_6018_().m_7654_().m_236738_();
            BlockPos startAt = trenchBottom.m_7949_().m_5484_(direction.m_122424_(), 5);
            int i = this.generateStructurePiece(level, structuretemplatemanager, rotation, randomsource, head, startAt, false);
            int bendToDist = randomsource.m_188503_(2);
            int j = this.generateStructurePiece(level, structuretemplatemanager, rotation, randomsource, body, startAt.m_5484_(direction, i + randomsource.m_188503_(1)).m_5484_(bendTo, bendToDist), true) + 1;
            this.generateStructurePiece(level, structuretemplatemanager, rotation, randomsource, tail, startAt.m_5484_(direction, i + j + randomsource.m_188503_(1)).m_5484_(bendTo, bendToDist + randomsource.m_188503_(2)), true);
            return true;
        }
        return false;
    }

    private int generateStructurePiece(WorldGenLevel level, StructureTemplateManager structuretemplatemanager, Rotation rotation, RandomSource randomsource, ResourceLocation head, BlockPos blockpos, boolean gravity) {
        StructureTemplate structuretemplate = structuretemplatemanager.m_230359_(head);
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().m_74379_(rotation).m_230324_(randomsource).m_74383_((StructureProcessor)(gravity ? WhalefallProcessor.INSTANCE_GRAVITY : WhalefallProcessor.INSTANCE_NO_GRAVITY));
        Vec3i defaultSize = structuretemplate.m_163808_(Rotation.NONE);
        Vec3i rotatedSize = structuretemplate.m_163808_(rotation);
        BlockPos blockpos1 = blockpos.m_7918_(-rotatedSize.m_123341_() / 2, 0, -rotatedSize.m_123343_() / 2);
        BlockPos blockpos2 = structuretemplate.m_74583_(blockpos1, Mirror.NONE, rotation);
        structuretemplate.m_230328_((ServerLevelAccessor)level, blockpos2, blockpos2, structureplacesettings, randomsource, 18);
        BoundingBox decorateBox = structuretemplate.m_74633_(structureplacesettings, blockpos2).m_191961_(1);
        BlockPos.m_121919_((BoundingBox)decorateBox).forEach(pos -> this.decorateWhalefallPos((BlockPos)pos, level, randomsource));
        return Math.abs(defaultSize.m_123343_());
    }

    private void decorateWhalefallPos(BlockPos pos, WorldGenLevel worldgenlevel, RandomSource randomsource) {
        BlockState replaceAt;
        Direction dir = Direction.m_235672_((RandomSource)randomsource);
        BlockPos blockpos2 = pos.m_121945_(dir);
        if ((worldgenlevel.m_8055_(blockpos2).m_204336_(ACTagRegistry.WHALEFALL_IGNORES) || randomsource.m_188503_(5) == 0) && ((replaceAt = worldgenlevel.m_8055_(pos)).m_60713_(Blocks.f_49990_) || replaceAt.m_60795_()) && worldgenlevel.m_8055_(blockpos2).m_60783_((BlockGetter)worldgenlevel, blockpos2, dir.m_122424_())) {
            boolean waterlog = worldgenlevel.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            if (randomsource.m_188499_()) {
                worldgenlevel.m_7731_(pos, (BlockState)((BlockState)((Block)ACBlockRegistry.BONE_WORMS.get()).m_49966_().m_61124_((Property)MusselBlock.FACING, (Comparable)dir.m_122424_())).m_61124_((Property)MusselBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlog)), 3);
            } else {
                worldgenlevel.m_7731_(pos, (BlockState)((BlockState)((BlockState)((Block)ACBlockRegistry.MUSSEL.get()).m_49966_().m_61124_((Property)MusselBlock.FACING, (Comparable)dir.m_122424_())).m_61124_((Property)MusselBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlog))).m_61124_((Property)MusselBlock.MUSSELS, (Comparable)Integer.valueOf(1 + randomsource.m_188503_(4))), 3);
            }
        }
    }
}

