/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.util;

import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public enum MagnetronJoint {
    SHOULDER(new Vec3(1.0, 0.5, 0.0), false),
    ELBOW(new Vec3(1.5, -0.5, (double)0.2f), false),
    HAND(new Vec3(1.5, -1.5, (double)0.4f), false),
    KNEE(new Vec3(0.5, -1.5, 0.0), true),
    FOOT(new Vec3(0.5, -3.0, 0.0), true);

    private Vec3 basePosition;
    private boolean leg;

    private MagnetronJoint(Vec3 basePosition, boolean leg) {
        this.basePosition = basePosition;
        this.leg = leg;
    }

    public Vec3 getTargetPosition(MagnetronEntity entity, boolean left) {
        Vec3 base = this.basePosition;
        float poseProgress = entity.getAttackPoseProgress(1.0f);
        float priorPoseProgress = 1.0f - poseProgress;
        if (left) {
            base = new Vec3(-this.basePosition.f_82479_, this.basePosition.f_82480_, this.basePosition.f_82481_);
        }
        base = base.m_82549_(this.animateForPose(left, entity, entity.getPrevAttackPose(), priorPoseProgress));
        base = base.m_82549_(this.animateForPose(left, entity, entity.getAttackPose(), poseProgress));
        return base.m_82524_((float)Math.toRadians(-entity.f_20883_));
    }

    public Vec3 animateForPose(boolean left, MagnetronEntity entity, MagnetronEntity.AttackPose pose, float progress) {
        Vec3 add = Vec3.f_82478_;
        float walkSpeed = 0.2f;
        float walkDegree = 0.4f;
        if (pose == MagnetronEntity.AttackPose.NONE) {
            float limbSwing = 0.0f;
            float limbSwingAmount = 1.0f;
            if (entity.m_6084_()) {
                limbSwingAmount = entity.f_267362_.m_267731_() * 2.0f;
                limbSwing = entity.f_267362_.m_267756_() * 2.0f;
            }
            if (this == KNEE) {
                float up = this.calculateRotation(walkSpeed, walkDegree * 0.6f, left, 0.0f, left ? -0.3f : 0.3f, limbSwing, limbSwingAmount);
                float forwards = this.calculateRotation(walkSpeed, walkDegree * 1.5f, left, 0.0f, 0.0f, limbSwing, limbSwingAmount);
                add = new Vec3(0.0, (double)up, (double)forwards);
            } else if (this == FOOT) {
                float up = this.calculateRotation(walkSpeed, walkDegree * 1.0f, left, 1.0f, 0.0f, limbSwing, limbSwingAmount);
                float forwards = this.calculateRotation(walkSpeed, walkDegree * 2.5f, left, 0.0f, left ? -0.2f : 0.2f, limbSwing, limbSwingAmount);
                add = new Vec3(0.0, (double)up, (double)forwards);
            } else if (this == SHOULDER) {
                float up = this.calculateRotation(walkSpeed, walkDegree * -0.2f, !left, 0.0f, 0.0f, limbSwing, limbSwingAmount);
                float forwards = this.calculateRotation(walkSpeed, walkDegree * 0.75f, !left, 0.0f, 0.0f, limbSwing, limbSwingAmount);
                add = new Vec3(0.0, (double)up, (double)forwards);
            } else if (this == ELBOW) {
                float up = this.calculateRotation(walkSpeed, walkDegree * -0.2f, !left, 0.0f, 0.0f, limbSwing, limbSwingAmount);
                float forwards = this.calculateRotation(walkSpeed, walkDegree * 1.5f, !left, -1.0f, 0.0f, limbSwing, limbSwingAmount);
                add = new Vec3(0.0, (double)up, (double)forwards);
            } else if (this == HAND) {
                float up = this.calculateRotation(walkSpeed, walkDegree * 0.2f, !left, 0.0f, 0.0f, limbSwing, limbSwingAmount);
                float forwards = this.calculateRotation(walkSpeed, walkDegree * 2.2f, !left, -1.0f, 0.0f, limbSwing, limbSwingAmount);
                add = new Vec3(0.0, (double)up, (double)forwards);
            }
        } else if (pose == MagnetronEntity.AttackPose.RIGHT_PUNCH) {
            if (this == SHOULDER) {
                add = !left ? new Vec3(0.0, -0.5, 0.5) : new Vec3((double)-0.15f, 0.0, -0.5);
            } else if (this == ELBOW) {
                add = !left ? new Vec3(-1.0, (double)-0.1f, 1.5) : new Vec3(-0.5, 0.0, (double)-0.7f);
            } else if (this == HAND) {
                add = !left ? new Vec3(-2.0, 0.5, 3.0) : new Vec3(-1.0, 0.0, (double)-0.9f);
            }
        } else if (pose == MagnetronEntity.AttackPose.LEFT_PUNCH) {
            if (this == SHOULDER) {
                add = left ? new Vec3(0.0, -0.5, 0.5) : new Vec3((double)0.15f, 0.0, -0.5);
            } else if (this == ELBOW) {
                add = left ? new Vec3(1.0, (double)-0.1f, 1.5) : new Vec3(0.5, 0.0, (double)-0.7f);
            } else if (this == HAND) {
                add = left ? new Vec3(2.0, 0.5, 3.0) : new Vec3(1.0, 0.0, (double)-0.9f);
            }
        } else if (pose == MagnetronEntity.AttackPose.SLAM) {
            float f = left ? 1.0f : -1.0f;
            float piHalf = 1.5707964f;
            Vec3 up = Vec3.f_82478_;
            if (this == SHOULDER) {
                up = new Vec3((double)(0.3f * f), -0.5, -1.0);
            } else if (this == ELBOW) {
                up = new Vec3((double)(0.5f * f), -1.0, -1.0);
            } else if (this == HAND) {
                up = new Vec3((double)(1.0f * f), -2.0, -1.5);
            }
            add = up.m_82496_(-piHalf - progress * 2.0f * piHalf);
        }
        return add.m_82490_((double)progress);
    }

    private float calculateRotation(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        float rotation = Mth.m_14089_((float)(f * speed + offset)) * degree * f1 + weight * f1;
        return invert ? -rotation : rotation;
    }
}

