/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.ai.CorrodentAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.CorrodentDigRandomlyGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.CorrodentFearLightGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTarget3DGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.CorrodentTailEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.collision.ICustomCollisions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.entity.PartEntity;

public class CorrodentEntity
extends Monster
implements ICustomCollisions,
IAnimatedEntity {
    public static final int LIGHT_THRESHOLD = 7;
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.m_135353_(CorrodentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AFRAID = SynchedEntityData.m_135353_(CorrodentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DIG_PITCH = SynchedEntityData.m_135353_(CorrodentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public final CorrodentTailEntity tailPart;
    public final CorrodentTailEntity[] allParts;
    private float[][] trailTransformations = new float[64][2];
    protected boolean isLandNavigator;
    private int trailPointer = -1;
    private float prevDigPitch = 0.0f;
    private float fakeYRot = 0.0f;
    private float fearProgress;
    private float prevFearProgress;
    private float digProgress;
    private float prevDigProgress;
    public int timeDigging = 0;
    public int fleeLightFor = 0;
    private Vec3 surfacePosition;
    private Vec3 prevSurfacePosition;
    private Animation currentAnimation;
    private int animationTick;

    public CorrodentEntity(EntityType type, Level level) {
        super(type, level);
        this.switchNavigator(true);
        this.tailPart = new CorrodentTailEntity(this);
        this.allParts = new CorrodentTailEntity[]{this.tailPart};
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DIGGING, (Object)false);
        this.f_19804_.m_135372_(AFRAID, (Object)false);
        this.f_19804_.m_135372_(DIG_PITCH, (Object)Float.valueOf(0.0f));
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = this.m_6037_(this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new DiggingMoveControl();
            this.f_21344_ = new Navigator((Mob)this, this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CorrodentFearLightGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CorrodentAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CorrodentDigRandomlyGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 20));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new MobTarget3DGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(1.0, 1.0, 1.0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevDigPitch = this.getDigPitch();
        this.prevDigProgress = this.digProgress;
        this.prevFearProgress = this.fearProgress;
        this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.f_20883_, (float)10.0f);
        if (!this.isDigging() || !this.isMoving()) {
            this.setDigPitch(Mth.m_14148_((float)this.getDigPitch(), (float)0.0f, (float)10.0f));
        }
        this.tickMultipart();
        if (this.isDigging() && this.digProgress < 5.0f) {
            this.digProgress += 1.0f;
        }
        if (!this.isDigging() && this.digProgress > 0.0f) {
            if (this.digProgress == 5.0f) {
                this.m_216990_((SoundEvent)ACSoundRegistry.CORRODENT_DIG_STOP.get());
            }
            this.digProgress -= 1.0f;
        }
        if (this.isAfraid() && this.fearProgress < 5.0f) {
            this.fearProgress += 1.0f;
        }
        if (!this.isAfraid() && this.fearProgress > 0.0f) {
            this.fearProgress -= 1.0f;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isDigging()) {
                ++this.timeDigging;
                if (this.isLandNavigator) {
                    this.switchNavigator(false);
                    this.m_9236_().m_7605_((Entity)this, (byte)77);
                    this.setDigPitch(90.0f);
                }
                if (this.timeDigging > 40 && !this.m_5830_()) {
                    this.setDigging(false);
                    this.m_146884_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.35, 0.0));
                }
                if (!CorrodentEntity.isSafeDig((BlockGetter)this.m_9236_(), this.m_20183_())) {
                    if (CorrodentEntity.canDigBlock(this.m_9236_().m_8055_(this.m_20183_().m_7494_()))) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
                    }
                    if (CorrodentEntity.canDigBlock(this.m_9236_().m_8055_(this.m_20183_().m_7495_()))) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
                    }
                }
                this.m_20242_(this.m_5830_());
            } else {
                this.timeDigging = 0;
                if (!this.isLandNavigator) {
                    this.switchNavigator(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)77);
                    this.setDigPitch(-90.0f);
                }
                this.m_20242_(false);
            }
        } else if (this.isDigging() && this.m_6084_()) {
            AlexsCaves.PROXY.playWorldSound((Object)this, (byte)6);
        }
        this.prevSurfacePosition = this.surfacePosition;
        if (this.isMoving() || this.surfacePosition == null) {
            this.surfacePosition = this.calculateLightAbovePosition();
        }
        if (this.isDigging() && this.surfacePosition != null && this.m_9236_().f_46443_ && this.isMoving()) {
            BlockState surfaceState = this.m_9236_().m_8055_(BlockPos.m_274446_((Position)this.surfacePosition).m_7495_());
            BlockState onState = this.m_146900_();
            if (surfaceState.m_280296_()) {
                Vec3 head = new Vec3(0.0, 0.0, (double)0.7f).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)).m_82520_(this.m_20185_(), this.surfacePosition.f_82480_, this.m_20189_());
                this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, surfaceState), true, head.f_82479_, head.f_82480_, head.f_82481_, (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() + 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f));
                for (int i = 0; i < 4 + this.f_19796_.m_188503_(4); ++i) {
                    float j = (float)Math.pow(i, 0.75);
                    Vec3 offset = new Vec3(i % 2 == 0 ? (double)(-j * 0.2f) : (double)(j * 0.2f), 0.0, (double)(-0.3f * (float)i)).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                    this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, surfaceState), true, offset.f_82479_ + head.f_82479_, offset.f_82480_ + head.f_82480_, offset.f_82481_ + head.f_82481_, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f) + offset.f_82479_, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f) + offset.f_82480_, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f) + offset.f_82481_);
                }
            }
            if (onState.m_280296_()) {
                for (int i = 0; i < 2 + this.f_19796_.m_188503_(2); ++i) {
                    this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, onState), true, this.m_20208_(0.8f), this.m_20187_(), this.m_20262_(0.8f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f));
                }
            }
        }
        if (this.fleeLightFor > 0) {
            --this.fleeLightFor;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void m_7822_(byte b) {
        if (b == 77) {
            float radius = 1.0f;
            float particleCount = 20 + this.f_19796_.m_188503_(12);
            int i1 = 0;
            while ((float)i1 < particleCount) {
                double motionX = (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7;
                double motionY = (double)this.m_217043_().m_188501_() * 0.7 + (double)0.8f;
                double motionZ = (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7;
                float angle = (float)Math.PI / 180 * (this.f_20883_ + (float)i1 / particleCount * 360.0f);
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 1.2f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                BlockPos ground = BlockPos.m_274446_((Position)ACMath.getGroundBelowPosition((BlockGetter)this.m_9236_(), new Vec3((double)Mth.m_14107_((double)(this.m_20185_() + extraX)), (double)(Mth.m_14107_((double)(this.m_20186_() + extraY)) + 2), (double)Mth.m_14107_((double)(this.m_20189_() + extraZ)))));
                BlockState groundState = this.m_9236_().m_8055_(ground);
                if (groundState.m_280296_() && this.m_9236_().f_46443_) {
                    this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, groundState), true, this.m_20185_() + extraX, (double)ground.m_123342_() + extraY, this.m_20189_() + extraZ, motionX, motionY, motionZ);
                }
                ++i1;
            }
        } else {
            super.m_7822_(b);
        }
    }

    public int getCorrosionAmount(BlockPos pos) {
        BlockState state;
        double distance = this.m_20275_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
        if (distance <= 10.0 && CorrodentEntity.canDigBlock(state = this.m_9236_().m_8055_(pos)) && !state.m_60795_() && !state.m_247087_()) {
            return 10 - (int)distance;
        }
        return -1;
    }

    public void setDigPitch(float pitch) {
        this.f_19804_.m_135381_(DIG_PITCH, (Object)Float.valueOf(pitch));
    }

    public float getDigPitch() {
        return ((Float)this.f_19804_.m_135370_(DIG_PITCH)).floatValue();
    }

    private Vec3 calculateLightAbovePosition() {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122178_(this.m_146903_(), this.m_146904_(), this.m_146907_());
        while (mutableBlockPos.m_123342_() < this.m_9236_().m_151558_() && this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60828_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos)) {
            mutableBlockPos.m_122184_(0, 1, 0);
        }
        return new Vec3(this.m_20185_(), (double)mutableBlockPos.m_123342_(), this.m_20189_());
    }

    private void tickMultipart() {
        float digPitch = this.getDigPitch();
        if (this.trailPointer == -1) {
            this.fakeYRot = this.f_20883_;
            for (int i = 0; i < this.trailTransformations.length; ++i) {
                this.trailTransformations[i][0] = digPitch;
                this.trailTransformations[i][1] = this.fakeYRot;
            }
        }
        this.fakeYRot = Mth.m_14148_((float)this.fakeYRot, (float)this.f_20883_, (float)10.0f);
        if (++this.trailPointer == this.trailTransformations.length) {
            this.trailPointer = 0;
        }
        this.trailTransformations[this.trailPointer][0] = digPitch;
        this.trailTransformations[this.trailPointer][1] = this.fakeYRot;
        Vec3[] avector3d = new Vec3[this.allParts.length];
        for (int j = 0; j < this.allParts.length; ++j) {
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
        }
        this.tailPart.setToTransformation(new Vec3(0.0, 0.0, -1.0), this.getTrailTransformation(5, 0, 1.0f), this.getTrailTransformation(5, 1, 1.0f));
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
    }

    public boolean isMoving() {
        float f = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        return f > 0.1f;
    }

    public float getDigPitch(float partialTick) {
        return this.prevDigPitch + (this.getDigPitch() - this.prevDigPitch) * partialTick;
    }

    public float getDigAmount(float partialTick) {
        return (this.prevDigProgress + (this.digProgress - this.prevDigProgress) * partialTick) * 0.2f;
    }

    public float getAfraidAmount(float partialTick) {
        return (this.prevFearProgress + (this.fearProgress - this.prevFearProgress) * partialTick) * 0.2f;
    }

    public float getTrailTransformation(int pointer, int index, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        float d0 = this.trailTransformations[j][index];
        float d1 = this.trailTransformations[i][index] - d0;
        return d0 + d1 * partialTick;
    }

    public Vec3 m_20272_(Vec3 vec3) {
        return !this.isDigging() ? super.m_20272_(vec3) : ICustomCollisions.getAllowedMovementForEntity((Entity)this, (Vec3)vec3);
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
        if (this.allParts != null) {
            for (CorrodentTailEntity part : this.allParts) {
                part.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        return super.m_6673_(damageSource) || damageSource.m_276093_(DamageTypes.f_268612_);
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(DIGGING);
    }

    public void setDigging(boolean bool) {
        this.f_19804_.m_135381_(DIGGING, (Object)bool);
    }

    public boolean isAfraid() {
        return (Boolean)this.f_19804_.m_135370_(AFRAID);
    }

    public void setAfraid(boolean bool) {
        this.f_19804_.m_135381_(AFRAID, (Object)bool);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public boolean canPassThrough(BlockPos blockPos, BlockState blockState, VoxelShape voxelShape) {
        return this.isDigging() && CorrodentEntity.canDigBlock(blockState);
    }

    public boolean m_20039_(BlockPos pos, BlockState blockstate) {
        return (!this.isDigging() || CorrodentEntity.canDigBlock(blockstate)) && super.m_20039_(pos, blockstate);
    }

    public static boolean canDigBlock(BlockState state) {
        return !state.m_204336_(ACTagRegistry.CORRODENT_BLOCKS_DIGGING) && state.m_60819_().m_76178_() && state.m_60815_();
    }

    public Vec3 m_7371_(float f) {
        if (this.surfacePosition != null && this.prevSurfacePosition != null) {
            Vec3 difference = this.surfacePosition.m_82546_(this.prevSurfacePosition);
            return this.prevSurfacePosition.m_82549_(difference.m_82490_((double)f)).m_82520_(0.0, (double)this.m_20192_(), 0.0);
        }
        return super.m_7371_(f);
    }

    public static boolean isSafeDig(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockState below = level.m_8055_(pos.m_7495_());
        return CorrodentEntity.canDigBlock(state) && CorrodentEntity.canDigBlock(below);
    }

    protected int m_5639_(float f1, float f2) {
        return super.m_5639_(f1, f2) - 5;
    }

    public boolean canReach(BlockPos target) {
        int k;
        int j;
        Path path = this.m_21573_().m_7864_(target, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - target.m_123341_();
        return (double)(i * i + (j = node.f_77272_ - target.m_123342_()) * j + (k = node.f_77273_ - target.m_123343_()) * k) <= 3.0;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (!this.isDigging()) {
            super.m_7840_(y, onGroundIn, state, pos);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.isDigging()) {
            super.m_7355_(pos, state);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public static boolean checkCorrodentSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return CorrodentEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.CORRODENT_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.CORRODENT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.CORRODENT_DEATH.get();
    }

    private class DiggingMoveControl
    extends MoveControl {
        public DiggingMoveControl() {
            super((Mob)CorrodentEntity.this);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 ed = this.f_24974_.m_21573_().m_26567_().m_252807_();
                Vec3 vector3d = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.f_24974_.m_20191_().m_82309_();
                float burySpeed = CorrodentEntity.this.timeDigging < 40 ? 0.25f : 1.0f;
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * (double)burySpeed * 0.025 / d0);
                if (CorrodentEntity.isSafeDig((BlockGetter)CorrodentEntity.this.m_9236_(), BlockPos.m_274561_((double)this.f_24975_, (double)this.f_24976_, (double)this.f_24977_))) {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82549_(vector3d1).m_82490_((double)0.9f));
                } else {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, 0.3, 0.0).m_82490_((double)0.7f));
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.f_24974_.m_21573_().m_26573_();
                }
                if (d0 < width * (double)0.15f) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width) {
                    this.f_24974_.m_146922_(-((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f);
                    float f2 = (float)(-(Mth.m_14136_((double)vector3d1.f_82480_, (double)vector3d1.m_165924_()) * 57.2957763671875));
                    CorrodentEntity.this.setDigPitch(Mth.m_14148_((float)CorrodentEntity.this.getDigPitch(), (float)f2, (float)10.0f));
                }
            }
        }

        private boolean isWalkable(Vec3 offset) {
            return true;
        }
    }

    class Navigator
    extends FlyingPathNavigation {
        public Navigator(Mob mob, Level world) {
            super(mob, world);
        }

        public boolean m_6342_(BlockPos blockPos) {
            return !this.f_26495_.m_46859_(blockPos) && CorrodentEntity.isSafeDig((BlockGetter)this.f_26495_, blockPos);
        }

        protected PathFinder m_5532_(int i) {
            this.f_26508_ = new DiggingNodeEvaluator();
            return new PathFinder(this.f_26508_, i);
        }

        protected double m_183345_(Vec3 vec3) {
            return vec3.f_82480_;
        }

        protected boolean m_7632_() {
            return true;
        }

        protected void m_7636_() {
            boolean flag;
            Vec3 vector3d = this.m_7475_();
            this.f_26505_ = this.f_26494_.m_20205_();
            BlockPos vector3i = this.f_26496_.m_77400_();
            double d0 = Math.abs(this.f_26494_.m_20185_() - ((double)vector3i.m_123341_() + 0.5));
            double d1 = Math.abs(this.f_26494_.m_20186_() - (double)vector3i.m_123342_());
            double d2 = Math.abs(this.f_26494_.m_20189_() - ((double)vector3i.m_123343_() + 0.5));
            boolean bl = flag = d0 < (double)this.f_26505_ && d2 < (double)this.f_26505_ && d1 <= 1.0;
            if (flag || this.m_264193_(this.f_26496_.m_77401_().f_77282_) && this.shouldTargetNextNodeInDirection(vector3d)) {
                this.f_26496_.m_77374_();
            }
            this.m_6481_(vector3d);
        }

        protected boolean m_183431_(Vec3 vec3, Vec3 vec31) {
            Vec3 vector3d = new Vec3(vec31.f_82479_, vec31.f_82480_ + (double)this.f_26494_.m_20206_() * 0.5, vec31.f_82481_);
            BlockHitResult result = this.f_26495_.m_45547_(new ClipContext(vec3, vector3d, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.f_26494_));
            return CorrodentEntity.isSafeDig((BlockGetter)this.f_26495_, result.m_82425_());
        }

        private boolean shouldTargetNextNodeInDirection(Vec3 currentPosition) {
            Vec3 vector3d3;
            if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
                return false;
            }
            Vec3 vector3d = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
            if (!currentPosition.m_82509_((Position)vector3d, 2.0)) {
                return false;
            }
            Vec3 vector3d1 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + 1));
            Vec3 vector3d2 = vector3d1.m_82546_(vector3d);
            return vector3d2.m_82526_(vector3d3 = currentPosition.m_82546_(vector3d)) > 0.0;
        }
    }

    static class DiggingNodeEvaluator
    extends FlyNodeEvaluator {
        DiggingNodeEvaluator() {
        }

        protected BlockPathTypes m_264405_(BlockGetter level, BlockPos pos, BlockPathTypes typeIn) {
            BlockPathTypes def = DiggingNodeEvaluator.m_77604_((BlockGetter)level, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (def == BlockPathTypes.LAVA || def == BlockPathTypes.OPEN || def == BlockPathTypes.WATER || def == BlockPathTypes.WATER_BORDER || def == BlockPathTypes.DANGER_OTHER || def == BlockPathTypes.DAMAGE_FIRE || def == BlockPathTypes.DANGER_POWDER_SNOW) {
                return BlockPathTypes.BLOCKED;
            }
            return CorrodentEntity.isSafeDig(level, pos) && pos.m_123342_() > level.m_141937_() ? BlockPathTypes.WALKABLE : BlockPathTypes.BLOCKED;
        }
    }
}

