/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.AbstractMovingBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MovingBlockData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PlayMessages;

public class CrushedBlockEntity
extends AbstractMovingBlockEntity {
    private static final EntityDataAccessor<Float> CRUSH_PROGRESS = SynchedEntityData.m_135353_(CrushedBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DROP_CHANCE = SynchedEntityData.m_135353_(CrushedBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float prevCrushProgress = 0.0f;
    private float crushProgress = 0.0f;
    private boolean droppedItems = false;

    public CrushedBlockEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public CrushedBlockEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.CRUSHED_BLOCK.get(), level);
        this.m_20011_(this.m_142242_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CRUSH_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DROP_CHANCE, (Object)Float.valueOf(1.0f));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.crushProgress = compound.m_128457_("CrushProgress");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("CrushProgress", this.crushProgress);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevCrushProgress = this.crushProgress;
        if (this.crushProgress >= 1.0f) {
            BlockPos pos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20191_().f_82292_, (double)this.m_20189_());
            if (!this.m_9236_().f_46443_ && !this.droppedItems) {
                for (MovingBlockData dataBlock : this.getData()) {
                    BlockPos offset = dataBlock.getOffset();
                    if (!(this.m_9236_().f_46441_.m_188501_() < this.getDropChance())) continue;
                    BlockPos dropAtPos = pos.m_121955_((Vec3i)offset);
                    while (this.m_9236_().m_8055_(dropAtPos).m_60795_() && dropAtPos.m_123342_() > this.m_9236_().m_141937_()) {
                        dropAtPos = dropAtPos.m_7495_();
                    }
                    this.createBlockDropAt(dropAtPos.m_7494_(), dataBlock.getState(), dataBlock.blockData);
                }
                this.droppedItems = true;
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_20096_()) {
            this.crushProgress = Math.min(this.crushProgress + 0.334f, 1.0f);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -1.0, 0.0));
        }
    }

    public float getCrushProgress(float partialTick) {
        return this.prevCrushProgress + (this.crushProgress - this.prevCrushProgress) * partialTick;
    }

    protected float getDropChance() {
        return ((Float)this.f_19804_.m_135370_(DROP_CHANCE)).floatValue();
    }

    public void setDropChance(float f) {
        this.f_19804_.m_135381_(DROP_CHANCE, (Object)Float.valueOf(f));
    }

    @Override
    public boolean canBePlaced() {
        return false;
    }

    @Override
    public boolean movesEntities() {
        return false;
    }
}

