/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class LicowitchModel
extends AdvancedEntityModel<LicowitchEntity>
implements ArmedModel {
    private final AdvancedModelBox main;
    private final AdvancedModelBox body;
    private final AdvancedModelBox dress;
    private final AdvancedModelBox head;
    private final AdvancedModelBox nose;
    private final AdvancedModelBox hat;
    private final AdvancedModelBox hat2;
    private final AdvancedModelBox hat3;
    private final AdvancedModelBox hat4;
    private final AdvancedModelBox arms;
    private final AdvancedModelBox armsCrossed;
    private final AdvancedModelBox left_Arm;
    private final AdvancedModelBox left_Hand;
    private final AdvancedModelBox right_Arm;
    private final AdvancedModelBox right_Hand;
    private final AdvancedModelBox right_Leg;
    private final AdvancedModelBox left_Leg;
    private final ModelAnimator animator;

    public LicowitchModel() {
        this.texWidth = 64;
        this.texHeight = 128;
        this.main = new AdvancedModelBox((AdvancedEntityModel)this);
        this.main.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, -14.0f, 0.75f);
        this.main.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(16, 20).addBox(-4.0f, -10.0f, -3.75f, 8.0f, 12.0f, 6.0f, 0.0f, false);
        this.body.setTextureOffset(0, 38).addBox(-4.0f, -10.0f, -3.75f, 8.0f, 18.0f, 6.0f, 0.5f, false);
        this.dress = new AdvancedModelBox((AdvancedEntityModel)this);
        this.dress.setRotationPoint(0.0f, -1.0f, -2.5f);
        this.body.addChild((BasicModelPart)this.dress);
        this.dress.setTextureOffset(9, 105).addBox(-8.0f, 0.0f, -1.5f, 16.0f, 12.0f, 11.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -10.0f, -0.75f);
        this.body.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, 0.0f, false);
        this.head.setTextureOffset(30, 61).addBox(-5.0f, -4.0f, -1.0f, 10.0f, 6.0f, 7.0f, 0.0f, false);
        this.nose = new AdvancedModelBox((AdvancedEntityModel)this);
        this.nose.setRotationPoint(0.0f, -3.0f, -4.0f);
        this.head.addChild((BasicModelPart)this.nose);
        this.nose.setTextureOffset(24, 0).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 5.0f, 2.0f, 0.0f, false);
        this.nose.setTextureOffset(0, 0).addBox(0.0f, 2.0f, -2.75f, 1.0f, 1.0f, 1.0f, -0.25f, false);
        this.nose.setTextureOffset(0, 0).addBox(-1.25f, -0.25f, -2.25f, 1.0f, 1.0f, 1.0f, 0.0f, false);
        this.hat = new AdvancedModelBox((AdvancedEntityModel)this);
        this.hat.setRotationPoint(0.0f, -7.05f, 0.0f);
        this.head.addChild((BasicModelPart)this.hat);
        this.hat.setTextureOffset(0, 75).addBox(-8.0f, -3.0f, -8.0f, 16.0f, 2.0f, 16.0f, 0.0f, false);
        this.hat2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.hat2.setRotationPoint(0.3571f, -3.0609f, 0.7114f);
        this.hat.addChild((BasicModelPart)this.hat2);
        this.setRotateAngle(this.hat2, -0.0524f, 0.0f, 0.0262f);
        this.hat2.setTextureOffset(0, 63).addBox(-3.5524f, -4.4966f, -3.6046f, 7.0f, 5.0f, 7.0f, 0.0f, false);
        this.hat2.setTextureOffset(0, 93).addBox(-3.5524f, -4.4966f, -3.6046f, 7.0f, 5.0f, 7.0f, 0.25f, false);
        this.hat3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.hat3.setRotationPoint(0.4651f, -4.1322f, 0.9235f);
        this.hat2.addChild((BasicModelPart)this.hat3);
        this.setRotateAngle(this.hat3, -0.1047f, 0.0f, 0.0524f);
        this.hat3.setTextureOffset(0, 75).addBox(-2.1047f, -4.4863f, -2.2088f, 4.0f, 5.0f, 4.0f, 0.0f, false);
        this.hat4 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.hat4.setRotationPoint(0.724f, -4.5446f, 1.4457f);
        this.hat3.addChild((BasicModelPart)this.hat4);
        this.setRotateAngle(this.hat4, -0.2094f, 0.0f, 0.1047f);
        this.hat4.setTextureOffset(0, 84).addBox(-0.6045f, -2.4728f, -0.7068f, 1.0f, 3.0f, 1.0f, 0.25f, false);
        this.arms = new AdvancedModelBox((AdvancedEntityModel)this);
        this.arms.setRotationPoint(0.0f, -8.0f, -0.75f);
        this.body.addChild((BasicModelPart)this.arms);
        this.setRotateAngle(this.arms, -0.7854f, 0.0f, 0.0f);
        this.armsCrossed = new AdvancedModelBox((AdvancedEntityModel)this);
        this.armsCrossed.setRotationPoint(0.0f, 4.0f, 0.0f);
        this.arms.addChild((BasicModelPart)this.armsCrossed);
        this.armsCrossed.setTextureOffset(40, 38).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 4.0f, 4.0f, 0.0f, false);
        this.left_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Arm.setRotationPoint(4.0f, 0.0f, 0.0f);
        this.arms.addChild((BasicModelPart)this.left_Arm);
        this.left_Arm.setTextureOffset(44, 22).addBox(0.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, 0.0f, false);
        this.left_Arm.setTextureOffset(28, 42).addBox(0.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, 0.5f, false);
        this.left_Hand = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Hand.setRotationPoint(2.0f, 8.0f, 0.0f);
        this.left_Arm.addChild((BasicModelPart)this.left_Hand);
        this.left_Hand.setTextureOffset(32, 10).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f, false);
        this.right_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Arm.setRotationPoint(-4.0f, 0.0f, 0.0f);
        this.arms.addChild((BasicModelPart)this.right_Arm);
        this.right_Arm.setTextureOffset(44, 22).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, 0.0f, true);
        this.right_Arm.setTextureOffset(28, 42).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, 0.5f, true);
        this.right_Hand = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Hand.setRotationPoint(-2.0f, 8.0f, 0.0f);
        this.right_Arm.addChild((BasicModelPart)this.right_Hand);
        this.right_Hand.setTextureOffset(32, 10).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f, true);
        this.right_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Leg.setRotationPoint(-2.0f, 2.0f, -0.75f);
        this.body.addChild((BasicModelPart)this.right_Leg);
        this.right_Leg.setTextureOffset(48, 75).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.25f, true);
        this.right_Leg.setTextureOffset(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
        this.left_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Leg.setRotationPoint(2.0f, 2.0f, -0.75f);
        this.body.addChild((BasicModelPart)this.left_Leg);
        this.left_Leg.setTextureOffset(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
        this.left_Leg.setTextureOffset(48, 75).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.25f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.main, (Object)this.body, (Object)this.left_Leg, (Object)this.right_Leg, (Object)this.dress, (Object)this.head, (Object)this.nose, (Object)this.hat, (Object)this.hat2, (Object)this.hat3, (Object)this.hat4, (Object)this.arms, (Object[])new AdvancedModelBox[]{this.armsCrossed, this.left_Arm, this.right_Arm, this.left_Hand, this.right_Hand});
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.main);
    }

    public void animate(LicowitchEntity entity) {
        boolean left = entity.m_5737_() == HumanoidArm.LEFT;
        this.animator.update((IAnimatedEntity)entity);
        this.animator.setAnimation(LicowitchEntity.ANIMATION_SWING_RIGHT);
        this.animator.startKeyframe(2);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(25.0), (float)Math.toRadians(-15.0), 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-90.0), (float)Math.toRadians(15.0), (float)Math.toRadians(-25.0));
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(1);
        this.animator.resetKeyframe(3);
        this.animator.setAnimation(LicowitchEntity.ANIMATION_SWING_LEFT);
        this.animator.startKeyframe(2);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(25.0), (float)Math.toRadians(15.0), 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-90.0), (float)Math.toRadians(-15.0), (float)Math.toRadians(25.0));
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(1);
        this.animator.resetKeyframe(3);
        this.animator.setAnimation(LicowitchEntity.ANIMATION_EAT);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.head, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.nose, (float)Math.toRadians(-55.0), 0.0f, 0.0f);
        this.animator.move(this.nose, 0.0f, 0.0f, 2.0f);
        this.animator.move(this.arms, 0.0f, 2.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(80);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(LicowitchEntity.ANIMATION_SPELL_0);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.head, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-20.0), (float)Math.toRadians(40.0), (float)Math.toRadians(40.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-20.0), (float)Math.toRadians(-40.0), (float)Math.toRadians(-40.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.rotate(this.head, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-90.0), (float)Math.toRadians(-10.0), (float)Math.toRadians(-35.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-90.0), (float)Math.toRadians(10.0), (float)Math.toRadians(35.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.animator.rotate(this.body, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(25.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(25.0), 0.0f, 0.0f);
        this.animator.rotate(this.dress, (float)Math.toRadians(25.0), 0.0f, 0.0f);
        this.animator.move(this.body, 0.0f, 1.0f, 1.0f);
        this.animator.move(this.dress, 0.0f, 0.0f, -2.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-50.0), (float)Math.toRadians(-10.0), (float)Math.toRadians(-35.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-50.0), (float)Math.toRadians(10.0), (float)Math.toRadians(35.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(25.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-35.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.dress, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.getArmCube((LivingEntity)entity), (float)Math.toRadians(-100.0), (float)Math.toRadians(left ? -10.0 : 10.0), (float)Math.toRadians(left ? 35.0 : -35.0));
        this.animator.move(this.getArmCube((LivingEntity)entity), 0.0f, 0.0f, -2.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(10);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(LicowitchEntity.ANIMATION_SPELL_1);
        this.animator.startKeyframe(20);
        this.animator.rotate(this.head, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-20.0), (float)Math.toRadians(40.0), (float)Math.toRadians(40.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-20.0), (float)Math.toRadians(-40.0), (float)Math.toRadians(-40.0));
        this.animator.move(this.body, 0.0f, -2.0f, 1.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(65.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-75.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.dress, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.getArmCube((LivingEntity)entity), (float)Math.toRadians(-115.0), (float)Math.toRadians(left ? -10.0 : 10.0), (float)Math.toRadians(left ? 35.0 : -35.0));
        this.animator.move(this.getArmCube((LivingEntity)entity), 0.0f, 0.0f, -2.0f);
        this.animator.move(this.body, 0.0f, -2.0f, 1.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(10);
        this.animator.resetKeyframe(10);
    }

    public void setupAnim(LicowitchEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float animationIntensity;
        this.resetToDefaultPose();
        this.animate(entity);
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float unfurlArmsProgress = entity.getArmsUncrossedProgress(partialTicks);
        float teleportingProgress = Math.min(entity.getTeleportingProgress(partialTicks) * 5.0f, 1.0f) * unfurlArmsProgress;
        boolean crossedArms = entity.areArmsVisuallyCrossed(partialTicks);
        float walkSpeed = 0.5f;
        float walkDegree = 0.8f;
        this.progressPositionPrev(this.dress, limbSwingAmount, 0.0f, -0.5f, -3.0f, 1.0f);
        this.progressRotationPrev(this.dress, limbSwingAmount, (float)Math.toRadians(10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.left_Arm, unfurlArmsProgress, (float)Math.toRadians(40.0), (float)Math.toRadians(20.0), (float)Math.toRadians(-20.0), 1.0f);
        this.progressRotationPrev(this.right_Arm, unfurlArmsProgress, (float)Math.toRadians(40.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(20.0), 1.0f);
        this.progressPositionPrev(this.left_Arm, teleportingProgress, 0.0f, -2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.right_Arm, teleportingProgress, 0.0f, -2.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, teleportingProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.left_Arm, teleportingProgress, (float)Math.toRadians(-160.0), (float)Math.toRadians(-40.0), (float)Math.toRadians(40.0), 1.0f);
        this.progressRotationPrev(this.right_Arm, teleportingProgress, (float)Math.toRadians(-160.0), (float)Math.toRadians(40.0), (float)Math.toRadians(-40.0), 1.0f);
        this.flap(this.nose, 0.035f, 0.08f, false, -1.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.nose, 0.035f, 0.08f, false, 0.0f, -0.08f, ageInTicks, 1.0f);
        this.flap(this.left_Arm, 0.1f, 0.1f, false, 0.0f, -0.15f, ageInTicks, unfurlArmsProgress);
        this.flap(this.right_Arm, 0.1f, 0.1f, true, 0.0f, -0.15f, ageInTicks, unfurlArmsProgress);
        this.armsCrossed.showModel = crossedArms;
        this.left_Hand.showModel = !crossedArms;
        this.right_Hand.showModel = !crossedArms;
        this.head.rotateAngleY += netHeadYaw * ((float)Math.PI / 180);
        this.head.rotateAngleX += headPitch * ((float)Math.PI / 180);
        this.walk(this.left_Leg, walkSpeed, walkDegree, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.right_Leg, walkSpeed, walkDegree, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.left_Arm, walkSpeed, walkDegree, true, 0.0f, 0.3f, limbSwing, limbSwingAmount * unfurlArmsProgress);
        this.walk(this.right_Arm, walkSpeed, walkDegree, false, 0.0f, -0.3f, limbSwing, limbSwingAmount * unfurlArmsProgress);
        this.swing(this.dress, walkSpeed, walkDegree * 0.1f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.body, walkSpeed, walkDegree * 0.05f, true, 2.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.head, walkSpeed, walkDegree * 0.05f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.left_Arm, 0.5f, 0.5f, true, 0.0f, 0.0f, ageInTicks, teleportingProgress);
        this.walk(this.right_Arm, 0.5f, 0.5f, false, 0.0f, 0.0f, ageInTicks, teleportingProgress);
        this.body.rotationPointY += teleportingProgress * (-5.0f - ACMath.walkValue(ageInTicks, 1.0f, 0.25f, 0.0f, 4.0f, false));
        float f = -Math.min(this.left_Leg.rotateAngleX, this.right_Leg.rotateAngleX);
        this.dress.rotationPointZ -= f * 1.5f;
        this.dress.setScale(1.0f, 1.0f, 1.0f + limbSwingAmount * 0.33f);
        float runWalkBob = -Math.abs(ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, 1.0f, 1.0f, false));
        this.body.rotationPointY += runWalkBob;
        this.left_Leg.rotationPointY -= runWalkBob;
        this.right_Leg.rotationPointY -= runWalkBob;
        this.dress.rotationPointY -= runWalkBob;
        if (entity.getAnimation() == LicowitchEntity.ANIMATION_EAT) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 4.0f, LicowitchEntity.ANIMATION_EAT, partialTicks, 0);
            this.walk(this.head, 0.75f, 0.1f, false, 0.0f, 0.2f, ageInTicks, animationIntensity);
            this.walk(this.arms, 0.75f, 0.3f, true, 1.0f, 0.2f, ageInTicks, animationIntensity);
        }
        if (entity.getAnimation() == LicowitchEntity.ANIMATION_SPELL_0) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 2.0f, LicowitchEntity.ANIMATION_SPELL_0, partialTicks, 18, 25);
            AdvancedModelBox arm = this.getArmCube((LivingEntity)entity);
            arm.rotationPointZ = (float)((double)arm.rotationPointZ + (double)animationIntensity * Math.sin(ageInTicks * 2.0f));
            this.walk(arm, 1.0f, 0.1f, false, 0.0f, -0.1f, ageInTicks, animationIntensity);
        }
        if (entity.getAnimation() == LicowitchEntity.ANIMATION_SPELL_1) {
            float animationIntensity1 = ACMath.cullAnimationTick(entity.getAnimationTick(), 3.0f, LicowitchEntity.ANIMATION_SPELL_1, partialTicks, 0, 40);
            float animationIntensity2 = ACMath.cullAnimationTick(entity.getAnimationTick(), 3.0f, LicowitchEntity.ANIMATION_SPELL_1, partialTicks, 25, 25);
            this.walk(this.left_Leg, 0.3f, 0.2f, false, 0.0f, 0.0f, ageInTicks, animationIntensity1);
            this.walk(this.right_Leg, 0.3f, 0.2f, true, 0.0f, 0.0f, ageInTicks, animationIntensity1);
            this.walk(this.body, 0.2f, 0.1f, true, 1.0f, 0.0f, ageInTicks, animationIntensity1);
            this.bob(this.body, 0.4f, 2.0f, false, ageInTicks, animationIntensity1);
            AdvancedModelBox arm = this.getArmCube((LivingEntity)entity);
            arm.rotationPointZ = (float)((double)arm.rotationPointZ + (double)animationIntensity2 * Math.sin(ageInTicks * 2.0f));
            this.walk(arm, 1.0f, 0.1f, false, 0.0f, -0.1f, ageInTicks, animationIntensity2);
        }
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.main.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        this.arms.translateAndRotate(poseStack);
        if (humanoidArm == HumanoidArm.RIGHT) {
            this.right_Arm.translateAndRotate(poseStack);
            this.right_Hand.translateAndRotate(poseStack);
        } else {
            this.left_Arm.translateAndRotate(poseStack);
            this.left_Hand.translateAndRotate(poseStack);
        }
    }

    public void translateToCrossedArms(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.main.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        this.arms.translateAndRotate(poseStack);
        this.armsCrossed.translateAndRotate(poseStack);
    }

    private AdvancedModelBox getArmCube(LivingEntity living) {
        return living.m_5737_() == HumanoidArm.LEFT ? this.left_Arm : this.right_Arm;
    }
}

