/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.GingerbreadManEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.world.entity.HumanoidArm;

public class GingerbreadManModel
extends AdvancedEntityModel<GingerbreadManEntity>
implements ArmedModel {
    private final AdvancedModelBox main;
    private final AdvancedModelBox body;
    private final AdvancedModelBox head;
    private final AdvancedModelBox left_Leg;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox right_Leg;
    private final AdvancedModelBox cube_r2;
    private final AdvancedModelBox right_Arm;
    private final AdvancedModelBox left_Arm;
    private ModelAnimator animator;

    public GingerbreadManModel() {
        this.texWidth = 32;
        this.texHeight = 32;
        this.main = new AdvancedModelBox((AdvancedEntityModel)this);
        this.main.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, -6.5f, -1.0f);
        this.main.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(14, 14).addBox(-2.5f, -2.5f, -1.0f, 5.0f, 5.0f, 2.0f, 0.26f, false);
        this.body.setTextureOffset(0, 16).addBox(-2.5f, -2.5f, -1.0f, 5.0f, 5.0f, 2.0f, 0.01f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -2.5f, 0.0f);
        this.body.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(0, 8).addBox(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 2.0f, 0.02f, false);
        this.head.setTextureOffset(0, 23).addBox(3.0f, -5.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.02f, false);
        this.head.setTextureOffset(0, 23).addBox(-5.0f, -5.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.02f, true);
        this.head.setTextureOffset(13, 28).addBox(-5.0f, -5.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.02f, true);
        this.head.setTextureOffset(13, 28).addBox(3.0f, -5.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.02f, false);
        this.head.setTextureOffset(0, 0).addBox(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 2.0f, 0.27f, false);
        this.left_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Leg.setRotationPoint(2.0f, 1.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.left_Leg);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(-1.0f, -1.0f, 0.0f);
        this.left_Leg.addChild((BasicModelPart)this.cube_r1);
        this.setRotateAngle(this.cube_r1, 0.0f, 0.0f, -0.3927f);
        this.cube_r1.setTextureOffset(20, 21).addBox(-1.5f, 1.5f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, false);
        this.cube_r1.setTextureOffset(12, 21).addBox(-1.5f, 1.5f, -1.0f, 2.0f, 5.0f, 2.0f, 0.25f, false);
        this.right_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Leg.setRotationPoint(-2.0f, 1.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.right_Leg);
        this.cube_r2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r2.setRotationPoint(1.0f, -1.0f, 0.0f);
        this.right_Leg.addChild((BasicModelPart)this.cube_r2);
        this.setRotateAngle(this.cube_r2, 0.0f, 0.0f, 0.3927f);
        this.cube_r2.setTextureOffset(20, 21).addBox(-0.5f, 1.5f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, true);
        this.cube_r2.setTextureOffset(12, 21).addBox(-0.5f, 1.5f, -1.0f, 2.0f, 5.0f, 2.0f, 0.25f, true);
        this.right_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Arm.setRotationPoint(-2.75f, -1.5f, 0.0f);
        this.body.addChild((BasicModelPart)this.right_Arm);
        this.right_Arm.setTextureOffset(14, 6).addBox(-3.75f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, 0.25f, true);
        this.right_Arm.setTextureOffset(16, 0).addBox(-3.75f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, 0.0f, true);
        this.left_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Arm.setRotationPoint(2.75f, -1.5f, 0.0f);
        this.body.addChild((BasicModelPart)this.left_Arm);
        this.left_Arm.setTextureOffset(14, 6).addBox(-0.25f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, 0.25f, false);
        this.left_Arm.setTextureOffset(16, 0).addBox(-0.25f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, 0.0f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.main);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.main, (Object)this.body, (Object)this.head, (Object)this.left_Arm, (Object)this.left_Leg, (Object)this.cube_r1, (Object)this.cube_r2, (Object)this.right_Arm, (Object)this.right_Leg);
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(GingerbreadManEntity.ANIMATION_IDLE_WAVE_LEFT);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), (float)Math.toRadians(-40.0), 0.0f);
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(-40.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(20);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), (float)Math.toRadians(40.0), 0.0f);
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(-40.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GingerbreadManEntity.ANIMATION_IDLE_WAVE_RIGHT);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), (float)Math.toRadians(40.0), 0.0f);
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(40.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(20);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), (float)Math.toRadians(-40.0), 0.0f);
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(40.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GingerbreadManEntity.ANIMATION_IDLE_FALL_OVER);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(-90.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Arm, 0.0f, (float)Math.toRadians(30.0), (float)Math.toRadians(-30.0));
        this.animator.rotate(this.right_Arm, 0.0f, (float)Math.toRadians(-30.0), (float)Math.toRadians(30.0));
        this.animator.move(this.body, 0.0f, 5.0f, 7.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(25);
        this.animator.resetKeyframe(20);
        this.animator.setAnimation(GingerbreadManEntity.ANIMATION_IDLE_JUMP);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 1.0f, 0.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(-40.0));
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(40.0));
        this.animator.rotate(this.right_Leg, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.left_Leg, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, -1.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(40.0));
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(40.0));
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(-20.0), 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(20.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GingerbreadManEntity.ANIMATION_SWING_RIGHT);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(30.0), 0.0f);
        this.animator.rotate(this.left_Leg, 0.0f, 0.0f, (float)Math.toRadians(15.0));
        this.animator.rotate(this.right_Leg, 0.0f, 0.0f, (float)Math.toRadians(-15.0));
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(35.0));
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-25.0), (float)Math.toRadians(15.0), (float)Math.toRadians(15.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(35.0));
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(35.0), (float)Math.toRadians(15.0), (float)Math.toRadians(-45.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GingerbreadManEntity.ANIMATION_SWING_LEFT);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.left_Leg, 0.0f, 0.0f, (float)Math.toRadians(15.0));
        this.animator.rotate(this.right_Leg, 0.0f, 0.0f, (float)Math.toRadians(-15.0));
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(-35.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-25.0), (float)Math.toRadians(-15.0), (float)Math.toRadians(-15.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(30.0), 0.0f);
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(-35.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(35.0), (float)Math.toRadians(-15.0), (float)Math.toRadians(45.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.resetKeyframe(5);
    }

    public void setupAnim(GingerbreadManEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        this.left_Arm.showModel = !entity.hasLostLimb(true, true);
        this.right_Arm.showModel = !entity.hasLostLimb(false, true);
        this.left_Leg.showModel = !entity.hasLostLimb(true, false);
        this.right_Leg.showModel = !entity.hasLostLimb(false, false);
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float walkSpeed = 0.6f;
        float walkDegree = 1.0f;
        float sitProgress = entity.getSitProgress(partialTicks);
        float danceProgress = entity.getDanceProgress(partialTicks);
        float carryItemProgress = entity.getCarryItemProgress(partialTicks);
        float invCarryItemProgress = 1.0f - carryItemProgress;
        this.head.rotateAngleY += netHeadYaw / 57.295776f;
        this.head.rotateAngleX += headPitch / 57.295776f;
        if (entity.getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            this.setupAnimForAnimation(entity, entity.getAnimation(), limbSwing, limbSwingAmount, ageInTicks);
        }
        this.flap(this.right_Arm, 0.1f, 0.1f, true, -1.0f, 0.0f, ageInTicks, 1.0f);
        this.flap(this.left_Arm, 0.1f, 0.1f, false, -1.0f, 0.0f, ageInTicks, 1.0f);
        this.progressRotationPrev(this.left_Leg, sitProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(10.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.right_Leg, sitProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(-10.0), 0.0f, 1.0f);
        if (!entity.hasBothLegs()) {
            this.progressRotationPrev(this.left_Leg, 1.0f, 0.0f, 0.0f, (float)Math.toRadians(20.0), 1.0f);
            this.progressRotationPrev(this.right_Leg, 1.0f, 0.0f, 0.0f, (float)Math.toRadians(-20.0), 1.0f);
        }
        this.progressPositionPrev(this.left_Leg, sitProgress, 0.0f, 1.0f, 1.0f, 1.0f);
        this.progressPositionPrev(this.right_Leg, sitProgress, 0.0f, 1.0f, 1.0f, 1.0f);
        this.progressPositionPrev(this.body, sitProgress, 0.0f, 4.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, carryItemProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.right_Arm, carryItemProgress, 0.0f, (float)Math.toRadians(-100.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.left_Arm, carryItemProgress, 0.0f, (float)Math.toRadians(100.0), 0.0f, 1.0f);
        this.swing(this.body, walkSpeed, walkDegree * 0.2f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.head, walkSpeed, walkDegree * 0.4f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.head, walkSpeed, walkDegree * 0.4f, true, 1.0f, 0.2f, limbSwing, limbSwingAmount);
        this.walk(this.left_Leg, walkSpeed, walkDegree, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.left_Leg, walkSpeed, walkDegree * 0.3f, true, 0.0f, -0.15f, limbSwing, limbSwingAmount);
        this.walk(this.right_Leg, walkSpeed, walkDegree, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.right_Leg, walkSpeed, walkDegree * 0.3f, false, 0.0f, -0.15f, limbSwing, limbSwingAmount);
        this.swing(this.left_Arm, walkSpeed, walkDegree, false, 1.0f, 0.0f, limbSwing, limbSwingAmount * invCarryItemProgress);
        this.swing(this.right_Arm, walkSpeed, walkDegree, false, 1.0f, 0.0f, limbSwing, limbSwingAmount * invCarryItemProgress);
        this.flap(this.left_Arm, walkSpeed, walkDegree, false, 1.0f, 0.0f, limbSwing, limbSwingAmount * invCarryItemProgress);
        this.flap(this.right_Arm, walkSpeed, walkDegree, false, 1.0f, 0.0f, limbSwing, limbSwingAmount * invCarryItemProgress);
        this.body.rotationPointY -= Math.abs((float)(Math.cos(limbSwing * walkSpeed - 0.5f) * (double)walkDegree * 4.0 * (double)limbSwingAmount));
        this.flap(this.right_Arm, 1.0f, 0.7f, false, -1.0f, 0.3f, ageInTicks, danceProgress);
        this.flap(this.left_Arm, 1.0f, 0.7f, true, -1.0f, 0.3f, ageInTicks, danceProgress);
        this.walk(this.head, 1.0f, 0.5f, true, -2.0f, 0.0f, ageInTicks, danceProgress);
        this.swing(this.head, 1.0f, 0.5f, true, -1.0f, 0.0f, ageInTicks, danceProgress);
        this.swing(this.body, 1.0f, 0.15f, true, -3.0f, 0.0f, ageInTicks, danceProgress);
    }

    private void setupAnimForAnimation(GingerbreadManEntity entity, Animation animation, float limbSwing, float limbSwingAmount, float ageInTicks) {
        float animationIntensity;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        if (animation == GingerbreadManEntity.ANIMATION_IDLE_WAVE_LEFT) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 3.0f, animation, partialTick, 0, 30);
            this.flap(this.left_Arm, 1.25f, 0.5f, false, 1.0f, -0.5f, ageInTicks, animationIntensity);
        }
        if (animation == GingerbreadManEntity.ANIMATION_IDLE_WAVE_RIGHT) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 3.0f, animation, partialTick, 0, 30);
            this.flap(this.right_Arm, 1.25f, 0.5f, false, 1.0f, 0.5f, ageInTicks, animationIntensity);
        }
        if (animation == GingerbreadManEntity.ANIMATION_IDLE_FALL_OVER) {
            float animationIntensity1 = ACMath.cullAnimationTick(entity.getAnimationTick(), 2.0f, animation, partialTick, 5, 25);
            this.swing(this.left_Arm, 1.25f, 0.5f, false, 1.0f, -0.5f, ageInTicks, animationIntensity1);
            this.swing(this.right_Arm, 1.25f, 0.5f, false, 1.0f, 0.5f, ageInTicks, animationIntensity1);
            float animationIntensity2 = ACMath.cullAnimationTick(entity.getAnimationTick(), 4.0f, animation, partialTick, 20, 30);
            this.walk(this.left_Leg, 0.7f, 0.6f, false, 1.0f, 0.0f, ageInTicks, animationIntensity2);
            this.walk(this.right_Leg, 0.7f, 0.6f, true, 1.0f, 0.0f, ageInTicks, animationIntensity2);
        }
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.main.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        if (humanoidArm == HumanoidArm.LEFT) {
            this.left_Arm.translateAndRotate(poseStack);
        } else {
            this.right_Arm.translateAndRotate(poseStack);
        }
    }
}

