/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.elysium_api;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.jadenxgamer.elysium_api.impl.biome.ElysiumBiomeHelper;
import net.jadenxgamer.elysium_api.impl.biome.ElysiumBiomeSource;
import net.jadenxgamer.elysium_api.impl.registry.ElysiumFeature;
import net.jadenxgamer.elysium_api.impl.registry.ElysiumRegistries;
import net.jadenxgamer.elysium_api.impl.use_behavior.UseBehaviorImpl;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="elysium_api")
public class Elysium {
    public static final String MOD_ID = "elysium_api";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static RegistryAccess registryAccess;

    public Elysium() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ElysiumRegistries::datapackRegistry);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::rightClickBlock);
        ElysiumFeature.init(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        registryAccess = event.getServer().m_206579_();
        Elysium.addDataDrivenPossibleBiomes();
        Registry levelStems = registryAccess.m_175515_(Registries.f_256862_);
        for (ResourceKey dimension : levelStems.m_214010_()) {
            BiomeSource biomeSource;
            Optional optionalLevelStem = levelStems.m_203636_(dimension);
            if (!optionalLevelStem.isPresent() || !((biomeSource = ((LevelStem)((Holder.Reference)optionalLevelStem.get()).m_203334_()).f_63976_().m_62218_()) instanceof ElysiumBiomeSource)) continue;
            ElysiumBiomeSource biomeSource2 = (ElysiumBiomeSource)biomeSource;
            if (dimension.equals((Object)LevelStem.f_63971_)) {
                biomeSource2.setDimension((ResourceKey<LevelStem>)LevelStem.f_63971_);
                biomeSource2.addPossibleBiomes(ElysiumBiomeHelper.overworldPossibleBiomes);
                biomeSource2.setWorldSeed(event.getServer().m_129910_().m_246337_().m_245499_());
                continue;
            }
            if (!dimension.equals((Object)LevelStem.f_63972_)) continue;
            biomeSource2.setDimension((ResourceKey<LevelStem>)LevelStem.f_63972_);
            biomeSource2.addPossibleBiomes(ElysiumBiomeHelper.netherPossibleBiomes);
            biomeSource2.setWorldSeed(event.getServer().m_129910_().m_246337_().m_245499_());
        }
    }

    private void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        UseBehaviorImpl.init(event);
    }

    private static void addDataDrivenPossibleBiomes() {
        Registry biomeReplacer = registryAccess.m_175515_(ElysiumRegistries.BIOME_REPLACER);
        biomeReplacer.m_123024_().forEach(replacer -> {
            if (replacer.dimension().equals((Object)new ResourceLocation("minecraft", "overworld"))) {
                ElysiumBiomeHelper.overworldPossibleBiomes.add(replacer.withBiome());
            } else if (replacer.dimension().equals((Object)new ResourceLocation("minecraft", "the_nether"))) {
                ElysiumBiomeHelper.netherPossibleBiomes.add(replacer.withBiome());
            }
        });
    }

    @Mod.EventBusSubscriber(modid="elysium_api", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

