/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class SaturationTracker {
    private static final int[] FEEDING_THRESHOLDS = new int[]{5, 10, 15, 20};
    private int level = 0;
    private int foodCounter = 0;
    private long lastFedTick = -1L;
    private int decayDelay = -1;

    public void tryFeed(Animal animal, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!animal.m_6898_(stack) || animal.m_6162_()) {
            return;
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        ++this.foodCounter;
        this.lastFedTick = animal.f_19797_;
        this.decayDelay = 2400 + animal.m_217043_().m_188503_(2400);
        if (this.level < 4 && this.foodCounter >= FEEDING_THRESHOLDS[this.level]) {
            ++this.level;
            this.foodCounter = 0;
        }
    }

    public void tick(Animal animal) {
        if (this.lastFedTick == -1L || this.decayDelay == -1) {
            return;
        }
        if ((long)animal.f_19797_ - this.lastFedTick >= (long)this.decayDelay) {
            if (this.foodCounter > 0) {
                --this.foodCounter;
            } else if (this.level > 0) {
                --this.level;
                this.foodCounter = FEEDING_THRESHOLDS[Math.max(0, this.level - 1)] - 1;
            }
            this.lastFedTick = animal.f_19797_;
            this.decayDelay = 2400 + animal.m_217043_().m_188503_(2400);
        }
    }

    public void dropExtraLoot(Animal animal, DamageSource source) {
        int bonusRolls;
        Level level = animal.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        switch (this.level) {
            case 1: {
                int n = 1;
                break;
            }
            case 2: {
                int n = 1 + animal.m_217043_().m_188503_(2);
                break;
            }
            case 3: {
                int n = 2 + animal.m_217043_().m_188503_(2);
                break;
            }
            case 4: {
                int n = 3;
                break;
            }
            default: {
                int n = bonusRolls = 0;
            }
        }
        if (bonusRolls == 0) {
            return;
        }
        LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)animal).m_287286_(LootContextParams.f_81460_, (Object)animal.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)source);
        LootTable table = serverLevel.m_7654_().m_278653_().m_278676_(animal.m_5743_());
        for (int i = 0; i < bonusRolls; ++i) {
            ObjectArrayList loot = table.m_287195_(builder.m_287235_(LootContextParamSets.f_81415_));
            for (ItemStack stack : loot) {
                serverLevel.m_7967_((Entity)new ItemEntity((Level)serverLevel, animal.m_20185_(), animal.m_20186_(), animal.m_20189_(), stack));
            }
        }
    }

    public int level() {
        return this.level;
    }

    public int foodCounter() {
        return this.foodCounter;
    }

    public void feedDirectly(Animal animal, int currentTick, int amount) {
        this.foodCounter += amount;
        this.lastFedTick = currentTick;
        this.decayDelay = 2400 + animal.m_217043_().m_188503_(2400);
        while (this.level < 4 && this.foodCounter >= FEEDING_THRESHOLDS[this.level]) {
            this.foodCounter -= FEEDING_THRESHOLDS[this.level];
            ++this.level;
        }
    }

    public int getDecayDelay() {
        return this.decayDelay;
    }

    public void setDecayDelay(int delay) {
        this.decayDelay = delay;
    }

    public long getLastFedTick() {
        return this.lastFedTick;
    }

    public void setLastFedTick(long tick) {
        this.lastFedTick = tick;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setFoodCounter(int count) {
        this.foodCounter = count;
    }

    public void clientSync(int syncedLevel, int syncedFoodCounter) {
        this.level = syncedLevel;
        this.foodCounter = syncedFoodCounter;
    }

    public static interface SaturatedAnimal {
        public SaturationTracker farm_and_charm$getSaturationTracker();

        public void farm_and_charm$setSaturationTracker(SaturationTracker var1);
    }
}

