/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.mixin;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.core.entity.ai.ApproachFeedingTroughGoal;
import net.satisfy.farm_and_charm.core.network.PacketHandler;
import net.satisfy.farm_and_charm.core.network.packet.SyncSaturationPacket;
import net.satisfy.farm_and_charm.core.util.SaturationTracker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Animal.class})
public abstract class AnimalEntityMixin
extends Mob
implements SaturationTracker.SaturatedAnimal {
    @Unique
    private SaturationTracker farm_and_charm$saturation;

    protected AnimalEntityMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public SaturationTracker farm_and_charm$getSaturationTracker() {
        if (this.farm_and_charm$saturation == null) {
            this.farm_and_charm$saturation = new SaturationTracker();
        }
        return this.farm_and_charm$saturation;
    }

    @Override
    public void farm_and_charm$setSaturationTracker(SaturationTracker tracker) {
        this.farm_and_charm$saturation = tracker;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void farm_and_charm$addSelfFeedingGoal(EntityType<? extends Mob> entityType, Level level, CallbackInfo ci) {
        if (!level.f_46443_) {
            this.f_21345_.m_25352_(3, (Goal)new ApproachFeedingTroughGoal((Animal)this, 1.2));
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void farm_and_charm$tickSaturation(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            EntityType type = this.m_6095_();
            if (type != EntityType.f_20557_ && type != EntityType.f_20510_ && type != EntityType.f_20520_ && type != EntityType.f_20555_) {
                return;
            }
            SaturationTracker tracker = this.farm_and_charm$getSaturationTracker();
            tracker.tick((Animal)this);
            SyncSaturationPacket packet = new SyncSaturationPacket(this.m_19879_(), tracker.level(), tracker.foodCounter());
            PacketHandler.sendSaturationSync(packet, (Entity)this);
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void farm_and_charm$injectSaturationFeeding(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        EntityType type = this.m_6095_();
        if (type != EntityType.f_20557_ && type != EntityType.f_20510_ && type != EntityType.f_20520_ && type != EntityType.f_20555_) {
            return;
        }
        Animal animal = (Animal)this;
        ItemStack stack = player.m_21120_(hand);
        if (!animal.m_6898_(stack) || animal.m_6162_()) {
            return;
        }
        if (animal.m_5957_()) {
            return;
        }
        SaturationTracker tracker = this.farm_and_charm$getSaturationTracker();
        tracker.tryFeed(animal, player, hand);
        if (!animal.m_9236_().f_46443_) {
            SyncSaturationPacket packet = new SyncSaturationPacket(this.m_19879_(), tracker.level(), tracker.foodCounter());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketHandler.sendToClient(serverPlayer, packet);
            }
            ((ServerLevel)animal.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, animal.m_20185_(), animal.m_20186_() + 1.0, animal.m_20189_(), 5, 0.2, 0.2, 0.2, 0.05);
        }
        cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)animal.m_9236_().f_46443_));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void farm_and_charm$saveSaturation(CompoundTag tag, CallbackInfo ci) {
        SaturationTracker tracker = this.farm_and_charm$getSaturationTracker();
        CompoundTag trackerTag = new CompoundTag();
        trackerTag.m_128405_("SaturationLevel", tracker.level());
        trackerTag.m_128405_("SaturationCounter", tracker.foodCounter());
        trackerTag.m_128356_("SaturationLastFed", tracker.getLastFedTick());
        trackerTag.m_128405_("SaturationDecayDelay", tracker.getDecayDelay());
        tag.m_128365_("FarmAndCharmSaturation", (Tag)trackerTag);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void farm_and_charm$loadSaturation(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128425_("FarmAndCharmSaturation", 10)) {
            CompoundTag trackerTag = tag.m_128469_("FarmAndCharmSaturation");
            SaturationTracker tracker = new SaturationTracker();
            tracker.setLevel(trackerTag.m_128451_("SaturationLevel"));
            tracker.setFoodCounter(trackerTag.m_128451_("SaturationCounter"));
            tracker.setLastFedTick(trackerTag.m_128454_("SaturationLastFed"));
            tracker.setDecayDelay(trackerTag.m_128451_("SaturationDecayDelay"));
            this.farm_and_charm$setSaturationTracker(tracker);
        }
    }
}

