/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.block.crops.BigCropCapable;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class FertilizerItem
extends Item {
    public FertilizerItem(Item.Properties properties) {
        super(properties.m_41487_(64).m_41503_(10));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (!PlatformHelper.isFertilizerEnabled()) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        boolean applied = false;
        if (!world.f_46443_ && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            ArrayList<BlockPos> potentialPositions = new ArrayList<BlockPos>();
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos blockPos = pos.m_7918_(x, 0, z);
                    if (!world.m_8055_(blockPos).m_204336_(BlockTags.f_13073_) && !world.m_8055_(blockPos).m_204336_(BlockTags.f_13065_)) continue;
                    potentialPositions.add(blockPos);
                }
            }
            Random random = new Random();
            int targets = random.nextInt(5) + 2;
            for (int i = 0; i < targets && !potentialPositions.isEmpty(); ++i) {
                BlockPos targetPos = (BlockPos)potentialPositions.remove(random.nextInt(potentialPositions.size()));
                BlockState blockState = world.m_8055_(targetPos);
                Block block = blockState.m_60734_();
                if (!(block instanceof BonemealableBlock)) continue;
                BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
                Block block2 = blockState.m_60734_();
                if (!(block2 instanceof BigCropCapable)) continue;
                BigCropCapable bigCrop = (BigCropCapable)block2;
                if (bonemealableBlock.m_7370_((LevelReader)world, targetPos, blockState, false) && bonemealableBlock.m_214167_(world, world.f_46441_, targetPos, blockState)) {
                    bonemealableBlock.m_214148_(serverWorld, world.f_46441_, targetPos, blockState);
                }
                BlockState newState = world.m_8055_(targetPos);
                bigCrop.tryTransformToBigCrop(world, targetPos, newState, true);
                applied = true;
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 1.0, (double)targetPos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
                ItemParticleOption sowingParticle = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ObjectRegistry.FERTILIZER.get()));
                serverWorld.m_8767_((ParticleOptions)sowingParticle, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 1.0, (double)targetPos.m_123343_() + 0.5, 125, 0.5, 0.5, 0.5, 0.0);
                world.m_46796_(2005, targetPos, 0);
            }
            if (applied) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
        }
        if (world.f_46443_) {
            Random random = new Random();
            for (int i = 0; i < 100; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * 2.0;
                double offsetY = random.nextDouble();
                double offsetZ = (random.nextDouble() - 0.5) * 2.0;
                double x = (double)pos.m_123341_() + 0.5 + offsetX;
                double y = (double)pos.m_123342_() + 1.0 + offsetY;
                double z = (double)pos.m_123343_() + 0.5 + offsetZ;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 0.0, 0.1, 0.0);
                ItemParticleOption sowingParticle = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ObjectRegistry.FERTILIZER.get()));
                world.m_7106_((ParticleOptions)sowingParticle, x, y, z, 0.0, 0.1, 0.0);
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BRUSH;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }
}

