/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class MeowAtBowlGoal
extends Goal {
    private final Cat cat;
    private BlockPos bowlPos;
    private int meowTicks;
    private long lastCheckTime;
    private boolean active;
    private static final int CHECK_INTERVAL_TICKS = 40;
    private static final int MAX_MEOW_TICKS = 300;
    private static final int MEOW_INTERVAL = 60;
    private static final int ANGRY_PARTICLE_INTERVAL = 100;
    private static final double NAVIGATION_SPEED = 1.0;
    private static final double CLOSE_ENOUGH_DIST = 1.1;
    private static final double LOOK_OFFSET = 0.5;
    private static final long MORNING_START = 5800L;
    private static final long MORNING_END = 6200L;
    private static final long EVENING_START = 11500L;
    private static final long EVENING_END = 12500L;

    public MeowAtBowlGoal(Cat cat) {
        this.cat = cat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.meowTicks = 0;
        this.lastCheckTime = -1L;
        this.active = false;
    }

    public boolean m_8036_() {
        if (!this.cat.m_21824_() || this.cat.m_21827_()) {
            return false;
        }
        Level level = this.cat.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        long gameTime = server.m_46467_();
        if (this.lastCheckTime != -1L && gameTime - this.lastCheckTime < 40L) {
            return false;
        }
        this.lastCheckTime = gameTime;
        long timeOfDay = server.m_46468_() % 24000L;
        if (timeOfDay < 5800L || timeOfDay > 6200L && timeOfDay < 11500L || timeOfDay > 12500L) {
            return false;
        }
        BlockPos catPos = this.cat.m_20183_();
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)catPos.m_7918_(-32, -4, -32), (BlockPos)catPos.m_7918_(32, 4, 32))) {
            double dist;
            PetBowlBlockEntity bowl;
            BlockEntity be;
            if (!level.m_8055_(pos).m_60713_((Block)ObjectRegistry.PET_BOWL.get()) || !level.m_8055_(pos).m_155947_() || !((be = level.m_7702_(pos)) instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).m_7983_() || !bowl.canBeUsedBy((Animal)this.cat) || !((dist = this.cat.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)pos))) < closestDistance)) continue;
            closestDistance = dist;
            closest = pos.m_7949_();
        }
        if (closest != null) {
            this.bowlPos = closest;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        PetBowlBlockEntity bowl;
        if (!this.active || this.meowTicks >= 300 || this.bowlPos == null) {
            return false;
        }
        Level level = this.cat.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        BlockEntity be = server.m_7702_(this.bowlPos);
        return be instanceof PetBowlBlockEntity && (bowl = (PetBowlBlockEntity)be).m_7983_() && bowl.canBeUsedBy((Animal)this.cat);
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        if (this.bowlPos != null) {
            if (!this.isNearBowl()) {
                this.cat.m_21573_().m_26519_((double)this.bowlPos.m_123341_() + 0.5, (double)this.bowlPos.m_123342_(), (double)this.bowlPos.m_123343_() + 0.5, 1.0);
            }
            this.meowTicks = 0;
            this.active = true;
        }
    }

    public void m_8037_() {
        Vec3 pos;
        PetBowlBlockEntity bowl;
        if (this.bowlPos == null) {
            this.m_8041_();
            return;
        }
        Level level = this.cat.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.m_8041_();
            return;
        }
        ServerLevel server = (ServerLevel)level;
        BlockEntity be = server.m_7702_(this.bowlPos);
        if (!(be instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).m_7983_()) {
            this.m_8041_();
            return;
        }
        if (this.isNearBowl()) {
            if (this.cat.m_21573_().m_26572_()) {
                this.cat.m_21573_().m_26573_();
            }
            if (!this.cat.m_21827_()) {
                this.cat.m_21839_(true);
            }
            this.cat.m_21563_().m_24946_((double)this.bowlPos.m_123341_() + 0.5, (double)this.bowlPos.m_123342_() + 0.5, (double)this.bowlPos.m_123343_() + 0.5);
        } else if (!this.cat.m_21573_().m_26572_()) {
            this.cat.m_21573_().m_26519_((double)this.bowlPos.m_123341_() + 0.5, (double)this.bowlPos.m_123342_(), (double)this.bowlPos.m_123343_() + 0.5, 1.0);
        }
        if (this.meowTicks % 60 == 0) {
            this.cat.m_5496_(SoundEvents.f_11790_, 1.0f, 1.0f);
        }
        if (this.meowTicks % 100 == 0) {
            pos = this.cat.m_20182_().m_82520_(0.0, 0.5, 0.0);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123792_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 6, 0.3, 0.3, 0.3, 0.01);
        }
        if (++this.meowTicks >= 300) {
            this.cat.m_5496_(SoundEvents.f_11789_, 1.0f, 1.0f);
            pos = this.cat.m_20182_().m_82520_(0.0, 0.5, 0.0);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123792_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 15, 0.3, 0.3, 0.3, 0.01);
            this.m_8041_();
        }
    }

    public void m_8041_() {
        this.bowlPos = null;
        this.meowTicks = 0;
        this.active = false;
        if (this.cat.m_21827_()) {
            this.cat.m_21839_(false);
        }
    }

    private boolean isNearBowl() {
        return this.bowlPos != null && this.cat.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.bowlPos)) < 1.2100000000000002;
    }
}

